/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskArg;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskRes;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusInfoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class IndexForceRebuildTask
extends VisorOneNodeTask<IndexForceRebuildTaskArg, IndexForceRebuildTaskRes> {
    private static final long serialVersionUID = 0L;

    protected IndexForceRebuildJob job(IndexForceRebuildTaskArg arg) {
        return new IndexForceRebuildJob(arg, this.debug);
    }

    private static class IndexForceRebuildJob
    extends VisorJob<IndexForceRebuildTaskArg, IndexForceRebuildTaskRes> {
        private static final long serialVersionUID = 0L;

        protected IndexForceRebuildJob(@Nullable IndexForceRebuildTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IndexForceRebuildTaskRes run(@Nullable IndexForceRebuildTaskArg arg) throws IgniteException {
            assert (arg.cacheNames() == null != (arg.cacheGrps() == null)) : "Either cacheNames or cacheGroups must be specified";
            Set<IndexRebuildStatusInfoContainer> rebuildIdxCaches = this.ignite.context().cache().publicCaches().stream().filter(c -> !c.indexReadyFuture().isDone()).map(this::fromIgniteCache).collect(Collectors.toSet());
            Set<String> rebuildIdxCachesNames = rebuildIdxCaches.stream().map(IndexRebuildStatusInfoContainer::cacheName).collect(Collectors.toSet());
            if (arg.cacheNames() != null) {
                return this.rebuildByCacheNames(arg.cacheNames(), rebuildIdxCaches, rebuildIdxCachesNames);
            }
            if (arg.cacheGrps() != null) {
                return this.rebuildByGroupNames(arg.cacheGrps(), rebuildIdxCaches, rebuildIdxCachesNames);
            }
            assert (false) : "Neither cache names nor cache groups specified";
            return null;
        }

        @NotNull
        private IndexForceRebuildTaskRes rebuildByCacheNames(Set<String> cacheNames, Set<IndexRebuildStatusInfoContainer> rebuildIdxCaches, Set<String> rebuildIdxCachesNames) {
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            HashSet<String> notFoundCaches = new HashSet<String>(cacheNames);
            notFoundCaches.removeIf(name -> cacheProcessor.cache((String)name) != null);
            Set<GridCacheContext> cacheContexts = cacheProcessor.publicCaches().stream().filter(c -> !rebuildIdxCachesNames.contains(c.getName())).filter(c -> cacheNames.contains(c.getName())).map(IgniteCacheProxy::context).collect(Collectors.toSet());
            Set<IndexRebuildStatusInfoContainer> cachesWithStartedRebuild = cacheContexts.stream().map(c -> new IndexRebuildStatusInfoContainer(c.config())).collect(Collectors.toSet());
            cacheProcessor.context().database().forceRebuildIndexes(cacheContexts);
            return new IndexForceRebuildTaskRes(cachesWithStartedRebuild, rebuildIdxCaches, notFoundCaches);
        }

        @NotNull
        private IndexForceRebuildTaskRes rebuildByGroupNames(Set<String> grpNames, Set<IndexRebuildStatusInfoContainer> rebuildIdxCaches, Set<String> rebuildIdxCachesNames) {
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            HashSet<String> notFoundGroups = new HashSet<String>(grpNames);
            notFoundGroups.removeIf(grpName -> cacheProcessor.cacheGroup(CU.cacheId(grpName)) != null);
            Set<GridCacheContext> cacheContexts = cacheProcessor.cacheGroups().stream().filter(grpContext -> grpNames.contains(grpContext.name())).map(CacheGroupContext::caches).flatMap(Collection::stream).filter(c -> !rebuildIdxCachesNames.contains(c.name())).collect(Collectors.toSet());
            Set<IndexRebuildStatusInfoContainer> cachesWithStartedRebuild = cacheContexts.stream().map(c -> new IndexRebuildStatusInfoContainer(c.config())).collect(Collectors.toSet());
            cacheProcessor.context().database().forceRebuildIndexes(cacheContexts);
            return new IndexForceRebuildTaskRes(cachesWithStartedRebuild, rebuildIdxCaches, notFoundGroups);
        }

        private IndexRebuildStatusInfoContainer fromIgniteCache(IgniteCache c) {
            return new IndexRebuildStatusInfoContainer(c.getConfiguration(CacheConfiguration.class));
        }
    }
}

