/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.DumpProcessor;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpProcessor;

public class PageLockLogSnapshot
implements PageLockDump {
    public final String name;
    public final long time;
    public final int headIdx;
    public final List<LogEntry> locklog;
    public final PageMetaInfoStore log;
    public final int nextOp;
    public final int nextOpStructureId;
    public final long nextOpPageId;

    public PageLockLogSnapshot(String name, long time, int headIdx, PageMetaInfoStore log, int nextOp, int nextOpStructureId, long nextOpPageId) {
        this.name = name;
        this.time = time;
        this.headIdx = headIdx;
        this.log = log;
        this.locklog = this.toList(log);
        this.nextOp = nextOp;
        this.nextOpStructureId = nextOpStructureId;
        this.nextOpPageId = nextOpPageId;
    }

    private List<LogEntry> toList(PageMetaInfoStore pages) {
        ArrayList<LogEntry> lockLog = new ArrayList<LogEntry>(pages.capacity());
        for (int itemIdx = 0; itemIdx < this.headIdx; ++itemIdx) {
            int metaOnLock = pages.getOperation(itemIdx);
            assert (metaOnLock != 0);
            int heldLocks = (metaOnLock & 0xFFFF0000) >> 16;
            assert (heldLocks >= 0);
            int op = metaOnLock & 0xFF;
            int structureId = pages.getStructureId(itemIdx);
            long pageId = pages.getPageId(itemIdx);
            lockLog.add(new LogEntry(pageId, structureId, op, heldLocks));
        }
        return lockLog;
    }

    @Override
    public void apply(DumpProcessor dumpProcessor) {
        dumpProcessor.processDump(this);
    }

    @Override
    public long time() {
        return this.time;
    }

    public String toString() {
        return ToStringDumpProcessor.toStringDump(this);
    }

    public static class LogEntry {
        public final long pageId;
        public final int structureId;
        public final int operation;
        public final int holdedLocks;

        public LogEntry(long pageId, int structureId, int operation, int holdedLock) {
            this.pageId = pageId;
            this.structureId = structureId;
            this.operation = operation;
            this.holdedLocks = holdedLock;
        }
    }
}

