/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.primitive;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroSimpleSchema;
import java.util.function.Consumer;

public class AvroLongSchema
extends AvroSimpleSchema {
    private long n;
    private long shift = 7L;
    private boolean first = true;
    private int lastB;

    public AvroLongSchema(AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
    }

    @Override
    public void progress() {
        if (!this.first && (this.lastB & 0x80) == 0) {
            this.n = this.n >> 1 ^ -(this.n & 1L);
            this.done = true;
            this.result = this.n;
            return;
        }
        int b = this.state.read() & 0xFF;
        if (this.first) {
            this.n = b & 0x7F;
            this.first = false;
            this.lastB = b;
            if ((b & 0x80) != 0) {
                return;
            }
            this.n = this.n >> 1 ^ -(this.n & 1L);
            this.result = this.n;
            this.done = true;
        } else {
            this.n |= (long)((b & 0x7F) << (int)this.shift);
            this.shift += 7L;
            this.lastB = b;
        }
    }

    @Override
    public boolean canProgress() {
        return this.state.sizeGreaterThan(1L);
    }
}

