/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CommandRegistryImpl;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.baseline.AbstractBaselineCommand;
import org.apache.ignite.internal.management.baseline.BaselineAddCommand;
import org.apache.ignite.internal.management.baseline.BaselineAutoAdjustCommand;
import org.apache.ignite.internal.management.baseline.BaselineCommandArg;
import org.apache.ignite.internal.management.baseline.BaselineRemoveCommand;
import org.apache.ignite.internal.management.baseline.BaselineSetCommand;
import org.apache.ignite.internal.management.baseline.BaselineTask;
import org.apache.ignite.internal.management.baseline.BaselineTaskResult;
import org.apache.ignite.internal.management.baseline.BaselineVersionCommand;

public class BaselineCommand
extends CommandRegistryImpl<BaselineTaskArg, BaselineTaskResult>
implements ComputeCommand<BaselineTaskArg, BaselineTaskResult> {
    @Override
    public String description() {
        return "Print cluster baseline topology";
    }

    public BaselineCommand() {
        super(new BaselineAddCommand(), new BaselineRemoveCommand(), new BaselineSetCommand(), new BaselineVersionCommand(), new BaselineAutoAdjustCommand());
    }

    @Override
    public Class<BaselineCommandArg> argClass() {
        return BaselineCommandArg.class;
    }

    @Override
    public Class<BaselineTask> taskClass() {
        return BaselineTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, BaselineTaskArg arg) {
        return CommandUtils.coordinatorOrNull(nodes);
    }

    @Override
    public void printResult(BaselineTaskArg arg, BaselineTaskResult res, Consumer<String> printer) {
        new AbstractBaselineCommand(){

            @Override
            public String description() {
                return null;
            }

            @Override
            public Class<? extends BaselineTaskArg> argClass() {
                return null;
            }
        }.printResult(arg, res, printer);
    }

    public static abstract class BaselineTaskArg
    extends IgniteDataTransferObject {
        @Argument(optional=true, description="Show the full list of node ips")
        private boolean verbose;

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeBoolean(this.verbose);
        }

        @Override
        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.verbose = in.readBoolean();
        }

        public boolean verbose() {
            return this.verbose;
        }

        public void verbose(boolean verbose) {
            this.verbose = verbose;
        }
    }
}

