/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server.time;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.failure.FailureType;
import org.apache.ignite3.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.metrics.MetaStorageMetrics;
import org.apache.ignite3.internal.metastorage.server.time.ClusterTime;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClusterTimeImpl
implements ClusterTime,
MetaStorageMetrics,
ManuallyCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterTimeImpl.class);
    private final String nodeName;
    private final IgniteSpinBusyLock busyLock;
    private final HybridClock clock;
    private final FailureProcessor failureProcessor;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTime = new PendingComparableValuesTracker(HybridTimestamp.MIN_VALUE);
    @Nullable
    private SafeTimeScheduler safeTimeScheduler;
    private long lastSchedulerStoppedTerm = -1L;

    @Override
    public long safeTimeLag() {
        return this.clock.now().getPhysical() - this.safeTime.current().getPhysical();
    }

    @TestOnly
    public ClusterTimeImpl(String nodeName, IgniteSpinBusyLock busyLock, HybridClock clock) {
        this(nodeName, busyLock, clock, new FailureManager(new NoOpFailureHandler()));
    }

    public ClusterTimeImpl(String nodeName, IgniteSpinBusyLock busyLock, HybridClock clock, FailureProcessor failureProcessor) {
        this.nodeName = nodeName;
        this.busyLock = busyLock;
        this.clock = clock;
        this.failureProcessor = failureProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSafeTimeScheduler(SyncTimeAction syncTimeAction, SystemDistributedConfiguration configuration, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            ClusterTimeImpl clusterTimeImpl = this;
            synchronized (clusterTimeImpl) {
                block10: {
                    if (this.lastSchedulerStoppedTerm <= term) break block10;
                    return;
                }
                assert (this.safeTimeScheduler == null);
                this.safeTimeScheduler = new SafeTimeScheduler(syncTimeAction, configuration);
                this.safeTimeScheduler.start();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public synchronized void stopSafeTimeScheduler(long term) {
        this.lastSchedulerStoppedTerm = term;
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.stop();
            this.safeTimeScheduler = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.stopSafeTimeScheduler(Long.MAX_VALUE);
        this.safeTime.close(new NodeStoppingException());
    }

    @Override
    public HybridTimestamp currentSafeTime() {
        return this.safeTime.current();
    }

    @Override
    public CompletableFuture<Void> waitFor(HybridTimestamp time) {
        return this.safeTime.waitFor(time);
    }

    public void updateSafeTime(HybridTimestamp newValue) {
        this.safeTime.update(newValue, null);
    }

    public synchronized void adjustClock(HybridTimestamp ts) {
        this.clock.update(ts);
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.schedule();
        }
    }

    private class SafeTimeScheduler {
        private final SyncTimeAction syncTimeAction;
        private final SystemDistributedConfiguration configuration;
        private final ScheduledExecutorService executorService;
        @Nullable
        private ScheduledFuture<?> currentTask;

        SafeTimeScheduler(SyncTimeAction syncTimeAction, SystemDistributedConfiguration configuration) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(ClusterTimeImpl.this.nodeName, "meta-storage-safe-time", LOG, new ThreadOperation[0]));
            this.syncTimeAction = syncTimeAction;
            this.configuration = configuration;
        }

        void start() {
            this.schedule();
            LOG.info("Started safe time scheduler", new Object[0]);
        }

        synchronized void schedule() {
            if (this.currentTask != null) {
                this.currentTask.cancel(false);
            }
            this.currentTask = this.executorService.schedule(() -> {
                block3: {
                    try {
                        this.tryToSyncTimeAndReschedule();
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    catch (Throwable t) {
                        ClusterTimeImpl.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, t));
                        if (!(t instanceof Error)) break block3;
                        throw t;
                    }
                }
            }, (long)((Long)this.configuration.idleSafeTimeSyncIntervalMillis().value()), TimeUnit.MILLISECONDS);
        }

        private void tryToSyncTimeAndReschedule() {
            if (!ClusterTimeImpl.this.busyLock.enterBusy()) {
                return;
            }
            try {
                this.syncTimeAction.syncTime(ClusterTimeImpl.this.clock.now()).whenComplete((v, e) -> {
                    if (e != null && !ExceptionUtils.hasCause(e, NodeStoppingException.class)) {
                        ClusterTimeImpl.this.failureProcessor.process(new FailureContext((Throwable)e, "Unable to perform idle time sync"));
                    }
                });
                this.schedule();
            }
            finally {
                ClusterTimeImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            LOG.info("Stopping safe time scheduler", new Object[0]);
            SafeTimeScheduler safeTimeScheduler = this;
            synchronized (safeTimeScheduler) {
                if (this.currentTask != null) {
                    this.currentTask.cancel(false);
                }
            }
            IgniteUtils.shutdownAndAwaitTermination(this.executorService, 10L, TimeUnit.SECONDS);
        }
    }

    @FunctionalInterface
    public static interface SyncTimeAction {
        public CompletableFuture<Void> syncTime(HybridTimestamp var1);
    }
}

