/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class RenameIndexEntry
implements UpdateEntry {
    public static final CatalogObjectSerializer<RenameIndexEntry> SERIALIZER = new RenameIndexEntrySerializer();
    private final int indexId;
    private final String newIndexName;

    public RenameIndexEntry(int indexId, String newIndexName) {
        this.indexId = indexId;
        this.newIndexName = newIndexName;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.RENAME_INDEX.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogIndexDescriptor indexDescriptor = CatalogUtils.indexOrThrow(catalog, this.indexId);
        CatalogTableDescriptor tableDescriptor = CatalogUtils.tableOrThrow(catalog, indexDescriptor.tableId());
        CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schemaOrThrow(catalog, tableDescriptor.schemaId());
        CatalogIndexDescriptor newIndexDescriptor = this.changeIndexName(indexDescriptor, causalityToken);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(CatalogUtils.replaceIndex(schemaDescriptor, newIndexDescriptor), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    private CatalogIndexDescriptor changeIndexName(CatalogIndexDescriptor indexDescriptor, long causalityToken) {
        CatalogIndexDescriptor newIndexDescriptor;
        if (indexDescriptor instanceof CatalogHashIndexDescriptor) {
            newIndexDescriptor = this.changeHashIndexName((CatalogHashIndexDescriptor)indexDescriptor);
        } else if (indexDescriptor instanceof CatalogSortedIndexDescriptor) {
            newIndexDescriptor = this.changeSortedIndexName((CatalogSortedIndexDescriptor)indexDescriptor);
        } else {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Unsupported index type '{}' {}", (Object[])new Object[]{indexDescriptor.id(), indexDescriptor}));
        }
        newIndexDescriptor.updateToken(causalityToken);
        return newIndexDescriptor;
    }

    private CatalogIndexDescriptor changeHashIndexName(CatalogHashIndexDescriptor index) {
        return new CatalogHashIndexDescriptor(index.id(), this.newIndexName, index.tableId(), index.unique(), index.status(), index.columns(), index.isCreatedWithTable());
    }

    private CatalogIndexDescriptor changeSortedIndexName(CatalogSortedIndexDescriptor index) {
        return new CatalogSortedIndexDescriptor(index.id(), this.newIndexName, index.tableId(), index.unique(), index.status(), index.columns(), index.isCreatedWithTable());
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class RenameIndexEntrySerializer
    implements CatalogObjectSerializer<RenameIndexEntry> {
        private RenameIndexEntrySerializer() {
        }

        @Override
        public RenameIndexEntry readFrom(IgniteDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            String newIndexName = input.readUTF();
            return new RenameIndexEntry(indexId, newIndexName);
        }

        @Override
        public void writeTo(RenameIndexEntry entry, IgniteDataOutput out) throws IOException {
            out.writeVarInt((long)entry.indexId);
            out.writeUTF(entry.newIndexName);
        }
    }
}

