/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.rest.api.InvalidParam;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.Builder;
import org.jetbrains.annotations.Nullable;

public class Problem {
    private final String title;
    private final int status;
    private final String code;
    private final String type;
    private final String detail;
    private final String node;
    private final UUID traceId;
    private final Collection<InvalidParam> invalidParams;

    @JsonCreator
    protected Problem(@JsonProperty(value="title") String title, @JsonProperty(value="status") int status, @JsonProperty(value="code") String code, @JsonProperty(value="type") @Nullable String type, @JsonProperty(value="detail") @Nullable String detail, @JsonProperty(value="node") @Nullable String node, @JsonProperty(value="traceId") @Nullable UUID traceId, @JsonProperty(value="invalidParams") @Nullable Collection<InvalidParam> invalidParams) {
        this.title = title;
        this.status = status;
        this.code = code;
        this.type = type;
        this.detail = detail;
        this.node = node;
        this.traceId = traceId;
        this.invalidParams = invalidParams;
    }

    public static <T extends Problem, B extends ProblemBuilder<T, B>> ProblemBuilder<T, B> builder() {
        return new ProblemBuilder();
    }

    public static <T extends Problem, B extends ProblemBuilder<T, B>> ProblemBuilder<T, B> fromHttpCode(HttpCode httpCode) {
        ProblemBuilder builder = new ProblemBuilder();
        builder.status(httpCode.code());
        builder.title(httpCode.message());
        return builder;
    }

    @JsonGetter(value="title")
    public String title() {
        return this.title;
    }

    @JsonGetter(value="status")
    public int status() {
        return this.status;
    }

    @JsonGetter(value="code")
    public String code() {
        return this.code;
    }

    @JsonGetter(value="type")
    public String type() {
        return this.type;
    }

    @JsonGetter(value="detail")
    public String detail() {
        return this.detail;
    }

    @JsonGetter(value="node")
    public String node() {
        return this.node;
    }

    @JsonGetter(value="traceId")
    public UUID traceId() {
        return this.traceId;
    }

    @JsonGetter(value="invalidParams")
    public Collection<InvalidParam> invalidParams() {
        return this.invalidParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return this.status == problem.status && Objects.equals(this.title, problem.title) && Objects.equals(this.code, problem.code) && Objects.equals(this.type, problem.type) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.node, problem.node) && Objects.equals(this.traceId, problem.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.status, this.code, this.type, this.detail, this.node, this.traceId);
    }

    public String toString() {
        return "Problem{title='" + this.title + "', status=" + this.status + ", code='" + this.code + "', type='" + this.type + "', detail='" + this.detail + "', node='" + this.node + "', invalidParams='" + this.invalidParams + "', traceId=" + this.traceId + "}";
    }

    public static class ProblemBuilder<T extends Problem, B extends ProblemBuilder<T, B>>
    implements Builder<T, B> {
        protected String title;
        protected int status;
        protected String code;
        protected String type;
        protected String detail;
        protected String node;
        protected UUID traceId;
        protected Collection<InvalidParam> invalidParams;

        public B title(String title) {
            this.title = title;
            return (B)this;
        }

        public B status(int status) {
            this.status = status;
            return (B)this;
        }

        public B code(String code) {
            this.code = code;
            return (B)this;
        }

        public B type(String type) {
            this.type = type;
            return (B)this;
        }

        public B detail(String detail) {
            this.detail = detail;
            return (B)this;
        }

        public B node(String node) {
            this.node = node;
            return (B)this;
        }

        public B traceId(UUID traceId) {
            this.traceId = traceId;
            return (B)this;
        }

        public B invalidParams(Collection<InvalidParam> invalidParams) {
            this.invalidParams = invalidParams;
            return (B)this;
        }

        @Override
        public T build() {
            return (T)new Problem(this.title, this.status, this.code, this.type, this.detail, this.node, this.traceId, this.invalidParams);
        }
    }
}

