/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.hint;

import java.util.Arrays;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.HintStrategy;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.util.Litmus;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.hint.HintOptionsChecker;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public final class HintsConfig {
    static final HintOptionsChecker OPTS_CHECK_NO_KV = new HintOptionsChecker(){

        @Override
        @Nullable
        public String apply(RelHint hint) {
            return hint.kvOptions.isEmpty() ? null : String.format("Hint '%s' can't have any key-value option (not supported).", hint.hintName);
        }
    };
    static final HintOptionsChecker OPTS_CHECK_EMPTY = new HintOptionsChecker(){

        @Override
        @Nullable
        public String apply(RelHint hint) {
            String noKv = (String)OPTS_CHECK_NO_KV.apply(hint);
            if (noKv != null) {
                return noKv;
            }
            return hint.kvOptions.isEmpty() && hint.listOptions.isEmpty() ? null : String.format("Hint '%s' can't have any option.", hint.hintName);
        }
    };
    static final HintOptionsChecker OPTS_CHECK_PLAIN = new HintOptionsChecker(){

        @Override
        @Nullable
        public String apply(RelHint hint) {
            String noKv = (String)OPTS_CHECK_NO_KV.apply(hint);
            if (noKv != null) {
                return noKv;
            }
            return !hint.listOptions.isEmpty() ? null : String.format("Hint '%s' must have at least one option.", hint.hintName);
        }
    };

    private HintsConfig() {
    }

    public static HintStrategyTable buildHintTable() {
        HintStrategyTable.Builder b = HintStrategyTable.builder().errorHandler(Litmus.IGNORE);
        RelOptRule[] disabledRulesTpl = new RelOptRule[]{};
        Arrays.stream(HintDefinition.values()).forEach(hintDef -> b.hintStrategy(hintDef.name(), HintStrategy.builder((HintPredicate)HintsConfig.hintPredicate(hintDef)).excludedRules(hintDef.disabledRules().toArray(disabledRulesTpl)).build()));
        return b.build();
    }

    private static HintPredicate hintPredicate(final HintDefinition hintDef) {
        if (F.isEmpty(hintDef.disabledRules())) {
            return hintDef.predicate();
        }
        return new HintPredicate(){

            public boolean apply(RelHint hint, RelNode rel) {
                if (!hintDef.predicate().apply(hint, rel)) {
                    return false;
                }
                String optsErrMsg = (String)hintDef.optionsChecker().apply(hint);
                if (F.isEmpty((String)optsErrMsg)) {
                    return true;
                }
                HintUtils.skippedHint(rel, hint, optsErrMsg);
                return false;
            }
        };
    }
}

