/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ReduceBlockList<Z>
extends AbstractList<Z>
implements RandomAccess {
    private final List<List<Z>> blocks;
    private int size;
    private final int maxBlockSize;
    private final int shift;
    private final int mask;

    public ReduceBlockList(int maxBlockSize) {
        assert (U.isPow2((int)maxBlockSize));
        this.maxBlockSize = maxBlockSize;
        this.shift = Integer.numberOfTrailingZeros(maxBlockSize);
        this.mask = maxBlockSize - 1;
        this.blocks = new ArrayList<List<Z>>();
        this.blocks.add(new ArrayList());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Z z) {
        ++this.size;
        List<Z> lastBlock = this.lastBlock();
        lastBlock.add(z);
        if (lastBlock.size() == this.maxBlockSize) {
            this.blocks.add(new ArrayList());
        }
        return true;
    }

    @Override
    public Z get(int idx) {
        return this.blocks.get(idx >>> this.shift).get(idx & this.mask);
    }

    public List<Z> lastBlock() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    public List<Z> evictFirstBlock() {
        List<Z> res = this.blocks.remove(0);
        this.size -= res.size();
        return res;
    }
}

