/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.snowflake.bulkloader;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderField;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SnowflakeBulkLoaderDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SnowflakeBulkLoaderMeta.class;
    private static final String[] LOCATION_TYPE_COMBO = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.LocationType.User", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.LocationType.Table", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.LocationType.InternalStage", (String[])new String[0])};
    private static final String[] ON_ERROR_COMBO = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.OnError.Continue", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.OnError.SkipFile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.OnError.SkipFilePercent", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.OnError.Abort", (String[])new String[0])};
    private static final String[] DATA_TYPE_COMBO = new String[]{BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.DataType.CSV", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoad.Dialog.DataType.JSON", (String[])new String[0])};
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private CCombo wLocationType;
    private ComboVar wStageName;
    private TextVar wWorkDirectory;
    private CCombo wOnError;
    private Label wlErrorLimit;
    private TextVar wErrorLimit;
    private TextVar wSplitSize;
    private Button wRemoveFiles;
    private CCombo wDataType;
    private Group gCsvGroup;
    private Button wTrimWhitespace;
    private TextVar wNullIf;
    private Button wColumnMismatch;
    private Group gJsonGroup;
    private Button wStripNull;
    private Button wIgnoreUtf8;
    private Button wAllowDuplicate;
    private Button wEnableOctal;
    private Button wSpecifyFields;
    private Label wlJsonField;
    private CCombo wJsonField;
    private TableView wFields;
    private ColumnInfo[] colinf;
    private Button wDoMapping;
    private SnowflakeBulkLoaderMeta input;
    private Link wDevelopedBy;
    private FormData fdDevelopedBy;
    private final List<String> inputFields = new ArrayList<String>();
    private Display display;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public SnowflakeBulkLoaderDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (SnowflakeBulkLoaderMeta)((Object)in);
        this.pipelineMeta = pipelineMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        SnowflakeBulkLoaderDialog snowflakeBulkLoaderDialog = this;
        int margin = snowflakeBulkLoaderDialog.props.getMargin();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter bMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnowflakeBulkLoaderDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsFlags = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnowflakeBulkLoaderDialog.this.setFlags();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wLoaderTab = new CTabItem(wTabFolder, 0);
        wLoaderTab.setFont(GuiResource.getInstance().getFontDefault());
        wLoaderTab.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.LoaderTab.TabTitle", (String[])new String[0]));
        Composite wLoaderComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wLoaderComp);
        FormLayout loaderLayout = new FormLayout();
        loaderLayout.marginWidth = 3;
        loaderLayout.marginHeight = 3;
        wLoaderComp.setLayout((Layout)loaderLayout);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        if (this.input.getConnection() == null && this.pipelineMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        Label wlSchema = new Label(wLoaderComp, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.Schema.Label", (String[])new String[0]));
        wlSchema.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.Schema.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdlSchema.right = new FormAttachment(middle, -margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button(wLoaderComp, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, wLoaderComp, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wSchema.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SnowflakeBulkLoaderDialog.this.setTableFieldCombo();
            }
        });
        Label wlTable = new Label(wLoaderComp, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.Table.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button(wLoaderComp, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, wLoaderComp, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        this.wTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SnowflakeBulkLoaderDialog.this.setTableFieldCombo();
            }
        });
        Label wlLocationType = new Label(wLoaderComp, 131072);
        wlLocationType.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.LocationType.Label", (String[])new String[0]));
        wlLocationType.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.LocationType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLocationType);
        FormData fdlLocationType = new FormData();
        fdlLocationType.left = new FormAttachment(0, 0);
        fdlLocationType.top = new FormAttachment((Control)this.wTable, margin * 2);
        fdlLocationType.right = new FormAttachment(middle, -margin);
        wlLocationType.setLayoutData((Object)fdlLocationType);
        this.wLocationType = new CCombo(wLoaderComp, 2056);
        this.wLocationType.setEditable(false);
        PropsUi.setLook((Widget)this.wLocationType);
        this.wLocationType.addModifyListener(lsMod);
        this.wLocationType.addSelectionListener((SelectionListener)lsFlags);
        FormData fdLocationType = new FormData();
        fdLocationType.left = new FormAttachment(middle, 0);
        fdLocationType.top = new FormAttachment((Control)this.wTable, margin * 2);
        fdLocationType.right = new FormAttachment(100, 0);
        this.wLocationType.setLayoutData((Object)fdLocationType);
        for (String locationType : LOCATION_TYPE_COMBO) {
            this.wLocationType.add(locationType);
        }
        Label wlStageName = new Label(wLoaderComp, 131072);
        wlStageName.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.StageName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStageName);
        FormData fdlStageName = new FormData();
        fdlStageName.left = new FormAttachment(0, 0);
        fdlStageName.top = new FormAttachment((Control)this.wLocationType, margin * 2);
        fdlStageName.right = new FormAttachment(middle, -margin);
        wlStageName.setLayoutData((Object)fdlStageName);
        this.wStageName = new ComboVar(this.variables, wLoaderComp, 18436);
        PropsUi.setLook((Widget)this.wStageName);
        this.wStageName.addModifyListener(lsMod);
        this.wStageName.addSelectionListener((SelectionListener)lsFlags);
        FormData fdStageName = new FormData();
        fdStageName.left = new FormAttachment(middle, 0);
        fdStageName.top = new FormAttachment((Control)this.wLocationType, margin * 2);
        fdStageName.right = new FormAttachment(100, 0);
        this.wStageName.setLayoutData((Object)fdStageName);
        this.wStageName.setEnabled(false);
        this.wStageName.addFocusListener((FocusListener)new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent focusEvent) {
                String stageNameText = SnowflakeBulkLoaderDialog.this.wStageName.getText();
                SnowflakeBulkLoaderDialog.this.wStageName.removeAll();
                DatabaseMeta databaseMeta = SnowflakeBulkLoaderDialog.this.pipelineMeta.findDatabase(SnowflakeBulkLoaderDialog.this.wConnection.getText(), SnowflakeBulkLoaderDialog.this.variables);
                if (databaseMeta != null) {
                    Database db = new Database(BaseTransformDialog.loggingObject, SnowflakeBulkLoaderDialog.this.variables, databaseMeta);
                    try {
                        db.connect();
                        Object sql = "show stages";
                        if (!StringUtils.isEmpty((CharSequence)SnowflakeBulkLoaderDialog.this.variables.resolve(SnowflakeBulkLoaderDialog.this.wSchema.getText()))) {
                            sql = (String)sql + " in " + SnowflakeBulkLoaderDialog.this.variables.resolve(SnowflakeBulkLoaderDialog.this.wSchema.getText());
                        }
                        try (ResultSet resultSet = db.openQuery((String)sql, null, null, 1000, false);){
                            IRowMeta rowMeta = db.getReturnRowMeta();
                            Object[] row = db.getRow(resultSet);
                            int nameField = rowMeta.indexOfValue("NAME");
                            if (nameField >= 0) {
                                while (row != null) {
                                    String stageName = rowMeta.getString(row, nameField);
                                    SnowflakeBulkLoaderDialog.this.wStageName.add(stageName);
                                    row = db.getRow(resultSet);
                                }
                            } else {
                                throw new HopException("Unable to find stage name field in result");
                            }
                            db.closeQuery(resultSet);
                        }
                        if (stageNameText != null) {
                            SnowflakeBulkLoaderDialog.this.wStageName.setText(stageNameText);
                        }
                    }
                    catch (Exception ex) {
                        SnowflakeBulkLoaderDialog.this.logDebug("Error getting stages", new Object[]{ex});
                    }
                    finally {
                        try {
                            db.disconnect();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        Label wlWorkDirectory = new Label(wLoaderComp, 131072);
        wlWorkDirectory.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.WorkDirectory.Label", (String[])new String[0]));
        wlWorkDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.WorkDirectory.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorkDirectory);
        FormData fdlWorkDirectory = new FormData();
        fdlWorkDirectory.left = new FormAttachment(0, 0);
        fdlWorkDirectory.top = new FormAttachment((Control)this.wStageName, margin);
        fdlWorkDirectory.right = new FormAttachment(middle, -margin);
        wlWorkDirectory.setLayoutData((Object)fdlWorkDirectory);
        Button wbWorkDirectory = new Button(wLoaderComp, 0x1000008);
        PropsUi.setLook((Widget)wbWorkDirectory);
        wbWorkDirectory.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbWorkDirectory = new FormData();
        fdbWorkDirectory.right = new FormAttachment(100, 0);
        fdbWorkDirectory.top = new FormAttachment((Control)this.wStageName, margin);
        wbWorkDirectory.setLayoutData((Object)fdbWorkDirectory);
        this.wWorkDirectory = new TextVar(this.variables, wLoaderComp, 18436);
        this.wWorkDirectory.setText("temp");
        PropsUi.setLook((Widget)this.wWorkDirectory);
        this.wWorkDirectory.addModifyListener(lsMod);
        FormData fdWorkDirectory = new FormData();
        fdWorkDirectory.left = new FormAttachment(middle, 0);
        fdWorkDirectory.top = new FormAttachment((Control)this.wStageName, margin);
        fdWorkDirectory.right = new FormAttachment((Control)wbWorkDirectory, -margin);
        this.wWorkDirectory.setLayoutData((Object)fdWorkDirectory);
        wbWorkDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wWorkDirectory, (IVariables)this.variables));
        this.wWorkDirectory.addModifyListener(e -> this.wWorkDirectory.setToolTipText(this.variables.resolve(this.wWorkDirectory.getText())));
        Label wlOnError = new Label(wLoaderComp, 131072);
        wlOnError.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.OnError.Label", (String[])new String[0]));
        wlOnError.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.OnError.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnError);
        FormData fdlOnError = new FormData();
        fdlOnError.left = new FormAttachment(0, 0);
        fdlOnError.top = new FormAttachment((Control)this.wWorkDirectory, margin * 2);
        fdlOnError.right = new FormAttachment(middle, -margin);
        wlOnError.setLayoutData((Object)fdlOnError);
        this.wOnError = new CCombo(wLoaderComp, 2056);
        this.wOnError.setEditable(false);
        PropsUi.setLook((Widget)this.wOnError);
        this.wOnError.addModifyListener(lsMod);
        this.wOnError.addSelectionListener((SelectionListener)lsFlags);
        FormData fdOnError = new FormData();
        fdOnError.left = new FormAttachment(middle, 0);
        fdOnError.top = new FormAttachment((Control)this.wWorkDirectory, margin * 2);
        fdOnError.right = new FormAttachment(100, 0);
        this.wOnError.setLayoutData((Object)fdOnError);
        for (String onError : ON_ERROR_COMBO) {
            this.wOnError.add(onError);
        }
        this.wlErrorLimit = new Label(wLoaderComp, 131072);
        this.wlErrorLimit.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorCountLimit.Label", (String[])new String[0]));
        this.wlErrorLimit.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorCountLimit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorLimit);
        FormData fdlErrorLimit = new FormData();
        fdlErrorLimit.left = new FormAttachment(0, 0);
        fdlErrorLimit.top = new FormAttachment((Control)this.wOnError, margin);
        fdlErrorLimit.right = new FormAttachment(middle, -margin);
        this.wlErrorLimit.setLayoutData((Object)fdlErrorLimit);
        this.wErrorLimit = new TextVar(this.variables, wLoaderComp, 18436);
        PropsUi.setLook((Widget)this.wErrorLimit);
        this.wErrorLimit.addModifyListener(lsMod);
        FormData fdErrorLimit = new FormData();
        fdErrorLimit.left = new FormAttachment(middle, 0);
        fdErrorLimit.top = new FormAttachment((Control)this.wOnError, margin);
        fdErrorLimit.right = new FormAttachment(100, 0);
        this.wErrorLimit.setLayoutData((Object)fdErrorLimit);
        Label wlSplitSize = new Label(wLoaderComp, 131072);
        wlSplitSize.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.SplitSize.Label", (String[])new String[0]));
        wlSplitSize.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.SplitSize.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSplitSize);
        FormData fdlSplitSize = new FormData();
        fdlSplitSize.left = new FormAttachment(0, 0);
        fdlSplitSize.top = new FormAttachment((Control)this.wErrorLimit, margin);
        fdlSplitSize.right = new FormAttachment(middle, -margin);
        wlSplitSize.setLayoutData((Object)fdlSplitSize);
        this.wSplitSize = new TextVar(this.variables, wLoaderComp, 18436);
        PropsUi.setLook((Widget)this.wSplitSize);
        this.wSplitSize.addModifyListener(lsMod);
        FormData fdSplitSize = new FormData();
        fdSplitSize.left = new FormAttachment(middle, 0);
        fdSplitSize.top = new FormAttachment((Control)this.wErrorLimit, margin);
        fdSplitSize.right = new FormAttachment(100, 0);
        this.wSplitSize.setLayoutData((Object)fdSplitSize);
        Label wlRemoveFiles = new Label(wLoaderComp, 131072);
        wlRemoveFiles.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.RemoveFiles.Label", (String[])new String[0]));
        wlRemoveFiles.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.RemoveFiles.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRemoveFiles);
        FormData fdlRemoveFiles = new FormData();
        fdlRemoveFiles.left = new FormAttachment(0, 0);
        fdlRemoveFiles.top = new FormAttachment((Control)this.wSplitSize, margin);
        fdlRemoveFiles.right = new FormAttachment(middle, -margin);
        wlRemoveFiles.setLayoutData((Object)fdlRemoveFiles);
        this.wRemoveFiles = new Button(wLoaderComp, 32);
        PropsUi.setLook((Widget)this.wRemoveFiles);
        FormData fdRemoveFiles = new FormData();
        fdRemoveFiles.left = new FormAttachment(middle, 0);
        fdRemoveFiles.top = new FormAttachment((Control)this.wSplitSize, margin);
        fdRemoveFiles.right = new FormAttachment(100, 0);
        this.wRemoveFiles.setLayoutData((Object)fdRemoveFiles);
        this.wRemoveFiles.addSelectionListener((SelectionListener)bMod);
        FormData fdLoaderComp = new FormData();
        fdLoaderComp.left = new FormAttachment(0, 0);
        fdLoaderComp.top = new FormAttachment(0, 0);
        fdLoaderComp.right = new FormAttachment(100, 0);
        fdLoaderComp.bottom = new FormAttachment(100, 0);
        wLoaderComp.setLayoutData((Object)fdLoaderComp);
        wLoaderComp.layout();
        wLoaderTab.setControl((Control)wLoaderComp);
        CTabItem wDataTypeTab = new CTabItem(wTabFolder, 0);
        wDataTypeTab.setFont(GuiResource.getInstance().getFontDefault());
        wDataTypeTab.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DataTypeTab.TabTitle", (String[])new String[0]));
        Composite wDataTypeComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wDataTypeComp);
        FormLayout dataTypeLayout = new FormLayout();
        dataTypeLayout.marginWidth = 3;
        dataTypeLayout.marginHeight = 3;
        wDataTypeComp.setLayout((Layout)dataTypeLayout);
        Label wlDataType = new Label(wDataTypeComp, 131072);
        wlDataType.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DataType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataType);
        FormData fdlDataType = new FormData();
        fdlDataType.left = new FormAttachment(0, 0);
        fdlDataType.top = new FormAttachment(0, margin);
        fdlDataType.right = new FormAttachment(middle, -margin);
        wlDataType.setLayoutData((Object)fdlDataType);
        this.wDataType = new CCombo(wDataTypeComp, 2056);
        this.wDataType.setEditable(false);
        PropsUi.setLook((Widget)this.wDataType);
        this.wDataType.addModifyListener(lsMod);
        this.wDataType.addSelectionListener((SelectionListener)lsFlags);
        FormData fdDataType = new FormData();
        fdDataType.left = new FormAttachment(middle, 0);
        fdDataType.top = new FormAttachment(0, margin);
        fdDataType.right = new FormAttachment(100, 0);
        this.wDataType.setLayoutData((Object)fdDataType);
        for (String dataType : DATA_TYPE_COMBO) {
            this.wDataType.add(dataType);
        }
        this.gCsvGroup = new Group(wDataTypeComp, 16);
        this.gCsvGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.CSVGroup.Label", (String[])new String[0]));
        FormLayout csvLayout = new FormLayout();
        csvLayout.marginWidth = 3;
        csvLayout.marginHeight = 3;
        this.gCsvGroup.setLayout((Layout)csvLayout);
        PropsUi.setLook((Widget)this.gCsvGroup);
        FormData fdgCsvGroup = new FormData();
        fdgCsvGroup.left = new FormAttachment(0, 0);
        fdgCsvGroup.right = new FormAttachment(100, 0);
        fdgCsvGroup.top = new FormAttachment((Control)this.wDataType, margin * 2);
        fdgCsvGroup.bottom = new FormAttachment(100, -margin * 2);
        this.gCsvGroup.setLayoutData((Object)fdgCsvGroup);
        Label wlTrimWhitespace = new Label((Composite)this.gCsvGroup, 131072);
        wlTrimWhitespace.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.TrimWhitespace.Label", (String[])new String[0]));
        wlTrimWhitespace.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.TrimWhitespace.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrimWhitespace);
        FormData fdlTrimWhitespace = new FormData();
        fdlTrimWhitespace.left = new FormAttachment(0, 0);
        fdlTrimWhitespace.top = new FormAttachment(0, margin);
        fdlTrimWhitespace.right = new FormAttachment(middle, -margin);
        wlTrimWhitespace.setLayoutData((Object)fdlTrimWhitespace);
        this.wTrimWhitespace = new Button((Composite)this.gCsvGroup, 32);
        PropsUi.setLook((Widget)this.wTrimWhitespace);
        FormData fdTrimWhitespace = new FormData();
        fdTrimWhitespace.left = new FormAttachment(middle, 0);
        fdTrimWhitespace.top = new FormAttachment(0, margin);
        fdTrimWhitespace.right = new FormAttachment(100, 0);
        this.wTrimWhitespace.setLayoutData((Object)fdTrimWhitespace);
        this.wTrimWhitespace.addSelectionListener((SelectionListener)bMod);
        Label wlNullIf = new Label((Composite)this.gCsvGroup, 131072);
        wlNullIf.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.NullIf.Label", (String[])new String[0]));
        wlNullIf.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.NullIf.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNullIf);
        FormData fdlNullIf = new FormData();
        fdlNullIf.left = new FormAttachment(0, 0);
        fdlNullIf.top = new FormAttachment((Control)this.wTrimWhitespace, margin);
        fdlNullIf.right = new FormAttachment(middle, -margin);
        wlNullIf.setLayoutData((Object)fdlNullIf);
        this.wNullIf = new TextVar(this.variables, (Composite)this.gCsvGroup, 18436);
        PropsUi.setLook((Widget)this.wNullIf);
        this.wNullIf.addModifyListener(lsMod);
        FormData fdNullIf = new FormData();
        fdNullIf.left = new FormAttachment(middle, 0);
        fdNullIf.top = new FormAttachment((Control)this.wTrimWhitespace, margin);
        fdNullIf.right = new FormAttachment(100, 0);
        this.wNullIf.setLayoutData((Object)fdNullIf);
        Label wlColumnMismatch = new Label((Composite)this.gCsvGroup, 131072);
        wlColumnMismatch.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ColumnMismatch.Label", (String[])new String[0]));
        wlColumnMismatch.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ColumnMismatch.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlColumnMismatch);
        FormData fdlColumnMismatch = new FormData();
        fdlColumnMismatch.left = new FormAttachment(0, 0);
        fdlColumnMismatch.top = new FormAttachment((Control)this.wNullIf, margin);
        fdlColumnMismatch.right = new FormAttachment(middle, -margin);
        wlColumnMismatch.setLayoutData((Object)fdlColumnMismatch);
        this.wColumnMismatch = new Button((Composite)this.gCsvGroup, 32);
        PropsUi.setLook((Widget)this.wColumnMismatch);
        FormData fdColumnMismatch = new FormData();
        fdColumnMismatch.left = new FormAttachment(middle, 0);
        fdColumnMismatch.top = new FormAttachment((Control)this.wNullIf, margin);
        fdColumnMismatch.right = new FormAttachment(100, 0);
        this.wColumnMismatch.setLayoutData((Object)fdColumnMismatch);
        this.wColumnMismatch.addSelectionListener((SelectionListener)bMod);
        this.gJsonGroup = new Group(wDataTypeComp, 16);
        this.gJsonGroup.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.JsonGroup.Label", (String[])new String[0]));
        FormLayout jsonLayout = new FormLayout();
        jsonLayout.marginWidth = 3;
        jsonLayout.marginHeight = 3;
        this.gJsonGroup.setLayout((Layout)jsonLayout);
        PropsUi.setLook((Widget)this.gJsonGroup);
        FormData fdgJsonGroup = new FormData();
        fdgJsonGroup.left = new FormAttachment(0, 0);
        fdgJsonGroup.right = new FormAttachment(100, 0);
        fdgJsonGroup.top = new FormAttachment((Control)this.wDataType, margin * 2);
        fdgJsonGroup.bottom = new FormAttachment(100, -margin * 2);
        this.gJsonGroup.setLayoutData((Object)fdgJsonGroup);
        Label wlStripNull = new Label((Composite)this.gJsonGroup, 131072);
        wlStripNull.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.StripNull.Label", (String[])new String[0]));
        wlStripNull.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.StripNull.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStripNull);
        FormData fdlStripNull = new FormData();
        fdlStripNull.left = new FormAttachment(0, 0);
        fdlStripNull.top = new FormAttachment(0, margin);
        fdlStripNull.right = new FormAttachment(middle, -margin);
        wlStripNull.setLayoutData((Object)fdlStripNull);
        this.wStripNull = new Button((Composite)this.gJsonGroup, 32);
        PropsUi.setLook((Widget)this.wStripNull);
        FormData fdStripNull = new FormData();
        fdStripNull.left = new FormAttachment(middle, 0);
        fdStripNull.top = new FormAttachment(0, margin);
        fdStripNull.right = new FormAttachment(100, 0);
        this.wStripNull.setLayoutData((Object)fdStripNull);
        this.wStripNull.addSelectionListener((SelectionListener)bMod);
        Label wlIgnoreUtf8 = new Label((Composite)this.gJsonGroup, 131072);
        wlIgnoreUtf8.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.IgnoreUtf8.Label", (String[])new String[0]));
        wlIgnoreUtf8.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.IgnoreUtf8.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreUtf8);
        FormData fdlIgnoreUtf8 = new FormData();
        fdlIgnoreUtf8.left = new FormAttachment(0, 0);
        fdlIgnoreUtf8.top = new FormAttachment((Control)this.wStripNull, margin);
        fdlIgnoreUtf8.right = new FormAttachment(middle, -margin);
        wlIgnoreUtf8.setLayoutData((Object)fdlIgnoreUtf8);
        this.wIgnoreUtf8 = new Button((Composite)this.gJsonGroup, 32);
        PropsUi.setLook((Widget)this.wIgnoreUtf8);
        FormData fdIgnoreUtf8 = new FormData();
        fdIgnoreUtf8.left = new FormAttachment(middle, 0);
        fdIgnoreUtf8.top = new FormAttachment((Control)this.wStripNull, margin);
        fdIgnoreUtf8.right = new FormAttachment(100, 0);
        this.wIgnoreUtf8.setLayoutData((Object)fdIgnoreUtf8);
        this.wIgnoreUtf8.addSelectionListener((SelectionListener)bMod);
        Label wlAllowDuplicate = new Label((Composite)this.gJsonGroup, 131072);
        wlAllowDuplicate.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.AllowDuplicate.Label", (String[])new String[0]));
        wlAllowDuplicate.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.AllowDuplicate.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAllowDuplicate);
        FormData fdlAllowDuplicate = new FormData();
        fdlAllowDuplicate.left = new FormAttachment(0, 0);
        fdlAllowDuplicate.top = new FormAttachment((Control)this.wIgnoreUtf8, margin);
        fdlAllowDuplicate.right = new FormAttachment(middle, -margin);
        wlAllowDuplicate.setLayoutData((Object)fdlAllowDuplicate);
        this.wAllowDuplicate = new Button((Composite)this.gJsonGroup, 32);
        PropsUi.setLook((Widget)this.wAllowDuplicate);
        FormData fdAllowDuplicate = new FormData();
        fdAllowDuplicate.left = new FormAttachment(middle, 0);
        fdAllowDuplicate.top = new FormAttachment((Control)this.wIgnoreUtf8, margin);
        fdAllowDuplicate.right = new FormAttachment(100, 0);
        this.wAllowDuplicate.setLayoutData((Object)fdAllowDuplicate);
        this.wAllowDuplicate.addSelectionListener((SelectionListener)bMod);
        Label wlEnableOctal = new Label((Composite)this.gJsonGroup, 131072);
        wlEnableOctal.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.EnableOctal.Label", (String[])new String[0]));
        wlEnableOctal.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.EnableOctal.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnableOctal);
        FormData fdlEnableOctal = new FormData();
        fdlEnableOctal.left = new FormAttachment(0, 0);
        fdlEnableOctal.top = new FormAttachment((Control)this.wAllowDuplicate, margin);
        fdlEnableOctal.right = new FormAttachment(middle, -margin);
        wlEnableOctal.setLayoutData((Object)fdlEnableOctal);
        this.wEnableOctal = new Button((Composite)this.gJsonGroup, 32);
        PropsUi.setLook((Widget)this.wEnableOctal);
        FormData fdEnableOctal = new FormData();
        fdEnableOctal.left = new FormAttachment(middle, 0);
        fdEnableOctal.top = new FormAttachment((Control)this.wAllowDuplicate, margin);
        fdEnableOctal.right = new FormAttachment(100, 0);
        this.wEnableOctal.setLayoutData((Object)fdEnableOctal);
        this.wEnableOctal.addSelectionListener((SelectionListener)bMod);
        FormData fdDataTypeComp = new FormData();
        fdDataTypeComp.left = new FormAttachment(0, 0);
        fdDataTypeComp.top = new FormAttachment(0, 0);
        fdDataTypeComp.right = new FormAttachment(100, 0);
        fdDataTypeComp.bottom = new FormAttachment(100, 0);
        wDataTypeComp.setLayoutData((Object)fdDataTypeComp);
        wDataTypeComp.layout();
        wDataTypeTab.setControl((Control)wDataTypeComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.wSpecifyFields = new Button(wFieldsComp, 32);
        this.wSpecifyFields.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.SpecifyFields.Label", (String[])new String[0]));
        this.wSpecifyFields.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.SpecifyFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSpecifyFields);
        FormData fdSpecifyFields = new FormData();
        fdSpecifyFields.left = new FormAttachment(0, 0);
        fdSpecifyFields.top = new FormAttachment(0, margin);
        fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)bMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SnowflakeBulkLoaderDialog.this.setFlags();
            }
        });
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(50, -margin);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DoMapping.Label", (String[])new String[0]));
        this.wDoMapping.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DoMapping.Tooltip", (String[])new String[0]));
        FormData fdbDoMapping = new FormData();
        fdbDoMapping.left = new FormAttachment(50, margin);
        fdbDoMapping.bottom = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdbDoMapping);
        int FieldsCols = 2;
        int FieldsRows = this.input.getSnowflakeBulkLoaderFields().size();
        this.colinf = new ColumnInfo[2];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.StreamField.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.TableField.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.colinf[1]);
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wSpecifyFields, margin * 3);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wlJsonField = new Label(wFieldsComp, 131072);
        this.wlJsonField.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.JsonField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlJsonField);
        FormData fdlJsonField = new FormData();
        fdlJsonField.left = new FormAttachment(0, 0);
        fdlJsonField.top = new FormAttachment(0, margin);
        fdlJsonField.right = new FormAttachment(middle, -margin);
        this.wlJsonField.setLayoutData((Object)fdlJsonField);
        this.wJsonField = new CCombo(wFieldsComp, 2056);
        this.wJsonField.setEditable(false);
        PropsUi.setLook((Widget)this.wJsonField);
        this.wJsonField.addModifyListener(lsMod);
        FormData fdJsonField = new FormData();
        fdJsonField.left = new FormAttachment(middle, 0);
        fdJsonField.top = new FormAttachment(0, margin);
        fdJsonField.right = new FormAttachment(100, 0);
        this.wJsonField.setLayoutData((Object)fdJsonField);
        this.wJsonField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                try {
                    IRowMeta row = SnowflakeBulkLoaderDialog.this.pipelineMeta.getPrevTransformFields(SnowflakeBulkLoaderDialog.this.variables, SnowflakeBulkLoaderDialog.this.transformName);
                    String jsonField = SnowflakeBulkLoaderDialog.this.wJsonField.getText();
                    SnowflakeBulkLoaderDialog.this.wJsonField.setItems(row.getFieldNames());
                    if (jsonField != null) {
                        SnowflakeBulkLoaderDialog.this.wJsonField.setText(jsonField);
                    }
                }
                catch (Exception ex) {
                    String jsonField = SnowflakeBulkLoaderDialog.this.wJsonField.getText();
                    SnowflakeBulkLoaderDialog.this.wJsonField.setItems(new String[0]);
                    SnowflakeBulkLoaderDialog.this.wJsonField.setText(jsonField);
                }
            }
        });
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wCancel, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wbTable.addListener(13, e -> this.getTableName());
        wbSchema.addListener(13, e -> this.getSchemaNames());
        this.wSchema.addModifyListener(e -> this.wSchema.setToolTipText(this.variables.resolve(this.wSchema.getText())));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SnowflakeBulkLoaderDialog.this.cancel();
            }
        });
        this.wSql.addListener(13, e -> this.create());
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet.addListener(13, e -> this.get());
        this.wDoMapping.addListener(13, e -> this.generateMappings());
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.setFlags();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.transformName;
    }

    private void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void getData() {
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getTargetSchema() != null) {
            this.wSchema.setText(this.input.getTargetSchema());
        }
        if (this.input.getTargetTable() != null) {
            this.wTable.setText(this.input.getTargetTable());
        }
        if (this.input.getLocationType() != null) {
            this.wLocationType.setText(LOCATION_TYPE_COMBO[this.input.getLocationTypeId()]);
        }
        if (this.input.getStageName() != null) {
            this.wStageName.setText(this.input.getStageName());
        }
        if (this.input.getWorkDirectory() != null) {
            this.wWorkDirectory.setText(this.input.getWorkDirectory());
        }
        if (this.input.getOnError() != null) {
            this.wOnError.setText(ON_ERROR_COMBO[this.input.getOnErrorId()]);
        }
        if (this.input.getErrorLimit() != null) {
            this.wErrorLimit.setText(this.input.getErrorLimit());
        }
        if (this.input.getSplitSize() != null) {
            this.wSplitSize.setText(this.input.getSplitSize());
        }
        this.wRemoveFiles.setSelection(this.input.isRemoveFiles());
        if (this.input.getDataType() != null) {
            this.wDataType.setText(DATA_TYPE_COMBO[this.input.getDataTypeId()]);
        }
        this.wTrimWhitespace.setSelection(this.input.isTrimWhitespace());
        if (this.input.getNullIf() != null) {
            this.wNullIf.setText(this.input.getNullIf());
        }
        this.wColumnMismatch.setSelection(this.input.isErrorColumnMismatch());
        this.wStripNull.setSelection(this.input.isStripNull());
        this.wIgnoreUtf8.setSelection(this.input.isIgnoreUtf8());
        this.wAllowDuplicate.setSelection(this.input.isAllowDuplicateElements());
        this.wEnableOctal.setSelection(this.input.isEnableOctal());
        this.wSpecifyFields.setSelection(this.input.isSpecifyFields());
        if (this.input.getJsonField() != null) {
            this.wJsonField.setText(this.input.getJsonField());
        }
        this.logDebug("getting fields info...");
        for (int i = 0; i < this.input.getSnowflakeBulkLoaderFields().size(); ++i) {
            SnowflakeBulkLoaderField field = this.input.getSnowflakeBulkLoaderFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getStreamField(), (String)""));
            item.setText(2, Const.NVL((String)field.getTableField(), (String)""));
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(SnowflakeBulkLoaderMeta sbl) {
        sbl.setConnection(this.wConnection.getText());
        sbl.setTargetSchema(this.wSchema.getText());
        sbl.setTargetTable(this.wTable.getText());
        sbl.setLocationTypeById(this.wLocationType.getSelectionIndex());
        sbl.setStageName(this.wStageName.getText());
        sbl.setWorkDirectory(this.wWorkDirectory.getText());
        sbl.setOnErrorById(this.wOnError.getSelectionIndex());
        sbl.setErrorLimit(this.wErrorLimit.getText());
        sbl.setSplitSize(this.wSplitSize.getText());
        sbl.setRemoveFiles(this.wRemoveFiles.getSelection());
        sbl.setDataTypeById(this.wDataType.getSelectionIndex());
        sbl.setTrimWhitespace(this.wTrimWhitespace.getSelection());
        sbl.setNullIf(this.wNullIf.getText());
        sbl.setErrorColumnMismatch(this.wColumnMismatch.getSelection());
        sbl.setStripNull(this.wStripNull.getSelection());
        sbl.setIgnoreUtf8(this.wIgnoreUtf8.getSelection());
        sbl.setAllowDuplicateElements(this.wAllowDuplicate.getSelection());
        sbl.setEnableOctal(this.wEnableOctal.getSelection());
        sbl.setSpecifyFields(this.wSpecifyFields.getSelection());
        sbl.setJsonField(this.wJsonField.getText());
        int nrfields = this.wFields.nrNonEmpty();
        ArrayList<SnowflakeBulkLoaderField> fields = new ArrayList<SnowflakeBulkLoaderField>();
        for (int i = 0; i < nrfields; ++i) {
            SnowflakeBulkLoaderField field = new SnowflakeBulkLoaderField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setStreamField(item.getText(1));
            field.setTableField(item.getText(2));
            fields.add(field);
        }
        sbl.setSnowflakeBulkLoaderFields(fields);
    }

    private void ok() {
        if (StringUtils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setTargetTable(this.variables.resolve(this.wTable.getText()));
        this.input.setTargetSchema(this.variables.resolve(this.wSchema.getText()));
        ITransformMeta iTransformMeta = this.transformMeta.getTransform();
        try {
            targetFields = iTransformMeta.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(1);
            String target = item.getText(2);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingTargetFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            this.shell.setImage(GuiResource.getInstance().getImageHopUi());
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(2, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void getTableName() {
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            DatabaseMeta inf = (DatabaseMeta)this.pipelineMeta.getDatabases().get(connr);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog..Log.LookingAtConnection", (String[])new String[]{inf.toString()}));
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, inf, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta ci;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo tableField : this.tableFieldColumns) {
                    tableField.setComboValues(new String[0]);
                }
                if (!StringUtils.isEmpty((CharSequence)tableName) && (ci = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                    Database db = new Database(loggingObject, this.variables, ci);
                    try {
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = ci.getQuotedSchemaTableCombination(this.variables, this.variables.resolve(schemaName), this.variables.resolve(tableName));
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo tableField : this.tableFieldColumns) {
                                tableField.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo tableField : this.tableFieldColumns) {
                            tableField.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void setFlags() {
        if (this.wOnError.getSelectionIndex() == 1) {
            this.wlErrorLimit.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorCountLimit.Label", (String[])new String[0]));
            this.wlErrorLimit.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorCountLimit.Tooltip", (String[])new String[0]));
            this.wlErrorLimit.setEnabled(true);
            this.wErrorLimit.setEnabled(true);
        } else if (this.wOnError.getSelectionIndex() == 2) {
            this.wlErrorLimit.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorPercentLimit.Label", (String[])new String[0]));
            this.wlErrorLimit.setToolTipText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Dialog.ErrorPercentLimit.Tooltip", (String[])new String[0]));
            this.wlErrorLimit.setEnabled(true);
            this.wErrorLimit.setEnabled(true);
        } else {
            this.wlErrorLimit.setEnabled(false);
            this.wErrorLimit.setEnabled(false);
        }
        if (this.wLocationType.getSelectionIndex() == 2) {
            this.wStageName.setEnabled(true);
        } else {
            this.wStageName.setEnabled(false);
        }
        if (this.wDataType.getSelectionIndex() == 1) {
            this.gCsvGroup.setVisible(false);
            this.gJsonGroup.setVisible(true);
            this.wJsonField.setVisible(true);
            this.wlJsonField.setVisible(true);
            this.wSpecifyFields.setVisible(false);
            this.wFields.setVisible(false);
            this.wGet.setVisible(false);
            this.wDoMapping.setVisible(false);
        } else {
            this.gCsvGroup.setVisible(true);
            this.gJsonGroup.setVisible(false);
            this.wJsonField.setVisible(false);
            this.wlJsonField.setVisible(false);
            this.wSpecifyFields.setVisible(true);
            this.wFields.setVisible(true);
            this.wFields.setEnabled(this.wSpecifyFields.getSelection());
            this.wFields.table.setEnabled(this.wSpecifyFields.getSelection());
            if (this.wSpecifyFields.getSelection()) {
                this.wFields.setForeground(this.display.getSystemColor(15));
            } else {
                this.wFields.setForeground(this.display.getSystemColor(2));
            }
            this.wGet.setVisible(true);
            this.wGet.setEnabled(this.wSpecifyFields.getSelection());
            this.wDoMapping.setVisible(true);
            this.wDoMapping.setEnabled(this.wSpecifyFields.getSelection());
        }
    }

    private void create() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        try {
            SnowflakeBulkLoaderMeta info = new SnowflakeBulkLoaderMeta();
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (info.isSpecifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getSnowflakeBulkLoaderFields().size(); ++i) {
                    SnowflakeBulkLoaderField sf = info.getSnowflakeBulkLoaderFields().get(i);
                    IValueMeta insValue = prev.searchValueMeta(sf.getStreamField());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableOutputDialog.FailedToFindField.Message", (String[])new String[]{sf.getStreamField()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(sf.getTableField());
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            if (SnowflakeBulkLoaderDialog.isValidRowMeta(prev)) {
                SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
                if (!sql.hasError()) {
                    if (sql.hasSql()) {
                        SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                        sqledit.open();
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(sql.getError());
                    mb.setText(BaseMessages.getString(PKG, (String)"SnowBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SnowBulkLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SnowBulkLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            ke.printStackTrace();
        }
    }

    private static boolean isValidRowMeta(IRowMeta rowMeta) {
        for (IValueMeta value : rowMeta.getValueMetaList()) {
            String name = value.getName();
            if (name != null && !name.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

