/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Throwables;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.BlockingQueues;

class SSTableSimpleUnsortedWriter
extends AbstractSSTableSimpleWriter {
    private static final Buffer SENTINEL = new Buffer();
    private Buffer buffer = new Buffer();
    private final long bufferSize;
    private long currentSize;
    private final SerializationHeader header;
    private final SerializationHelper helper;
    private final BlockingQueue<Buffer> writeQueue = BlockingQueues.newBlockingQueue(0);
    private final DiskWriter diskWriter = new DiskWriter();

    SSTableSimpleUnsortedWriter(File directory, TableMetadataRef metadata, RegularAndStaticColumns columns, long bufferSizeInMB) {
        super(directory, metadata, columns);
        this.bufferSize = bufferSizeInMB * 1024L * 1024L;
        this.header = new SerializationHeader(true, metadata.get(), columns, EncodingStats.NO_STATS);
        this.helper = new SerializationHelper(this.header);
        this.diskWriter.start();
    }

    @Override
    PartitionUpdate.Builder getUpdateFor(DecoratedKey key) {
        assert (key != null);
        PartitionUpdate.Builder previous = (PartitionUpdate.Builder)this.buffer.get(key);
        if (previous == null) {
            this.currentSize += PartitionUpdate.serializer.serializedSize(this.createPartitionUpdateBuilder(key).build(), this.formatType.info.getLatestVersion().correspondingMessagingVersion());
            previous = this.createPartitionUpdateBuilder(key);
            this.buffer.put(key, previous);
        }
        return previous;
    }

    private void countRow(Row row) {
        this.currentSize += UnfilteredSerializer.serializer.serializedSize((Unfiltered)row, this.helper, 0L, this.formatType.info.getLatestVersion().correspondingMessagingVersion());
    }

    private void maybeSync() throws SyncException {
        try {
            if (this.currentSize > this.bufferSize) {
                this.sync();
            }
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }

    private PartitionUpdate.Builder createPartitionUpdateBuilder(DecoratedKey key) {
        return new PartitionUpdate.Builder(this.metadata.get(), key, this.columns, 4){

            @Override
            public void add(Row row) {
                super.add(row);
                SSTableSimpleUnsortedWriter.this.countRow(row);
                SSTableSimpleUnsortedWriter.this.maybeSync();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.sync();
        this.put(SENTINEL);
        try {
            this.diskWriter.join();
            this.checkForWriterException();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.checkForWriterException();
    }

    protected void sync() throws IOException {
        if (this.buffer.isEmpty()) {
            return;
        }
        this.put(this.buffer);
        this.buffer = new Buffer();
        this.currentSize = 0L;
    }

    /*
     * Exception decompiling
     */
    private void put(Buffer buffer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForWriterException() throws IOException {
        if (this.diskWriter.exception != null) {
            if (this.diskWriter.exception instanceof IOException) {
                throw (IOException)this.diskWriter.exception;
            }
            throw Throwables.propagate((Throwable)this.diskWriter.exception);
        }
    }

    private class DiskWriter
    extends FastThreadLocalThread {
        volatile Throwable exception = null;

        private DiskWriter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SSTableTxnWriter writer;
                        block15: {
                            Buffer b;
                            if ((b = (Buffer)SSTableSimpleUnsortedWriter.this.writeQueue.take()) == SENTINEL) {
                                return;
                            }
                            writer = SSTableSimpleUnsortedWriter.this.createWriter();
                            Throwable throwable = null;
                            try {
                                for (Map.Entry entry : b.entrySet()) {
                                    writer.append(((PartitionUpdate.Builder)entry.getValue()).build().unfilteredIterator());
                                }
                                writer.finish(false);
                                if (writer == null) continue;
                                if (throwable == null) break block15;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (writer == null) throw throwable4;
                                    if (throwable == null) {
                                        writer.close();
                                        throw throwable4;
                                    }
                                    try {
                                        writer.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (Throwable e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    if (this.exception != null) continue;
                    this.exception = e;
                    continue;
                }
                break;
            }
        }
    }

    static class Buffer
    extends TreeMap<DecoratedKey, PartitionUpdate.Builder> {
        Buffer() {
        }
    }

    static class SyncException
    extends RuntimeException {
        SyncException(IOException ioe) {
            super(ioe);
        }
    }
}

