/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;

public class ReadTranslation {
    private static final String JAVA_SERIALIZED_BOUNDED_SOURCE = "beam:java:boundedsource:v1";
    private static final String JAVA_SERIALIZED_UNBOUNDED_SOURCE = "beam:java:unboundedsource:v1";

    public static RunnerApi.ReadPayload toProto(SplittableParDo.PrimitiveBoundedRead<?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.BOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static RunnerApi.ReadPayload toProto(SplittableParDo.PrimitiveUnboundedRead<?> read) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.UNBOUNDED).setSource(ReadTranslation.toProto(read.getSource())).build();
    }

    public static RunnerApi.FunctionSpec toProto(Source<?> source) {
        if (source instanceof BoundedSource) {
            return ReadTranslation.toProto((BoundedSource)source);
        }
        if (source instanceof UnboundedSource) {
            return ReadTranslation.toProto((UnboundedSource)source);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %s", Source.class.getSimpleName(), source.getClass()));
    }

    private static RunnerApi.FunctionSpec toProto(BoundedSource<?> source) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_BOUNDED_SOURCE).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build();
    }

    public static BoundedSource<?> boundedSourceFromProto(RunnerApi.ReadPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((boolean)payload.getIsBounded().equals((Object)RunnerApi.IsBounded.Enum.BOUNDED));
        return (BoundedSource)SerializableUtils.deserializeFromByteArray((byte[])payload.getSource().getPayload().toByteArray(), (String)"BoundedSource");
    }

    public static <T> BoundedSource<T> boundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.boundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    public static <T, CheckpointT extends UnboundedSource.CheckpointMark> UnboundedSource<T, CheckpointT> unboundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.unboundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    private static <T> RunnerApi.ReadPayload getReadPayload(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        return RunnerApi.ReadPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    private static RunnerApi.FunctionSpec toProto(UnboundedSource<?, ?> source) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_UNBOUNDED_SOURCE).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(source))).build();
    }

    public static UnboundedSource<?, ?> unboundedSourceFromProto(RunnerApi.ReadPayload payload) {
        Preconditions.checkArgument((boolean)payload.getIsBounded().equals((Object)RunnerApi.IsBounded.Enum.UNBOUNDED));
        return (UnboundedSource)SerializableUtils.deserializeFromByteArray((byte[])payload.getSource().getPayload().toByteArray(), (String)"UnboundedSource");
    }

    public static PCollection.IsBounded sourceIsBounded(AppliedPTransform<?, ?, ?> transform) {
        try {
            SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
            return PCollectionTranslation.fromProto(RunnerApi.ReadPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload()).getIsBounded());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error determining boundedness of Read", e);
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(SplittableParDo.PrimitiveUnboundedRead.class, (Object)new UnboundedReadPayloadTranslator()).put(SplittableParDo.PrimitiveBoundedRead.class, (Object)new BoundedReadPayloadTranslator()).build();
        }
    }

    public static class BoundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<SplittableParDo.PrimitiveBoundedRead<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new BoundedReadPayloadTranslator();
        }

        private BoundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(SplittableParDo.PrimitiveBoundedRead<?> transform) {
            return "beam:transform:read:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, SplittableParDo.PrimitiveBoundedRead<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto((SplittableParDo.PrimitiveBoundedRead)transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((SplittableParDo.PrimitiveBoundedRead)transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }

    public static class UnboundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<SplittableParDo.PrimitiveUnboundedRead<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new UnboundedReadPayloadTranslator();
        }

        private UnboundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(SplittableParDo.PrimitiveUnboundedRead<?> transform) {
            return "beam:transform:read:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, SplittableParDo.PrimitiveUnboundedRead<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto((SplittableParDo.PrimitiveUnboundedRead)transform.getTransform());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((SplittableParDo.PrimitiveUnboundedRead)transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }
}

