/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class PubsubReadSchemaTransformConfiguration {
    @SchemaFieldDescription(value="The name of the topic to consume data from. If a topic is specified,  will create a new subscription for that topic and start consuming from that point. Either a topic or a subscription must be provided. Format: projects/${PROJECT}/topics/${TOPIC}")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getTopic();

    @SchemaFieldDescription(value="The name of the subscription to consume data. Either a topic or subscription must be provided. Format: projects/${PROJECT}/subscriptions/${SUBSCRIPTION}")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getSubscription();

    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: AVRO,JSON")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

    @SchemaFieldDescription(value="The schema in which the data is encoded in the Pubsub topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public abstract @UnknownKeyFor @NonNull @Initialized String getSchema();

    @Nullable
    public abstract  @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PubsubTestClient.PubsubTestClientFactory getClientFactory();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Clock getClock();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PubsubReadSchemaTransformConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscription(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setClientFactory(@Nullable  @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PubsubTestClient.PubsubTestClientFactory var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setClock(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Clock var1);

        public abstract @UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration build();
    }
}

