/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

public class RecordConversionStats {
    public static final RecordConversionStats EMPTY = new RecordConversionStats();
    private long temporaryMemoryBytes;
    private int numRecordsConverted;
    private long conversionTimeNanos;

    public RecordConversionStats(long temporaryMemoryBytes, int numRecordsConverted, long conversionTimeNanos) {
        this.temporaryMemoryBytes = temporaryMemoryBytes;
        this.numRecordsConverted = numRecordsConverted;
        this.conversionTimeNanos = conversionTimeNanos;
    }

    public RecordConversionStats() {
        this(0L, 0, 0L);
    }

    public void add(RecordConversionStats stats) {
        this.temporaryMemoryBytes += stats.temporaryMemoryBytes;
        this.numRecordsConverted += stats.numRecordsConverted;
        this.conversionTimeNanos += stats.conversionTimeNanos;
    }

    public long temporaryMemoryBytes() {
        return this.temporaryMemoryBytes;
    }

    public int numRecordsConverted() {
        return this.numRecordsConverted;
    }

    public long conversionTimeNanos() {
        return this.conversionTimeNanos;
    }

    public String toString() {
        return String.format("RecordConversionStats(temporaryMemoryBytes=%d, numRecordsConverted=%d, conversionTimeNanos=%d)", this.temporaryMemoryBytes, this.numRecordsConverted, this.conversionTimeNanos);
    }
}

