/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.logging;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.logging.LogMessage;
import com.clickhouse.client.logging.Logger;
import java.util.function.Supplier;

public class Slf4jLogger
implements Logger {
    private final org.slf4j.Logger logger;

    public Slf4jLogger(org.slf4j.Logger logger) {
        this.logger = ClickHouseChecker.nonNull(logger, "logger");
    }

    @Override
    public void debug(Supplier<?> function) {
        if (function != null && this.logger.isDebugEnabled()) {
            this.logger.debug(String.valueOf(function.get()));
        }
    }

    @Override
    public void debug(Object format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            LogMessage msg = LogMessage.of(format, arguments);
            if (msg.hasThrowable()) {
                this.logger.debug(msg.getMessage(), msg.getThrowable());
            } else {
                this.logger.debug(msg.getMessage());
            }
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.valueOf(message), t);
        }
    }

    @Override
    public void error(Supplier<?> function) {
        if (function != null && this.logger.isErrorEnabled()) {
            this.logger.error(String.valueOf(function.get()));
        }
    }

    @Override
    public void error(Object format, Object ... arguments) {
        if (this.logger.isErrorEnabled()) {
            LogMessage msg = LogMessage.of(format, arguments);
            if (msg.hasThrowable()) {
                this.logger.error(msg.getMessage(), msg.getThrowable());
            } else {
                this.logger.error(msg.getMessage());
            }
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(String.valueOf(message), t);
        }
    }

    @Override
    public void info(Supplier<?> function) {
        if (function != null && this.logger.isInfoEnabled()) {
            this.logger.info(String.valueOf(function.get()));
        }
    }

    @Override
    public void info(Object format, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            LogMessage msg = LogMessage.of(format, arguments);
            if (msg.hasThrowable()) {
                this.logger.info(msg.getMessage(), msg.getThrowable());
            } else {
                this.logger.info(msg.getMessage());
            }
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.valueOf(message), t);
        }
    }

    @Override
    public void trace(Supplier<?> function) {
        if (function != null && this.logger.isTraceEnabled()) {
            this.logger.trace(String.valueOf(function.get()));
        }
    }

    @Override
    public void trace(Object format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            LogMessage msg = LogMessage.of(format, arguments);
            if (msg.hasThrowable()) {
                this.logger.trace(msg.getMessage(), msg.getThrowable());
            } else {
                this.logger.trace(msg.getMessage());
            }
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.valueOf(message), t);
        }
    }

    @Override
    public void warn(Supplier<?> function) {
        if (function != null && this.logger.isWarnEnabled()) {
            this.logger.warn(String.valueOf(function.get()));
        }
    }

    @Override
    public void warn(Object format, Object ... arguments) {
        if (this.logger.isWarnEnabled()) {
            LogMessage msg = LogMessage.of(format, arguments);
            if (msg.hasThrowable()) {
                this.logger.warn(msg.getMessage(), msg.getThrowable());
            } else {
                this.logger.warn(msg.getMessage());
            }
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(String.valueOf(message), t);
        }
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

