/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CoderCloudObjectTranslatorRegistrar;
import org.apache.beam.runners.dataflow.util.DefaultCoderCloudObjectTranslatorRegistrar;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CloudObjects {
    static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> DATAFLOW_KNOWN_CODERS = ImmutableSet.of(ByteArrayCoder.class, KvCoder.class, VarLongCoder.class, IntervalWindow.IntervalWindowCoder.class, IterableCoder.class, Timer.Coder.class, (Object[])new Class[]{LengthPrefixCoder.class, GlobalWindow.Coder.class, WindowedValue.FullWindowedValueCoder.class, TimestampPrefixingWindowCoder.class});
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> CODER_TRANSLATORS = CloudObjects.populateCoderTranslators();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> CLOUD_OBJECT_CLASS_NAME_TRANSLATORS = CloudObjects.populateCloudObjectTranslators();

    private CloudObjects() {
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> populateCoderTranslators() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CoderCloudObjectTranslatorRegistrar coderRegistrar : ServiceLoader.load(CoderCloudObjectTranslatorRegistrar.class)) {
            builder.putAll(coderRegistrar.classesToTranslators());
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> populateCloudObjectTranslators() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CoderCloudObjectTranslatorRegistrar coderRegistrar : ServiceLoader.load(CoderCloudObjectTranslatorRegistrar.class)) {
            builder.putAll(coderRegistrar.classNamesToTranslators());
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObject asCloudObject(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @Nullable @UnknownKeyFor @Initialized SdkComponents sdkComponents) {
        CloudObject encoding;
        CloudObjectTranslator<? extends Coder> translator = CODER_TRANSLATORS.get(coder.getClass());
        if (translator != null) {
            encoding = translator.toCloudObject(coder, sdkComponents);
        } else {
            CloudObjectTranslator<? extends Coder> customCoderTranslator = CODER_TRANSLATORS.get(CustomCoder.class);
            Preconditions.checkNotNull(customCoderTranslator, (String)"No %s registered for %s, but it is in the %s", (Object)CloudObjectTranslator.class.getSimpleName(), (Object)CustomCoder.class.getSimpleName(), (Object)DefaultCoderCloudObjectTranslatorRegistrar.class.getSimpleName());
            encoding = customCoderTranslator.toCloudObject(coder, sdkComponents);
        }
        if (sdkComponents != null && !DATAFLOW_KNOWN_CODERS.contains(coder.getClass())) {
            try {
                String coderId = sdkComponents.registerCoder(coder);
                Structs.addString((Map<String, Object>)((Object)encoding), "pipeline_proto_coder_id", coderId);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register coder " + coder, e);
            }
        }
        return encoding;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coderFromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        CloudObjectTranslator<? extends Coder> translator = CLOUD_OBJECT_CLASS_NAME_TRANSLATORS.get(cloudObject.getClassName());
        Preconditions.checkArgument((translator != null ? 1 : 0) != 0, (String)"Unknown %s class %s", (Object)Coder.class.getSimpleName(), (Object)cloudObject.getClassName());
        return translator.fromCloudObject(cloudObject);
    }
}

