/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.server.ServerConnectionManager;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerStatus;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.SslConfiguration;
import org.apache.hop.www.WebResult;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.w3c.dom.Node;

@HopMetadata(key="server", name="Hop Server", description="Defines a Hop Hop Server", image="ui/images/server.svg", documentationUrl="/metadata-types/hop-server.html")
public class HopServer
extends HopMetadataBase
implements Cloneable,
IXml,
IHopMetadata {
    private static final Class<?> PKG = HopServer.class;
    public static final String STRING_HOP_SERVER = "Hop Server";
    private static final Random RANDOM = new Random();
    public static final String XML_TAG = "hop-server";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL_MODE_TAG = "sslMode";
    public static final int HOP_SERVER_RETRIES = HopServer.getNumberOfHopServerRetries();
    public static final int HOP_SERVER_RETRY_BACKOFF_INCREMENTS = HopServer.getBackoffIncrements();
    private ILogChannel log = new LogChannel((Object)"Hop Server");
    @HopMetadataProperty
    private String hostname;
    @HopMetadataProperty
    private String port;
    @HopMetadataProperty
    private String shutdownPort;
    @HopMetadataProperty
    private String webAppName;
    @HopMetadataProperty
    private String username;
    @HopMetadataProperty(password=true)
    private String password;
    @HopMetadataProperty
    private String proxyHostname;
    @HopMetadataProperty
    private String proxyPort;
    @HopMetadataProperty
    private String nonProxyHosts;
    @HopMetadataProperty
    private String propertiesMasterName;
    @HopMetadataProperty
    private boolean overrideExistingProperties;
    private Date changedDate = new Date();
    @HopMetadataProperty
    private boolean sslMode;
    @HopMetadataProperty
    private SslConfiguration sslConfig;

    private static int getNumberOfHopServerRetries() {
        try {
            return Integer.parseInt(Const.NVL((String)System.getProperty("HOP_SERVER_RETRIES"), (String)"0"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getBackoffIncrements() {
        try {
            return Integer.parseInt(Const.NVL((String)System.getProperty("HOP_SERVER_RETRY_BACKOFF_INCREMENTS"), (String)"1000"));
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public HopServer() {
    }

    public HopServer(String name, String hostname, String port, String shutdownPort, String username, String password) {
        this(name, hostname, port, shutdownPort, username, password, null, null, null, false);
    }

    public HopServer(String name, String hostname, String port, String shutdownPort, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts) {
        this(name, hostname, port, shutdownPort, username, password, proxyHostname, proxyPort, nonProxyHosts, false);
    }

    public HopServer(String name, String hostname, String port, String shutdownPort, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean sslMode) {
        this();
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.shutdownPort = shutdownPort;
        this.username = username;
        this.password = password;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.nonProxyHosts = nonProxyHosts;
        this.sslMode = sslMode;
        this.log = new LogChannel((Object)this);
    }

    public HopServer(Node node) {
        this();
        this.name = XmlHandler.getTagValue((Node)node, (String)"name");
        this.hostname = XmlHandler.getTagValue((Node)node, (String)"hostname");
        this.port = XmlHandler.getTagValue((Node)node, (String)"port");
        this.shutdownPort = XmlHandler.getTagValue((Node)node, (String)"shutdownPort");
        this.webAppName = XmlHandler.getTagValue((Node)node, (String)"webAppName");
        this.username = XmlHandler.getTagValue((Node)node, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)node, (String)"password"));
        this.proxyHostname = XmlHandler.getTagValue((Node)node, (String)"proxy_hostname");
        this.proxyPort = XmlHandler.getTagValue((Node)node, (String)"proxy_port");
        this.nonProxyHosts = XmlHandler.getTagValue((Node)node, (String)"non_proxy_hosts");
        this.propertiesMasterName = XmlHandler.getTagValue((Node)node, (String)"get_properties_from_master");
        this.overrideExistingProperties = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)node, (String)"override_existing_properties"));
        this.log = new LogChannel((Object)this);
        this.setSslMode("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)node, (String)SSL_MODE_TAG)));
        Node sslConfig = XmlHandler.getSubNode((Node)node, (String)"sslConfig");
        if (sslConfig != null) {
            this.setSslMode(true);
            this.sslConfig = new SslConfiguration(sslConfig);
        }
    }

    public ILogChannel getLogChannel() {
        return this.log;
    }

    public String getXml(IVariables variables) {
        StringBuilder xml = new StringBuilder();
        xml.append("      ").append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.name));
        xml.append("        ").append(XmlHandler.addTagValue((String)"hostname", (String)this.hostname));
        xml.append("        ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        xml.append("        ").append(XmlHandler.addTagValue((String)"shutdownPort", (String)this.shutdownPort));
        xml.append("        ").append(XmlHandler.addTagValue((String)"webAppName", (String)this.webAppName));
        xml.append("        ").append(XmlHandler.addTagValue((String)"username", (String)this.username));
        xml.append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        xml.append("        ").append(XmlHandler.addTagValue((String)"proxy_hostname", (String)this.proxyHostname));
        xml.append("        ").append(XmlHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        xml.append("        ").append(XmlHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts));
        xml.append("        ").append(XmlHandler.addTagValue((String)SSL_MODE_TAG, (boolean)this.isSslMode(), (boolean)false));
        if (this.sslConfig != null) {
            xml.append(this.sslConfig.getXml());
        }
        xml.append("      ").append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public HopServer clone() {
        return new HopServer(this);
    }

    public HopServer(HopServer server) {
        this();
        this.replaceMeta(server);
    }

    public void replaceMeta(HopServer hopServer) {
        this.name = hopServer.name;
        this.hostname = hopServer.hostname;
        this.port = hopServer.port;
        this.webAppName = hopServer.webAppName;
        this.username = hopServer.username;
        this.password = hopServer.password;
        this.proxyHostname = hopServer.proxyHostname;
        this.proxyPort = hopServer.proxyPort;
        this.nonProxyHosts = hopServer.nonProxyHosts;
        this.sslMode = hopServer.sslMode;
    }

    public String toString() {
        return this.name;
    }

    public String getServerAndPort(IVariables variables) {
        String realHostname = variables.resolve(this.hostname);
        if (!Utils.isEmpty((CharSequence)realHostname)) {
            return realHostname + this.getPortSpecification(variables);
        }
        return STRING_HOP_SERVER;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HopServer)) {
            return false;
        }
        HopServer server = (HopServer)obj;
        return this.name.equalsIgnoreCase(server.getName());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String urlString) {
        this.hostname = urlString;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void setWebAppName(String webAppName) {
        this.webAppName = webAppName;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getPropertiesMasterName() {
        return this.propertiesMasterName;
    }

    public boolean isOverrideExistingProperties() {
        return this.overrideExistingProperties;
    }

    public String getPort() {
        return this.port;
    }

    public void setShutdownPort(String port) {
        this.shutdownPort = port;
    }

    public String getShutdownPort() {
        return this.shutdownPort;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPortSpecification(IVariables variables) {
        String realPort = variables.resolve(this.port);
        Object portSpec = ":" + realPort;
        if (Utils.isEmpty((CharSequence)realPort) || this.port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public String constructUrl(IVariables variables, String serviceAndArguments) throws UnsupportedEncodingException {
        String realHostname = null;
        String proxyHostname = null;
        realHostname = variables.resolve(this.hostname);
        proxyHostname = variables.resolve(this.getProxyHostname());
        if (!Utils.isEmpty((CharSequence)proxyHostname) && realHostname.equals("localhost")) {
            realHostname = "127.0.0.1";
        }
        if (!StringUtils.isBlank((String)this.webAppName)) {
            serviceAndArguments = "/" + variables.resolve(this.getWebAppName()) + (String)serviceAndArguments;
        }
        Object result = (this.isSslMode() ? HTTPS : HTTP) + "://" + realHostname + this.getPortSpecification(variables) + (String)serviceAndArguments;
        result = Const.replace((String)result, (String)" ", (String)"%20");
        return result;
    }

    HttpPost buildSendXmlMethod(IVariables variables, byte[] content, String service) throws Exception {
        String encoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
        return this.buildSendMethod(variables, content, encoding, service, "text/xml");
    }

    HttpPost buildSendMethod(IVariables variables, byte[] content, String encoding, String service, String contentType) throws Exception {
        String urlString = this.constructUrl(variables, service);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        HttpPost postMethod = new HttpPost(urlString);
        ByteArrayEntity entity = new ByteArrayEntity(content);
        postMethod.setEntity((HttpEntity)entity);
        postMethod.addHeader((Header)new BasicHeader("Accept", contentType + ";charset=" + encoding));
        return postMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendXml(IVariables variables, String xml, String service) throws Exception {
        String string;
        String encoding = this.getXmlEncoding(xml);
        HttpPost method = this.buildSendMethod(variables, xml.getBytes(encoding), encoding, service, "text/xml");
        try {
            string = this.executeAuth(variables, (HttpUriRequest)method);
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentXmlToService", (String[])new String[]{service, variables.resolve(this.hostname)}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentXmlToService", (String[])new String[]{service, variables.resolve(this.hostname)}));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendJson(IVariables variables, String json, String service) throws Exception {
        String string;
        String encoding = "UTF-8";
        HttpPost method = this.buildSendMethod(variables, json.getBytes(encoding), encoding, service, "application/json");
        try {
            string = this.executeAuth(variables, (HttpUriRequest)method);
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentXmlToService", (String[])new String[]{service, variables.resolve(this.hostname)}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentXmlToService", (String[])new String[]{service, variables.resolve(this.hostname)}));
        }
        return string;
    }

    private String getXmlEncoding(String xml) {
        Pattern xmlHeadPattern = Pattern.compile("<\\?xml.* encoding=\"(.*)\"");
        Matcher matcher = xmlHeadPattern.matcher(xml);
        if (matcher.find()) {
            return matcher.group();
        }
        return Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
    }

    private void handleStatus(IVariables variables, HttpUriRequest method, StatusLine statusLine, int status) throws HopException {
        if (status >= 300) {
            String message = status == 404 ? String.format("%s%s%s%s", BaseMessages.getString(PKG, (String)"HopServer.Error.404.Title", (String[])new String[0]), Const.CR, Const.CR, BaseMessages.getString(PKG, (String)"HopServer.Error.404.Message", (String[])new String[0])) : String.format("HTTP Status %d - %s - %s", status, method.getURI().toString(), statusLine.getReasonPhrase());
            throw new HopException(message);
        }
    }

    HttpPost buildSendExportMethod(IVariables variables, String type, String load, InputStream is) throws UnsupportedEncodingException {
        Object serviceUrl = "/hop/registerPackage";
        if (type != null && load != null) {
            serviceUrl = (String)serviceUrl + "/?type=" + type + "&load=" + URLEncoder.encode(load, "UTF-8");
        }
        String urlString = this.constructUrl(variables, (String)serviceUrl);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        HttpPost method = new HttpPost(urlString);
        method.setEntity((HttpEntity)new InputStreamEntity(is));
        method.addHeader((Header)new BasicHeader("Content-Type", "binary/zip"));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendExport(IVariables variables, String filename, String type, String load) throws Exception {
        try (InputStream is = HopVfs.getInputStream((FileObject)HopVfs.getFileObject((String)filename));){
            String string;
            HttpPost method = this.buildSendExportMethod(variables, type, load, is);
            try {
                string = this.executeAuth(variables, (HttpUriRequest)method);
            }
            catch (Throwable throwable) {
                method.releaseConnection();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentExportToService", (String[])new String[]{"/hop/registerPackage", variables.resolve(this.hostname)}));
                }
                throw throwable;
            }
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_SentExportToService", (String[])new String[]{"/hop/registerPackage", variables.resolve(this.hostname)}));
            }
            return string;
        }
    }

    private String executeAuth(IVariables variables, HttpUriRequest method) throws IOException, ClientProtocolException, HopException {
        HttpResponse httpResponse = this.getHttpClient().execute(method, (HttpContext)this.getAuthContext(variables));
        return this.getResponse(variables, method, httpResponse);
    }

    private String getResponse(IVariables variables, HttpUriRequest method, HttpResponse httpResponse) throws IOException, HopException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(statusCode)}));
        }
        String responseBody = this.getResponseBodyAsString(httpResponse.getEntity().getContent());
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
        }
        this.handleStatus(variables, method, statusLine, statusCode);
        return responseBody;
    }

    private void addCredentials(IVariables variables, HttpClientContext context) {
        String host = variables.resolve(this.hostname);
        int port = Const.toInt((String)variables.resolve(this.port), (int)80);
        String userName = variables.resolve(this.username);
        String password = Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(this.password));
        String proxyHost = variables.resolve(this.proxyHostname);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
        if (!Utils.isEmpty((CharSequence)proxyHost) && host.equals("localhost")) {
            host = "127.0.0.1";
        }
        provider.setCredentials(new AuthScope(host, port), (Credentials)credentials);
        context.setCredentialsProvider((CredentialsProvider)provider);
        HttpHost target = new HttpHost(host, port, this.isSslMode() ? HTTPS : HTTP);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
    }

    private void addProxy(IVariables variables, HttpClientContext context) {
        String proxyHost = variables.resolve(this.proxyHostname);
        String proxyPort = variables.resolve(this.proxyPort);
        String nonProxyHosts = variables.resolve(this.nonProxyHosts);
        String hostName = variables.resolve(this.hostname);
        if (Utils.isEmpty((CharSequence)proxyHost) || Utils.isEmpty((CharSequence)proxyPort)) {
            return;
        }
        if (!Utils.isEmpty((CharSequence)nonProxyHosts) && hostName.matches(nonProxyHosts)) {
            return;
        }
        HttpHost httpHost = new HttpHost(proxyHost, Integer.valueOf(proxyPort).intValue());
        RequestConfig requestConfig = RequestConfig.custom().setProxy(httpHost).build();
        context.setRequestConfig(requestConfig);
    }

    protected HttpClientContext getAuthContext(IVariables variables) {
        HttpClientContext context = HttpClientContext.create();
        this.addCredentials(variables, context);
        this.addProxy(variables, context);
        return context;
    }

    public String execService(IVariables variables, String service, boolean retry) throws Exception {
        int tries = 0;
        int maxRetries = 0;
        if (retry) {
            maxRetries = HOP_SERVER_RETRIES;
        }
        while (true) {
            try {
                return this.execService(variables, service);
            }
            catch (Exception e) {
                if (tries >= maxRetries) {
                    throw e;
                }
                try {
                    Thread.sleep(HopServer.getDelay(tries));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++tries;
                continue;
            }
            break;
        }
    }

    public static long getDelay(int trial) {
        long current = HOP_SERVER_RETRY_BACKOFF_INCREMENTS;
        long previous = 0L;
        for (int i = 0; i < trial; ++i) {
            long tmp = current;
            current += previous;
            previous = tmp;
        }
        return current + (long)RANDOM.nextInt((int)Math.min(Integer.MAX_VALUE, current / 4L));
    }

    public String execService(IVariables variables, String service) throws Exception {
        return this.execService(variables, service, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getResponseBodyAsString(InputStream is) throws IOException {
        StringBuilder bodyBuffer = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                bodyBuffer.append(line);
            }
        }
        return bodyBuffer.toString();
    }

    HttpGet buildExecuteServiceMethod(IVariables variables, String service, Map<String, String> headerValues) throws UnsupportedEncodingException {
        HttpGet method = new HttpGet(this.constructUrl(variables, service));
        for (String key : headerValues.keySet()) {
            method.setHeader(key, headerValues.get(key));
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execService(IVariables variables, String service, Map<String, String> headerValues) throws Exception {
        String string;
        HttpGet method = this.buildExecuteServiceMethod(variables, service, headerValues);
        try {
            HttpResponse httpResponse = this.getHttpClient().execute((HttpUriRequest)method, (HttpContext)this.getAuthContext(variables));
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(statusCode)}));
            }
            String responseBody = this.getResponseBodyAsString(httpResponse.getEntity().getContent());
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_FinishedReading", (String[])new String[]{Integer.toString(responseBody.getBytes().length)}));
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
            }
            if (statusCode >= 400) {
                throw new HopException(String.format("HTTP Status %d - %s - %s", statusCode, method.getURI().toString(), statusLine.getReasonPhrase()));
            }
            string = responseBody;
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"HopServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
        }
        return string;
    }

    HttpClient getHttpClient() throws HopException {
        try {
            if (this.sslMode) {
                TrustSelfSignedStrategy acceptingTrustStrategy = new TrustSelfSignedStrategy();
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
            }
            return ServerConnectionManager.getInstance().createHttpClient();
        }
        catch (Exception e) {
            throw new HopException("Error creating new HTTP client", (Throwable)e);
        }
    }

    public HopServerStatus getStatus(IVariables variables) throws Exception {
        String xml = this.execService(variables, "/hop/status/?xml=Y");
        return HopServerStatus.fromXml(xml);
    }

    public HopServerPipelineStatus getPipelineStatus(IVariables variables, String pipelineName, String serverObjectId, int startLogLineNr) throws Exception {
        return this.getPipelineStatus(variables, pipelineName, serverObjectId, startLogLineNr, false);
    }

    public HopServerPipelineStatus getPipelineStatus(IVariables variables, String pipelineName, String serverObjectId, int startLogLineNr, boolean sendResultXmlWithStatus) throws Exception {
        String query = "/hop/pipelineStatus/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr;
        if (sendResultXmlWithStatus) {
            query = query + "&sendResult=Y";
        }
        String xml = this.execService(variables, query, true);
        return HopServerPipelineStatus.fromXml(xml);
    }

    public HopServerWorkflowStatus getWorkflowStatus(IVariables variables, String workflowName, String serverObjectId, int startLogLineNr) throws Exception {
        String xml = this.execService(variables, "/hop/workflowStatus/?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr, true);
        return HopServerWorkflowStatus.fromXml(xml);
    }

    public WebResult stopPipeline(IVariables variables, String pipelineName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/stopPipeline/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXmlString(xml);
    }

    public WebResult pauseResumePipeline(IVariables variables, String pipelineName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/pausePipeline/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXmlString(xml);
    }

    public WebResult removePipeline(IVariables variables, String pipelineName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/removePipeline/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXmlString(xml);
    }

    public WebResult removeWorkflow(IVariables variables, String workflowName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/removeWorkflow/?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXmlString(xml);
    }

    public WebResult stopWorkflow(IVariables variables, String pipelineName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/stopWorkflow/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)serverObjectId, (String)""));
        return WebResult.fromXmlString(xml);
    }

    public WebResult startPipeline(IVariables variables, String pipelineName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/startPipeline/?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + Const.NVL((String)serverObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXmlString(xml);
    }

    public WebResult startWorkflow(IVariables variables, String workflowName, String serverObjectId) throws Exception {
        String xml = this.execService(variables, "/hop/startWorkflow/?name=" + URLEncoder.encode(workflowName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)serverObjectId, (String)""));
        return WebResult.fromXmlString(xml);
    }

    public static HopServer findHopServer(List<HopServer> hopServers, String name) {
        for (HopServer hopServer : hopServers) {
            if (hopServer.getName() == null || !hopServer.getName().equalsIgnoreCase(name)) continue;
            return hopServer;
        }
        return null;
    }

    public static String[] getHopServerNames(IHopMetadataProvider metadataProvider) throws HopException {
        List names = metadataProvider.getSerializer(HopServer.class).listObjectNames();
        return names.toArray(new String[0]);
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String description) {
    }

    public String verifyAndModifyHopServerName(List<HopServer> hopServers, String oldname) {
        String name = this.getName();
        if (name.equalsIgnoreCase(oldname)) {
            return name;
        }
        int nr = 2;
        while (HopServer.findHopServer(hopServers, this.getName()) != null) {
            this.setName(name + " " + nr);
            ++nr;
        }
        return this.getName();
    }

    public String sniffTransform(IVariables variables, String pipelineName, String transformName, String id, String copyNr, int lines, String type) throws Exception {
        return this.execService(variables, "/hop/sniffTransform/?pipeline=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&transform=" + URLEncoder.encode(transformName, "UTF-8") + "&copynr=" + copyNr + "&type=" + type + "&lines=" + lines + "&xml=Y");
    }

    public HopServer getClient() {
        String pHostName = this.getHostname();
        String pPort = this.getPort();
        String shutdownPort = this.getShutdownPort();
        String name = MessageFormat.format("Dynamic server [{0}:{1}]", pHostName, pPort);
        HopServer client = new HopServer(name, pHostName, pPort, shutdownPort, this.getUsername(), this.getPassword());
        client.setSslMode(this.isSslMode());
        return client;
    }

    public void monitorRemotePipeline(IVariables variables, ILogChannel log, String serverObjectId, String pipelineName) {
        this.monitorRemotePipeline(variables, log, serverObjectId, pipelineName, 5);
    }

    public void monitorRemotePipeline(IVariables variables, ILogChannel log, String serverObjectId, String pipelineName, int sleepTimeSeconds) {
        long errors = 0L;
        boolean allFinished = false;
        while (!allFinished && errors == 0L) {
            allFinished = true;
            errors = 0L;
            if (allFinished && errors == 0L) {
                try {
                    HopServerPipelineStatus pipelineStatus = this.getPipelineStatus(variables, pipelineName, serverObjectId, 0);
                    if (pipelineStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(pipelineName, new Object[]{"Remote pipeline is still running."});
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(pipelineName, new Object[]{"Remote pipeline has finished."});
                    }
                    Result result = pipelineStatus.getResult();
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(pipelineName, new Object[]{"Unable to contact remote hop server '" + this.getName() + "' to check pipeline status : " + e.toString()});
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed(pipelineName, new Object[]{"The remote pipeline is still running, waiting a few seconds..."});
            }
            try {
                Thread.sleep(sleepTimeSeconds * 1000);
            }
            catch (Exception exception) {}
        }
        log.logBasic(pipelineName, new Object[]{"The remote pipeline has finished."});
    }

    public void monitorRemoteWorkflow(IVariables variables, ILogChannel log, String serverObjectId, String workflowName) {
        this.monitorRemoteWorkflow(variables, log, serverObjectId, workflowName, 5);
    }

    public void monitorRemoteWorkflow(IVariables variables, ILogChannel log, String serverObjectId, String workflowName, int sleepTimeSeconds) {
        long errors = 0L;
        boolean allFinished = false;
        while (!allFinished && errors == 0L) {
            allFinished = true;
            errors = 0L;
            if (allFinished && errors == 0L) {
                try {
                    HopServerWorkflowStatus jobStatus = this.getWorkflowStatus(variables, workflowName, serverObjectId, 0);
                    if (jobStatus.isRunning()) {
                        if (log.isDetailed()) {
                            log.logDetailed(workflowName, new Object[]{"Remote workflow is still running."});
                        }
                        allFinished = false;
                    } else if (log.isDetailed()) {
                        log.logDetailed(workflowName, new Object[]{"Remote workflow has finished."});
                    }
                    Result result = jobStatus.getResult();
                    errors += result.getNrErrors();
                }
                catch (Exception e) {
                    ++errors;
                    log.logError(workflowName, new Object[]{"Unable to contact remote hop server '" + this.getName() + "' to check workflow status : " + e.toString()});
                }
            }
            if (allFinished) continue;
            if (log.isDetailed()) {
                log.logDetailed(workflowName, new Object[]{"The remote workflow is still running, waiting a few seconds..."});
            }
            try {
                Thread.sleep(sleepTimeSeconds * 1000);
            }
            catch (Exception exception) {}
        }
        log.logBasic(workflowName, new Object[]{"The remote workflow has finished."});
    }

    public Date getChangedDate() {
        return this.changedDate;
    }

    public void setSslMode(boolean sslMode) {
        this.sslMode = sslMode;
    }

    public boolean isSslMode() {
        return this.sslMode;
    }

    public SslConfiguration getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfiguration sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setOverrideExistingProperties(boolean overrideExistingProperties) {
        this.overrideExistingProperties = overrideExistingProperties;
    }

    public void setPropertiesMasterName(String propertiesMasterName) {
        this.propertiesMasterName = propertiesMasterName;
    }
}

