/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.imports.kettle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.filter.NameFileFilter;
import org.apache.hop.core.Const;
import org.apache.hop.core.Props;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.database.NoneDatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlFormatter;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.imp.HopImportBase;
import org.apache.hop.imp.IHopImport;
import org.apache.hop.imp.ImportPlugin;
import org.apache.hop.imports.kettle.KettleConst;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ImportPlugin(id="kettle", name="Kettle Import", description="Imports Kettle/PDI files, metadata and variables", documentationUrl="/plugins/import/kettle-import.html")
public class KettleImport
extends HopImportBase
implements IHopImport {
    private static final Class<?> PKG = KettleImport.class;
    private int kjbCounter;
    private int ktrCounter;
    private int otherCounter;
    private String variablesTargetConfigFile;
    private String connectionsReportFileName;

    /*
     * Exception decompiling
     */
    public void findFilesToImport() throws HopException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleHopFile(FileObject kettleFile) throws HopException {
        Document doc = this.getDocFromFile(kettleFile);
        this.importDbConnections(doc, kettleFile);
        String extension = kettleFile.getName().getExtension();
        Element documentElement = doc.getDocumentElement();
        Element nameSync = doc.createElement("name_sync_with_filename");
        nameSync.appendChild(doc.createTextNode("Y"));
        documentElement.appendChild(nameSync);
        if (extension.equalsIgnoreCase("ktr")) {
            ++this.ktrCounter;
            this.renameNode(doc, documentElement, "pipeline");
            Node targetNode = XmlHandler.getSubNode((Node)documentElement, (String)"info");
            if (targetNode != null) {
                targetNode.insertBefore(nameSync, XmlHandler.getSubNode((Node)targetNode, (String)"description"));
            }
        } else if (extension.equalsIgnoreCase("kjb")) {
            ++this.kjbCounter;
            this.renameNode(doc, documentElement, "workflow");
            documentElement.insertBefore(nameSync, XmlHandler.getSubNode((Node)documentElement, (String)"description"));
        }
        this.processNode(doc, documentElement, EntryType.OTHER, 0);
        int gridSize = Const.toInt((String)new Props().getProperty("CanvasGridSize"), (int)16);
        if (gridSize > 1) {
            this.alignLocations(documentElement, gridSize);
        }
        DOMSource domSource = new DOMSource(doc);
        this.getMigratedFilesMap().put(kettleFile.getName().getURI(), domSource);
    }

    public void importFiles() throws HopException {
        try {
            TransformerFactory transformerFactory = XmlHandler.createSecureTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            Iterator filesIterator = this.getMigratedFilesMap().keySet().iterator();
            while (filesIterator.hasNext() && (this.monitor == null || !this.monitor.isCanceled())) {
                String filename = (String)filesIterator.next();
                DOMSource domSource = (DOMSource)this.getMigratedFilesMap().get(filename);
                FileObject sourceFile = HopVfs.getFileObject((String)filename);
                if (sourceFile.isFolder()) continue;
                String targetFilename = filename.replaceAll(this.inputFolder.getName().getURI(), this.outputFolderName);
                if (domSource != null) {
                    targetFilename = targetFilename.replaceAll("\\.ktr$", ".hpl").replaceAll("\\.kjb$", ".hwf");
                }
                if (this.monitor != null) {
                    this.monitor.subTask("Saving file " + targetFilename);
                }
                FileObject targetFile = HopVfs.getFileObject((String)targetFilename);
                if (this.isSkippingExistingTargetFiles() && targetFile.exists()) continue;
                if (!targetFile.getParent().exists()) {
                    targetFile.getParent().createFolder();
                }
                if (domSource == null) {
                    try {
                        NameFileFilter filter = new NameFileFilter(Collections.singletonList(sourceFile.getName().getBaseName()));
                        targetFile.getParent().copyFrom(sourceFile.getParent(), (FileSelector)new FileFilterSelector((FileFilter)filter));
                        continue;
                    }
                    catch (IOException e) {
                        throw new HopException("Error copying file '" + filename, (Throwable)e);
                    }
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    StreamResult streamResult = new StreamResult(outputStream);
                    try {
                        transformer.transform(domSource, streamResult);
                    }
                    catch (TransformerException e) {
                        throw new HopException("Error importing file " + filename, (Throwable)e);
                    }
                    finally {
                        outputStream.flush();
                        outputStream.close();
                        String xml = XmlFormatter.format((String)new String(outputStream.toByteArray(), StandardCharsets.UTF_8));
                        OutputStream fileStream = HopVfs.getOutputStream((String)targetFilename, (boolean)false);
                        try {
                            fileStream.write(xml.getBytes(StandardCharsets.UTF_8));
                        }
                        finally {
                            if (fileStream == null) continue;
                            fileStream.close();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error importing Kettle files into Hop", (Throwable)e);
        }
    }

    public void importConnections() throws HopException {
        this.collectConnectionsFromSharedXml();
        this.collectConnectionsFromJdbcProperties();
        this.importCollectedConnections();
        this.saveConnectionsReport();
    }

    private void saveConnectionsReport() throws HopException {
        if (this.connectionsList.size() > 0) {
            this.connectionsReportFileName = this.getOutputFolderName() + "/connections.csv";
            try (OutputStream outputStream = HopVfs.getOutputStream((String)this.connectionsReportFileName, (boolean)false);){
                for (Map.Entry entry : this.connectionFileMap.entrySet()) {
                    outputStream.write(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                    outputStream.write(",".getBytes(StandardCharsets.UTF_8));
                    outputStream.write(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                    outputStream.write(Const.CR.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new HopException("Error writing connections.csv file to project", (Throwable)e);
            }
        }
    }

    private void importCollectedConnections() throws HopException {
        IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(DatabaseMeta.class);
        for (DatabaseMeta databaseMeta : this.connectionsList) {
            serializer.save((IHopMetadata)databaseMeta);
        }
    }

    public void collectConnectionsFromSharedXml() throws HopException {
        if (StringUtils.isEmpty((CharSequence)this.sharedXmlFilename)) {
            return;
        }
        Document doc = this.getDocFromFile(HopVfs.getFileObject((String)this.sharedXmlFilename));
        this.importDbConnections(doc, HopVfs.getFileObject((String)this.sharedXmlFilename));
    }

    public void collectConnectionsFromJdbcProperties() throws HopException {
        if (StringUtils.isEmpty((CharSequence)this.jdbcPropertiesFilename)) {
            return;
        }
        try {
            Properties properties = new Properties();
            FileObject varFile = HopVfs.getFileObject((String)this.jdbcPropertiesFilename);
            InputStream inputStream = HopVfs.getInputStream((FileObject)varFile);
            properties.load(inputStream);
            ArrayList<String> connNamesList = new ArrayList<String>();
            for (String connKey : properties.stringPropertyNames()) {
                String connName = connKey.split("/")[0];
                if (connNamesList.contains(connName)) continue;
                connNamesList.add(connName);
            }
            for (String connName : connNamesList) {
                NoneDatabaseMeta database = new NoneDatabaseMeta();
                database.setDriverClass((String)properties.get(connName + "/driver"));
                database.setManualUrl((String)properties.get(connName + "/url"));
                database.setUsername((String)properties.get(connName + "/user"));
                database.setPassword((String)properties.get(connName + "/password"));
                DatabaseMeta databaseMeta = new DatabaseMeta();
                databaseMeta.setName(connName);
                database.setPluginId(databaseMeta.getPluginName());
                databaseMeta.setIDatabase((IDatabase)database);
                this.addDatabaseMeta(varFile.getName().getURI(), databaseMeta);
            }
        }
        catch (Exception e) {
            throw new HopException("Error importing properties database connection", (Throwable)e);
        }
    }

    private void importDbConnections(Document doc, FileObject kettleFile) throws HopException {
        PluginRegistry registry = PluginRegistry.getInstance();
        NodeList connectionList = doc.getElementsByTagName("connection");
        for (int i = 0; i < connectionList.getLength(); ++i) {
            if (!connectionList.item(i).getParentNode().equals(doc.getDocumentElement())) continue;
            Element connElement = (Element)connectionList.item(i);
            String databaseType = connElement.getElementsByTagName("type").item(0).getTextContent();
            IPlugin databasePlugin = registry.findPluginWithId(DatabasePluginType.class, connElement.getElementsByTagName("type").item(0).getTextContent());
            try {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                BaseDatabaseMeta iDatabase = (BaseDatabaseMeta)registry.loadClass(databasePlugin);
                databaseMeta.setIDatabase((IDatabase)iDatabase);
                databaseMeta.setDatabaseType(databaseType);
                if (connElement.getElementsByTagName("name").getLength() > 0) {
                    databaseMeta.setName(this.getTextContent(connElement, "name", 0));
                }
                if (connElement.getElementsByTagName("server").getLength() > 0) {
                    databaseMeta.getIDatabase().setHostname(this.getTextContent(connElement, "server", 0));
                }
                if (connElement.getElementsByTagName("access").getLength() > 0) {
                    databaseMeta.getIDatabase().setAccessType(DatabaseMeta.getAccessType((String)this.getTextContent(connElement, "access", 0)));
                }
                if (connElement.getElementsByTagName("database").getLength() > 0) {
                    databaseMeta.getIDatabase().setDatabaseName(this.getTextContent(connElement, "database", 0));
                }
                if (connElement.getElementsByTagName("port").getLength() > 0) {
                    databaseMeta.getIDatabase().setPort(this.getTextContent(connElement, "port", 0));
                }
                if (connElement.getElementsByTagName("username").getLength() > 0) {
                    databaseMeta.getIDatabase().setUsername(this.getTextContent(connElement, "username", 0));
                }
                if (connElement.getElementsByTagName("password").getLength() > 0) {
                    databaseMeta.getIDatabase().setPassword(this.getTextContent(connElement, "password", 0));
                }
                if (connElement.getElementsByTagName("servername").getLength() > 0 && !Utils.isEmpty((CharSequence)this.getTextContent(connElement, "servername", 0))) {
                    databaseMeta.getIDatabase().setServername(this.getTextContent(connElement, "servername", 0));
                }
                if (connElement.getElementsByTagName("tablespace").getLength() > 0 && !Utils.isEmpty((CharSequence)this.getTextContent(connElement, "tablespace", 0))) {
                    databaseMeta.getIDatabase().setDataTablespace(this.getTextContent(connElement, "tablespace", 0));
                }
                if (connElement.getElementsByTagName("data_tablespace").getLength() > 0 && !Utils.isEmpty((CharSequence)this.getTextContent(connElement, "data_tablespace", 0))) {
                    databaseMeta.getIDatabase().setDataTablespace(this.getTextContent(connElement, "data_tablespace", 0));
                }
                if (connElement.getElementsByTagName("index_tablespace").getLength() > 0 && !Utils.isEmpty((CharSequence)this.getTextContent(connElement, "index_tablespace", 0))) {
                    databaseMeta.getIDatabase().setIndexTablespace(this.getTextContent(connElement, "index_tablespace", 0));
                }
                HashMap<String, String> attributesMap = new HashMap<String, String>();
                NodeList connNodeList = connElement.getElementsByTagName("attributes");
                for (int j = 0; j < connNodeList.getLength(); ++j) {
                    if (!connNodeList.item(j).getNodeName().equals("attributes")) continue;
                    Node attributesNode = connNodeList.item(j);
                    for (int k = 0; k < attributesNode.getChildNodes().getLength(); ++k) {
                        Node attributeNode = attributesNode.getChildNodes().item(k);
                        String code = "";
                        String attribute = "";
                        for (int l = 0; l < attributeNode.getChildNodes().getLength(); ++l) {
                            if (attributeNode.getChildNodes().item(l).getNodeName().equals("code")) {
                                code = attributeNode.getChildNodes().item(l).getTextContent();
                            }
                            if (attributeNode.getChildNodes().item(l).getNodeName().equals("attribute")) {
                                attribute = attributeNode.getChildNodes().item(l).getTextContent();
                            }
                            if (Utils.isEmpty((CharSequence)code) || Utils.isEmpty((CharSequence)attribute)) continue;
                            attributesMap.put(code, attribute);
                        }
                    }
                }
                databaseMeta.getIDatabase().setAttributes(attributesMap);
                this.addDatabaseMeta(kettleFile.getName().getURI(), databaseMeta);
                continue;
            }
            catch (Exception e) {
                throw new HopException("Error importing database type '" + databaseType + "' from file '" + kettleFile.getName().getURI() + "'", (Throwable)e);
            }
        }
    }

    public void importVariables() throws HopException {
        if (StringUtils.isEmpty((CharSequence)this.kettlePropertiesFilename) || StringUtils.isEmpty((CharSequence)this.targetConfigFilename)) {
            return;
        }
        this.collectVariablesFromKettleProperties();
        this.variablesTargetConfigFile = this.outputFolderName + "/" + this.targetConfigFilename;
        Object[] payload = new Object[]{this.variablesTargetConfigFile, this.collectedVariables};
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)"HopImportVariables", (Object)payload);
    }

    private void renameNode(Document doc, Element element, String newElementName) {
        doc.renameNode(element, null, newElementName);
    }

    private void processNode(Document doc, Node node, EntryType entryType, int depth) {
        Node nodeToProcess = node;
        NodeList nodeList = nodeToProcess.getChildNodes();
        ++depth;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node repositoryNode = nodeList.item(i);
            if (repositoryNode.getNodeType() != 1 || !KettleConst.repositoryTypes.contains(repositoryNode.getTextContent())) continue;
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node childNode = node.getChildNodes().item(j);
                if (!childNode.getNodeName().equals("jobname") && !childNode.getNodeName().equals("transname") || StringUtil.isEmpty((String)childNode.getTextContent())) continue;
                nodeToProcess = this.processRepositoryNode(node);
            }
            nodeList = nodeToProcess.getChildNodes();
        }
        Node firstFormulaNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() == 1) {
                if (currentNode.getNodeName().equals("entry")) {
                    entryType = EntryType.OTHER;
                    Node entryTypeNode = null;
                    boolean isEntryTypeSpecial = false;
                    NodeList currentNodeChildNodes = currentNode.getChildNodes();
                    for (int i1 = 0; i1 < currentNodeChildNodes.getLength(); ++i1) {
                        Node childNode = currentNodeChildNodes.item(i1);
                        if (childNode.getNodeType() != 1) continue;
                        if (childNode.getNodeName().equals("type") && childNode.getChildNodes().item(0).getNodeValue().equals("SPECIAL")) {
                            isEntryTypeSpecial = true;
                            entryTypeNode = childNode;
                            continue;
                        }
                        if (childNode.getNodeName().equals("type") && childNode.getChildNodes().item(0).getNodeValue().equals("TRANS")) {
                            entryType = EntryType.TRANS;
                            continue;
                        }
                        if (childNode.getNodeName().equals("type") && childNode.getChildNodes().item(0).getNodeValue().equals("JOB")) {
                            entryType = EntryType.JOB;
                            continue;
                        }
                        if (isEntryTypeSpecial && childNode.getNodeName().equals("start") && childNode.getChildNodes().item(0).getNodeValue().equals("Y")) {
                            entryType = EntryType.START;
                            continue;
                        }
                        if (!isEntryTypeSpecial || !childNode.getNodeName().equals("dummy") || !childNode.getChildNodes().item(0).getNodeValue().equals("Y")) continue;
                        entryType = EntryType.DUMMY;
                        entryTypeNode.getFirstChild().setTextContent("DUMMY");
                    }
                }
                if (currentNode.getNodeName().equals("step")) {
                    entryType = EntryType.OTHER;
                    NodeList currentNodeChildNodes = currentNode.getChildNodes();
                    for (int i1 = 0; i1 < currentNodeChildNodes.getLength(); ++i1) {
                        Node childNode = currentNodeChildNodes.item(i1);
                        if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("type") || !childNode.getChildNodes().item(0).getNodeValue().equals("Formula")) continue;
                        entryType = EntryType.FORMULA;
                    }
                }
                if (entryType == EntryType.OTHER) {
                    if (KettleConst.kettleElementsToRemove.containsKey(currentNode.getNodeName())) {
                        if (!StringUtils.isEmpty((CharSequence)KettleConst.kettleElementsToRemove.get(currentNode.getNodeName()))) {
                            if (KettleConst.kettleElementsToRemove.get(currentNode.getNodeName()).contains(",")) {
                                String[] parentNodeNames;
                                Node parentNode = currentNode.getParentNode();
                                for (String parentNodeName : parentNodeNames = KettleConst.kettleElementsToRemove.get(currentNode.getNodeName()).split(",")) {
                                    if (!parentNode.getNodeName().equals(parentNodeName)) continue;
                                    parentNode.removeChild(currentNode);
                                }
                            } else if (currentNode.getParentNode().getNodeName().equals(KettleConst.kettleElementsToRemove.get(currentNode.getNodeName()))) {
                                currentNode.getParentNode().removeChild(currentNode);
                            }
                        } else {
                            currentNode.getParentNode().removeChild(currentNode);
                        }
                    }
                } else if (entryType == EntryType.START) {
                    if (KettleConst.kettleStartEntryElementsToRemove.containsKey(currentNode.getNodeName())) {
                        currentNode.getParentNode().removeChild(currentNode);
                    }
                } else if (entryType == EntryType.DUMMY && KettleConst.kettleDummyEntryElementsToRemove.containsKey(currentNode.getNodeName())) {
                    currentNode.getParentNode().removeChild(currentNode);
                }
                if (entryType == EntryType.FORMULA && currentNode.getNodeName().equals("formula")) {
                    if (firstFormulaNode == null) {
                        Element formulasElement = doc.createElement("formulas");
                        formulasElement.appendChild(currentNode);
                        firstFormulaNode = formulasElement;
                    } else {
                        firstFormulaNode.appendChild(currentNode);
                    }
                } else if (entryType == EntryType.FORMULA && !currentNode.getNodeName().equals("formula") && firstFormulaNode != null && depth == 2) {
                    node.appendChild(firstFormulaNode);
                    entryType = EntryType.OTHER;
                    firstFormulaNode = null;
                } else if (entryType == EntryType.FORMULA && currentNode.getNodeName().equals("formula_string")) {
                    String formulaValue = currentNode.getFirstChild().getNodeValue();
                    currentNode.getFirstChild().setNodeValue(formulaValue.replaceAll(";", ","));
                } else if (entryType == EntryType.FORMULA && currentNode.getNodeName().equals("value_type")) {
                    String formulaType = currentNode.getFirstChild().getNodeValue();
                    currentNode.getFirstChild().setNodeValue(Integer.toString(ValueMetaFactory.getIdForValueMeta((String)formulaType)));
                }
                if ((entryType == EntryType.JOB || entryType == EntryType.TRANS) && currentNode.getNodeName().equals("run_configuration")) {
                    if (entryType == EntryType.JOB) {
                        currentNode.setTextContent(this.defaultWorkflowRunConfiguration);
                    } else if (entryType == EntryType.TRANS) {
                        currentNode.setTextContent(this.defaultPipelineRunConfiguration);
                    }
                }
                if (KettleConst.kettleElementReplacements.containsKey(currentNode.getNodeName())) {
                    this.renameNode(doc, (Element)currentNode, KettleConst.kettleElementReplacements.get(currentNode.getNodeName()));
                }
                if (KettleConst.kettleReplaceContent.containsKey(currentNode.getTextContent())) {
                    currentNode.setTextContent(KettleConst.kettleReplaceContent.get(currentNode.getTextContent()));
                }
                this.processNode(doc, currentNode, entryType, depth);
            }
            if (currentNode.getNodeType() != 3 || StringUtils.isEmpty((CharSequence)currentNode.getTextContent())) continue;
            for (Map.Entry<String, String> entry : KettleConst.kettleReplaceInContent.entrySet()) {
                if (!currentNode.getTextContent().contains(entry.getKey())) continue;
                currentNode.setTextContent(currentNode.getTextContent().replace(entry.getKey(), entry.getValue()));
            }
        }
    }

    private Node processRepositoryNode(Node repositoryNode) {
        String filename = "";
        Object directory = "${PROJECT_HOME}";
        String type = "";
        Node filenameNode = null;
        for (int i = 0; i < repositoryNode.getChildNodes().getLength(); ++i) {
            Node childNode = repositoryNode.getChildNodes().item(i);
            if (childNode.getNodeName().equals("directory")) {
                directory = childNode.getTextContent().startsWith(System.getProperty("file.separator")) ? (String)directory + childNode.getTextContent() : (String)directory + System.getProperty("file.separator") + childNode.getTextContent();
                repositoryNode.removeChild(childNode);
            }
            if (childNode.getNodeName().equals("type")) {
                if (KettleConst.jobTypes.contains(childNode.getTextContent())) {
                    type = ".hwf";
                }
                if (KettleConst.transTypes.contains(childNode.getTextContent())) {
                    type = ".hpl";
                }
            }
            if (childNode.getNodeName().equals("filename")) {
                filename = childNode.getTextContent().replaceAll(".ktr", "").replaceAll(".kjb", "");
                childNode.setTextContent(filename + type);
                filenameNode = childNode;
            }
            if (childNode.getNodeName().equals("run_configuration")) {
                childNode.setTextContent("local");
            }
            if (!childNode.getNodeName().equals("jobname") && !childNode.getNodeName().equals("transname")) continue;
            filename = childNode.getTextContent();
            repositoryNode.removeChild(childNode);
        }
        filenameNode.setTextContent((String)directory + "/" + filename + type);
        return repositoryNode;
    }

    private Document getDocFromFile(FileObject kettleFile) throws HopException {
        try {
            DocumentBuilderFactory dbFactory = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            dbFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(HopVfs.getInputStream((FileObject)kettleFile));
        }
        catch (Exception e) {
            throw new HopException("Error importing file '" + kettleFile + "'", (Throwable)e);
        }
    }

    private String getTextContent(Element element, String tagName, Integer itemIndex) {
        return element.getElementsByTagName(tagName).item(itemIndex).getTextContent();
    }

    private void alignLocations(Node parentNode, int gridSize) {
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("xloc") || nodeName.equals("yloc")) {
                int value = Const.toInt((String)childNode.getTextContent(), (int)0);
                childNode.setTextContent(Integer.toString(gridSize * Math.round(value / gridSize)));
            }
            this.alignLocations(childNode, gridSize);
        }
    }

    public String getImportReport() {
        String eol = System.getProperty("line.separator");
        String messageString = BaseMessages.getString(PKG, (String)"KettleImportDialog.ImportSummary.Imported.Label", (String[])new String[0]) + eol;
        if (this.getKjbCounter() > 0) {
            messageString = messageString + this.getKjbCounter() + " " + BaseMessages.getString(PKG, (String)"KettleImportDialog.ImportSummary.ImportedJobs.Label", (String[])new String[0]) + eol;
        }
        if (this.getKtrCounter() > 0) {
            messageString = messageString + this.getKtrCounter() + " " + BaseMessages.getString(PKG, (String)"KettleImportDialog.ImportSummary.ImportedTransf.Label", (String[])new String[0]) + eol;
        }
        if (this.getOtherCounter() > 0) {
            messageString = messageString + this.getOtherCounter() + " " + BaseMessages.getString(PKG, (String)"KettleImportDialog.ImportSummary.ImportedOther.Label", (String[])new String[0]) + eol;
        }
        if (this.getVariableCounter() > 0) {
            messageString = messageString + this.getVariableCounter() + " variables were imported into environment config file " + this.getVariablesTargetConfigFile() + eol + "You can use this as a configuration file in an environment." + eol;
        }
        if (this.getConnectionCounter() > 0) {
            messageString = messageString + this.getConnectionCounter() + " database connections where saved in metadata folder " + this.getMetadataTargetFolder() + eol + eol;
            messageString = messageString + "Connections with the same name and different configurations have only been saved once." + eol;
            messageString = messageString + "Check the following file for a list of connections that might need extra attention: " + this.getConnectionsReportFileName();
        }
        return messageString;
    }

    public int getKjbCounter() {
        return this.kjbCounter;
    }

    public void setKjbCounter(int kjbCounter) {
        this.kjbCounter = kjbCounter;
    }

    public int getKtrCounter() {
        return this.ktrCounter;
    }

    public void setKtrCounter(int ktrCounter) {
        this.ktrCounter = ktrCounter;
    }

    public int getOtherCounter() {
        return this.otherCounter;
    }

    public void setOtherCounter(int otherCounter) {
        this.otherCounter = otherCounter;
    }

    public String getVariablesTargetConfigFile() {
        return this.variablesTargetConfigFile;
    }

    public void setVariablesTargetConfigFile(String variablesTargetConfigFile) {
        this.variablesTargetConfigFile = variablesTargetConfigFile;
    }

    public String getConnectionsReportFileName() {
        return this.connectionsReportFileName;
    }

    public void setConnectionsReportFileName(String connectionsReportFileName) {
        this.connectionsReportFileName = connectionsReportFileName;
    }

    private static enum EntryType {
        TRANS,
        JOB,
        START,
        DUMMY,
        FORMULA,
        OTHER;

    }
}

