/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCManagedDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class AS400JDBCManagedConnectionPoolDataSource
extends AS400JDBCManagedDataSource
implements ConnectionPoolDataSource,
Referenceable,
Serializable {
    static final long serialVersionUID = 1L;
    private int initialPoolSize_ = 5;
    private int minPoolSize_ = 0;
    private int maxPoolSize_ = 0;
    private long maxIdleTime_ = 3600000L;
    private long propertyCycle_ = 300000L;
    private long maxLifetime_ = 86400000L;
    private boolean reuseConnections_ = true;
    private boolean pretestConnections_ = false;
    private boolean enforceMaxPoolSize_ = false;

    public AS400JDBCManagedConnectionPoolDataSource() {
    }

    public AS400JDBCManagedConnectionPoolDataSource(String string) {
        super(string);
    }

    public AS400JDBCManagedConnectionPoolDataSource(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public AS400JDBCManagedConnectionPoolDataSource(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4, string5);
    }

    AS400JDBCManagedConnectionPoolDataSource(Reference reference) {
        super(reference);
        RefAddr refAddr = reference.get("enforceMaxPoolSize");
        if (refAddr != null) {
            this.setEnforceMaxPoolSize(Boolean.valueOf((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("initialPoolSize")) != null) {
            this.setInitialPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxLifetime")) != null) {
            this.setMaxLifetime(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("minPoolSize")) != null) {
            this.setMinPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxPoolSize")) != null) {
            this.setMaxPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxIdleTime")) != null) {
            this.setMaxIdleTime(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("pretestConnections")) != null) {
            this.setPretestConnections(Boolean.valueOf((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("propertyCycle")) != null) {
            this.setPropertyCycle(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("reuseConnections")) != null) {
            this.setReuseConnections(Boolean.valueOf((String)refAddr.getContent()));
        }
    }

    public boolean checkPoolHealth(boolean bl) {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.checkPoolHealth() is deprecated");
        return super.checkPoolHealth(bl);
    }

    public void closePool() {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.closePool() is deprecated");
        super.closePool();
    }

    public Connection getConnection() throws SQLException {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.getConnection() is deprecated");
        return super.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.getConnection() is deprecated");
        return super.getConnection(string, string2);
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize_;
    }

    public int getMaxIdleTime() {
        return (int)(this.maxIdleTime_ / 1000L);
    }

    public int getMaxLifetime() {
        return (int)(this.maxLifetime_ / 1000L);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public int getMinPoolSize() {
        return this.minPoolSize_;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        AS400JDBCPooledConnection aS400JDBCPooledConnection = new AS400JDBCPooledConnection(this.createPhysicalConnection());
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation("PooledConnection created");
        }
        return aS400JDBCPooledConnection;
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        AS400JDBCPooledConnection aS400JDBCPooledConnection = new AS400JDBCPooledConnection(this.createPhysicalConnection(string, string2));
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation("PooledConnection created for user " + string);
        }
        return aS400JDBCPooledConnection;
    }

    public int getPropertyCycle() {
        return (int)(this.propertyCycle_ / 1000L);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        reference.add(new StringRefAddr("enforceMaxPoolSize", String.valueOf(this.isEnforceMaxPoolSize())));
        reference.add(new StringRefAddr("initialPoolSize", String.valueOf(this.getInitialPoolSize())));
        reference.add(new StringRefAddr("maxLifetime", String.valueOf(this.getMaxLifetime())));
        reference.add(new StringRefAddr("minPoolSize", String.valueOf(this.getMinPoolSize())));
        reference.add(new StringRefAddr("maxPoolSize", String.valueOf(this.getMaxPoolSize())));
        reference.add(new StringRefAddr("maxIdleTime", String.valueOf(this.getMaxIdleTime())));
        reference.add(new StringRefAddr("pretestConnections", String.valueOf(this.isPretestConnections())));
        reference.add(new StringRefAddr("propertyCycle", String.valueOf(this.getPropertyCycle())));
        reference.add(new StringRefAddr("reuseConnections", String.valueOf(this.isReuseConnections())));
        Reference reference2 = super.getReference();
        for (int i = 0; i < reference2.size(); ++i) {
            reference.add(reference2.get(i));
        }
        return reference;
    }

    static final boolean isConnectionPoolProperty(String string) {
        return string.equals("initialPoolSize") || string.equals("enforceMaxPoolSize") || string.equals("maxLifetime") || string.equals("minPoolSize") || string.equals("maxPoolSize") || string.equals("maxIdleTime") || string.equals("pretestConnections") || string.equals("propertyCycle") || string.equals("reuseConnections");
    }

    public boolean isEnforceMaxPoolSize() {
        return this.enforceMaxPoolSize_;
    }

    public boolean isPretestConnections() {
        return this.pretestConnections_;
    }

    public boolean isReuseConnections() {
        return this.reuseConnections_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setEnforceMaxPoolSize(boolean bl) {
        this.enforceMaxPoolSize_ = bl;
        this.logProperty("enforceMaxPoolSize", String.valueOf(this.enforceMaxPoolSize_));
    }

    public void setInitialPoolSize(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("initialPoolSize", 4);
        }
        this.initialPoolSize_ = n;
        this.logProperty("initialPoolSize", Integer.toString(this.initialPoolSize_));
    }

    public void setMaxIdleTime(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("maxIdleTime", 4);
        }
        this.maxIdleTime_ = n * 1000;
        this.logProperty("maxIdleTime", Integer.toString(n));
    }

    public void setMaxLifetime(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("maxLifetime", 4);
        }
        this.maxLifetime_ = n * 1000;
        this.logProperty("maxLifetime", Integer.toString(n));
    }

    public void setMaxPoolSize(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("maxPoolSize", 4);
        }
        this.maxPoolSize_ = n;
        this.logProperty("maxPoolSize", Integer.toString(this.maxPoolSize_));
    }

    public void setMinPoolSize(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("minPoolSize", 4);
        }
        this.minPoolSize_ = n;
        this.logProperty("minPoolSize", Integer.toString(this.minPoolSize_));
    }

    public void setPretestConnections(boolean bl) {
        this.pretestConnections_ = bl;
        this.logProperty("pretestConnections", String.valueOf(this.pretestConnections_));
    }

    public void setPropertyCycle(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("propertyCycle", 4);
        }
        this.propertyCycle_ = n * 1000;
        this.logProperty("propertyCycle", Integer.toString(n));
    }

    public void setReuseConnections(boolean bl) {
        this.reuseConnections_ = bl;
        this.logProperty("reuseConnections", String.valueOf(this.reuseConnections_));
    }
}

