/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.http.HttpCredentialsAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsCredentials;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputField;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GoogleSheetsInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GoogleSheetsInputMeta.class;
    private final GoogleSheetsInputMeta meta;
    private Label wlTestServiceAccountInfo;
    private TextVar wPrivateKeyStore;
    private TextVar wAppname;
    private TextVar wTimeout;
    private TextVar wImpersonation;
    private TextVar wSpreadSheetKey;
    private TextVar wWorksheetId;
    private TextVar wSampleFields;
    private TableView wFields;

    public GoogleSheetsInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String name) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, name);
        this.meta = (GoogleSheetsInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsInput.transform.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsInput.transform.Name", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)tabFolder, (int)4);
        tabFolder.setSimple(false);
        CTabItem serviceAccountTab = new CTabItem(tabFolder, 0);
        serviceAccountTab.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Tab.ServiceAccount", (String[])new String[0]));
        Composite serviceAccountComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)serviceAccountComposite);
        FormLayout serviceAccountLayout = new FormLayout();
        serviceAccountLayout.marginWidth = 3;
        serviceAccountLayout.marginHeight = 3;
        serviceAccountComposite.setLayout((Layout)serviceAccountLayout);
        Label wlPrivateKeyStore = new Label(serviceAccountComposite, 131072);
        wlPrivateKeyStore.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.PrivateKeyStore", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrivateKeyStore);
        FormData fdlPrivateKeyStore = new FormData();
        fdlPrivateKeyStore.top = new FormAttachment(0, margin);
        fdlPrivateKeyStore.left = new FormAttachment(0, 0);
        fdlPrivateKeyStore.right = new FormAttachment(middle, -margin);
        wlPrivateKeyStore.setLayoutData((Object)fdlPrivateKeyStore);
        Button wbPrivateKeyButton = new Button(serviceAccountComposite, 0x1000008);
        PropsUi.setLook((Widget)wbPrivateKeyButton);
        wbPrivateKeyButton.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbPrivateKeyStore = new FormData();
        fdbPrivateKeyStore.top = new FormAttachment(0, margin);
        fdbPrivateKeyStore.right = new FormAttachment(100, 0);
        wbPrivateKeyButton.setLayoutData((Object)fdbPrivateKeyStore);
        wbPrivateKeyButton.addListener(13, e -> this.selectPrivateKeyStoreFile());
        this.wPrivateKeyStore = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wPrivateKeyStore);
        FormData fdPrivateKeyStore = new FormData();
        fdPrivateKeyStore.top = new FormAttachment(0, margin);
        fdPrivateKeyStore.left = new FormAttachment(middle, 0);
        fdPrivateKeyStore.right = new FormAttachment((Control)wbPrivateKeyButton, -margin);
        this.wPrivateKeyStore.setLayoutData((Object)fdPrivateKeyStore);
        Label appNameLabel = new Label(serviceAccountComposite, 131072);
        appNameLabel.setText("Google Application Name :");
        PropsUi.setLook((Widget)appNameLabel);
        FormData appNameLabelForm = new FormData();
        appNameLabelForm.top = new FormAttachment((Control)wbPrivateKeyButton, margin);
        appNameLabelForm.left = new FormAttachment(0, 0);
        appNameLabelForm.right = new FormAttachment(middle, -margin);
        appNameLabel.setLayoutData((Object)appNameLabelForm);
        this.wAppname = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wAppname);
        FormData appNameData = new FormData();
        appNameData.top = new FormAttachment((Control)wbPrivateKeyButton, margin);
        appNameData.left = new FormAttachment(middle, 0);
        appNameData.right = new FormAttachment((Control)wbPrivateKeyButton, -margin);
        this.wAppname.setLayoutData((Object)appNameData);
        Label timeoutLabel = new Label(serviceAccountComposite, 131072);
        timeoutLabel.setText("Time out in minutes :");
        PropsUi.setLook((Widget)timeoutLabel);
        FormData timeoutLabelForm = new FormData();
        timeoutLabelForm.top = new FormAttachment((Control)appNameLabel, margin);
        timeoutLabelForm.left = new FormAttachment(0, 0);
        timeoutLabelForm.right = new FormAttachment(middle, -margin);
        timeoutLabel.setLayoutData((Object)timeoutLabelForm);
        this.wTimeout = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wTimeout);
        FormData timeoutData = new FormData();
        timeoutData.top = new FormAttachment((Control)appNameLabel, margin);
        timeoutData.left = new FormAttachment(middle, 0);
        timeoutData.right = new FormAttachment((Control)wbPrivateKeyButton, -margin);
        this.wTimeout.setLayoutData((Object)timeoutData);
        Label impersonationLabel = new Label(serviceAccountComposite, 131072);
        impersonationLabel.setText("Inpersonation account :");
        PropsUi.setLook((Widget)impersonationLabel);
        FormData impersonationLabelForm = new FormData();
        impersonationLabelForm.top = new FormAttachment((Control)this.wTimeout, margin);
        impersonationLabelForm.left = new FormAttachment(0, 0);
        impersonationLabelForm.right = new FormAttachment(middle, -margin);
        impersonationLabel.setLayoutData((Object)impersonationLabelForm);
        this.wImpersonation = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wImpersonation);
        FormData impersonationData = new FormData();
        impersonationData.top = new FormAttachment((Control)this.wTimeout, margin);
        impersonationData.left = new FormAttachment(middle, 0);
        impersonationData.right = new FormAttachment((Control)wbPrivateKeyButton, -margin);
        this.wImpersonation.setLayoutData((Object)impersonationData);
        Button wbTestServiceAccount = new Button(serviceAccountComposite, 0x1000008);
        PropsUi.setLook((Widget)wbTestServiceAccount);
        wbTestServiceAccount.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Button.TestConnection", (String[])new String[0]));
        FormData fdbTestServiceAccount = new FormData();
        fdbTestServiceAccount.top = new FormAttachment((Control)this.wImpersonation, margin);
        fdbTestServiceAccount.left = new FormAttachment(0, 0);
        wbTestServiceAccount.setLayoutData((Object)fdbTestServiceAccount);
        wbTestServiceAccount.addListener(13, e -> this.testServiceAccount());
        this.wlTestServiceAccountInfo = new Label(serviceAccountComposite, 16384);
        PropsUi.setLook((Widget)this.wlTestServiceAccountInfo);
        FormData fdlTestServiceAccountInfo = new FormData();
        fdlTestServiceAccountInfo.top = new FormAttachment((Control)this.wImpersonation, margin);
        fdlTestServiceAccountInfo.left = new FormAttachment(middle, 0);
        fdlTestServiceAccountInfo.right = new FormAttachment(100, 0);
        this.wlTestServiceAccountInfo.setLayoutData((Object)fdlTestServiceAccountInfo);
        FormData fdServiceAccountComposite = new FormData();
        fdServiceAccountComposite.left = new FormAttachment(0, 0);
        fdServiceAccountComposite.top = new FormAttachment(0, 0);
        fdServiceAccountComposite.right = new FormAttachment(100, 0);
        fdServiceAccountComposite.bottom = new FormAttachment(100, 0);
        serviceAccountComposite.setLayoutData((Object)fdServiceAccountComposite);
        serviceAccountComposite.layout();
        serviceAccountTab.setControl((Control)serviceAccountComposite);
        CTabItem spreadsheetTab = new CTabItem(tabFolder, 0);
        spreadsheetTab.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Tab.Spreadsheet", (String[])new String[0]));
        Composite spreadsheetComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)spreadsheetComposite);
        FormLayout spreadsheetLayout = new FormLayout();
        spreadsheetLayout.marginWidth = 3;
        spreadsheetLayout.marginHeight = 3;
        spreadsheetComposite.setLayout((Layout)spreadsheetLayout);
        Label wlSpreadSheetKey = new Label(spreadsheetComposite, 131072);
        wlSpreadSheetKey.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.SpreadsheetKey", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpreadSheetKey);
        FormData fdlSpreadSheetKey = new FormData();
        fdlSpreadSheetKey.top = new FormAttachment(0, margin);
        fdlSpreadSheetKey.left = new FormAttachment(0, 0);
        fdlSpreadSheetKey.right = new FormAttachment(middle, -margin);
        wlSpreadSheetKey.setLayoutData((Object)fdlSpreadSheetKey);
        Button wbSpreadSheetKey = new Button(spreadsheetComposite, 0x1000008);
        wbSpreadSheetKey.setText(BaseMessages.getString((String)"System.Button.Browse"));
        PropsUi.setLook((Widget)wbSpreadSheetKey);
        FormData fdbSpreadSheetKey = new FormData();
        fdbSpreadSheetKey.top = new FormAttachment(0, margin);
        fdbSpreadSheetKey.right = new FormAttachment(100, 0);
        wbSpreadSheetKey.setLayoutData((Object)fdbSpreadSheetKey);
        wbSpreadSheetKey.addListener(13, e -> this.selectSpreadSheet());
        this.wSpreadSheetKey = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wSpreadSheetKey);
        FormData fdSpreadSheetKey = new FormData();
        fdSpreadSheetKey.top = new FormAttachment(0, margin);
        fdSpreadSheetKey.left = new FormAttachment(middle, 0);
        fdSpreadSheetKey.right = new FormAttachment((Control)wbSpreadSheetKey, -margin);
        this.wSpreadSheetKey.setLayoutData((Object)fdSpreadSheetKey);
        Label wlWorksheetId = new Label(spreadsheetComposite, 131072);
        wlWorksheetId.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.WorksheetId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorksheetId);
        FormData fdlWorksheetId = new FormData();
        fdlWorksheetId.top = new FormAttachment((Control)wbSpreadSheetKey, margin);
        fdlWorksheetId.left = new FormAttachment(0, 0);
        fdlWorksheetId.right = new FormAttachment(middle, -margin);
        wlWorksheetId.setLayoutData((Object)fdlWorksheetId);
        Button wbWorksheetId = new Button(spreadsheetComposite, 0x1000008);
        wbWorksheetId.setText(BaseMessages.getString((String)"System.Button.Browse"));
        PropsUi.setLook((Widget)wbWorksheetId);
        FormData fdbWorksheetId = new FormData();
        fdbWorksheetId.top = new FormAttachment((Control)wbSpreadSheetKey, margin);
        fdbWorksheetId.right = new FormAttachment(100, 0);
        wbWorksheetId.setLayoutData((Object)fdbWorksheetId);
        wbWorksheetId.addListener(13, e -> this.selectWorksheet());
        this.wWorksheetId = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wWorksheetId);
        FormData fdWorksheetId = new FormData();
        fdWorksheetId.top = new FormAttachment((Control)wbSpreadSheetKey, margin);
        fdWorksheetId.left = new FormAttachment(middle, 0);
        fdWorksheetId.right = new FormAttachment((Control)wbWorksheetId, -margin);
        this.wWorksheetId.setLayoutData((Object)fdWorksheetId);
        FormData fdSpreadsheetComposite = new FormData();
        fdSpreadsheetComposite.left = new FormAttachment(0, 0);
        fdSpreadsheetComposite.top = new FormAttachment(0, 0);
        fdSpreadsheetComposite.right = new FormAttachment(100, 0);
        fdSpreadsheetComposite.bottom = new FormAttachment(100, 0);
        spreadsheetComposite.setLayoutData((Object)fdSpreadsheetComposite);
        spreadsheetComposite.layout();
        spreadsheetTab.setControl((Control)spreadsheetComposite);
        CTabItem fieldsTab = new CTabItem(tabFolder, 0);
        fieldsTab.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Tab.Fields", (String[])new String[0]));
        Composite fieldsComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)fieldsComposite);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        fieldsComposite.setLayout((Layout)fieldsLayout);
        Label wlSampleFieldsLabel = new Label(fieldsComposite, 131072);
        wlSampleFieldsLabel.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.NrOfSampleLines", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSampleFieldsLabel);
        FormData fdlSampleFields = new FormData();
        fdlSampleFields.top = new FormAttachment(0, margin);
        fdlSampleFields.left = new FormAttachment(0, 0);
        fdlSampleFields.right = new FormAttachment(middle, -margin);
        wlSampleFieldsLabel.setLayoutData((Object)fdlSampleFields);
        this.wSampleFields = new TextVar(this.variables, fieldsComposite, 18436);
        PropsUi.setLook((Widget)this.wSampleFields);
        FormData fdSampleFields = new FormData();
        fdSampleFields.top = new FormAttachment(0, margin);
        fdSampleFields.left = new FormAttachment(middle, 0);
        fdSampleFields.right = new FormAttachment(100, -margin);
        this.wSampleFields.setLayoutData((Object)fdSampleFields);
        this.wGet = new Button(fieldsComposite, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getSpreadsheetFields());
        ColumnInfo[] columnInformation = new ColumnInfo[]{new ColumnInfo("Name", 1, false), new ColumnInfo("Type", 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo("Format", 5, 2), new ColumnInfo("Length", 1, false), new ColumnInfo("Precision", 1, false), new ColumnInfo("Currency", 1, false), new ColumnInfo("Decimal", 1, false), new ColumnInfo("Group", 1, false), new ColumnInfo("Trim type", 2, ValueMetaString.trimTypeDesc)};
        this.wFields = new TableView(this.variables, fieldsComposite, 65538, columnInformation, 1, null, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)this.wSampleFields, margin);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComposite = new FormData();
        fdFieldsComposite.left = new FormAttachment(0, 0);
        fdFieldsComposite.top = new FormAttachment(0, 0);
        fdFieldsComposite.right = new FormAttachment(100, 0);
        fdFieldsComposite.bottom = new FormAttachment(100, 0);
        fieldsComposite.setLayoutData((Object)fdFieldsComposite);
        this.setButtonPositions(new Button[]{this.wGet}, margin, null);
        fieldsComposite.layout();
        fieldsTab.setControl((Control)fieldsComposite);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        tabFolder.setLayoutData((Object)fdTabFolder);
        tabFolder.setSelection(0);
        this.getData(this.meta);
        this.meta.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void selectPrivateKeyStoreFile() {
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (String[])new String[]{"*json", "*"}, (String[])new String[]{"credential JSON file", "All Files"}, (boolean)true);
        if (filename != null) {
            this.wPrivateKeyStore.setText(filename);
            this.meta.setChanged();
        }
    }

    private void testServiceAccount() {
        try {
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            new Drive.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            this.wlTestServiceAccountInfo.setText("Google Drive API : Success!");
        }
        catch (Exception error) {
            this.wlTestServiceAccountInfo.setText("Connection Failed");
        }
    }

    private void selectSpreadSheet() {
        try {
            String s;
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/drive.readonly";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            Drive service = new Drive.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            FileList result = (FileList)service.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ("mimeType='application/vnd.google-apps.spreadsheet'").setPageSize(Integer.valueOf(100)).setFields("nextPageToken, files(id, name)").execute();
            List spreadsheets = result.getFiles();
            int selectedSpreadsheet = -1;
            int i = 0;
            String[] titles = new String[spreadsheets.size()];
            for (File spreadsheet : spreadsheets) {
                titles[i] = spreadsheet.getName() + " - " + spreadsheet.getId() + ")";
                if (spreadsheet.getId().equals(this.wSpreadSheetKey.getText())) {
                    selectedSpreadsheet = i;
                }
                ++i;
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, titles, "Spreadsheets", "Select a Spreadsheet.");
            if (selectedSpreadsheet > -1) {
                esd.setSelectedNrs(new int[]{selectedSpreadsheet});
            }
            if ((s = esd.open()) != null) {
                if (esd.getSelectionIndeces().length > 0) {
                    selectedSpreadsheet = esd.getSelectionIndeces()[0];
                    File spreadsheet = (File)spreadsheets.get(selectedSpreadsheet);
                    this.wSpreadSheetKey.setText(spreadsheet.getId());
                } else {
                    this.wSpreadSheetKey.setText("");
                }
            }
        }
        catch (Exception err) {
            new ErrorDialog(this.shell, "System.Dialog.Error.Title", err.getMessage(), err);
        }
    }

    private void selectWorksheet() {
        try {
            String s;
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            Sheets service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            Spreadsheet response1 = (Spreadsheet)service.spreadsheets().get(this.variables.resolve(this.wSpreadSheetKey.getText())).setIncludeGridData(Boolean.valueOf(false)).execute();
            List worksheets = response1.getSheets();
            String[] names = new String[worksheets.size()];
            int selectedSheet = -1;
            for (int i = 0; i < worksheets.size(); ++i) {
                Sheet sheet = (Sheet)worksheets.get(i);
                names[i] = sheet.getProperties().getTitle();
                if (!sheet.getProperties().getTitle().endsWith("/" + this.wWorksheetId.getText())) continue;
                selectedSheet = i;
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, names, "Worksheets", "Select a Worksheet.");
            if (selectedSheet > -1) {
                esd.setSelectedNrs(new int[]{selectedSheet});
            }
            if ((s = esd.open()) != null) {
                if (esd.getSelectionIndeces().length > 0) {
                    selectedSheet = esd.getSelectionIndeces()[0];
                    Sheet sheet = (Sheet)worksheets.get(selectedSheet);
                    String id = sheet.getProperties().getTitle();
                    this.wWorksheetId.setText(id.substring(id.lastIndexOf("/") + 1));
                } else {
                    this.wWorksheetId.setText("");
                }
            }
        }
        catch (Exception err) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), err.getMessage(), err);
        }
    }

    private void getData(GoogleSheetsInputMeta meta) {
        this.wTransformName.selectAll();
        if (!StringUtils.isEmpty((String)meta.getSpreadsheetKey())) {
            this.wSpreadSheetKey.setText(meta.getSpreadsheetKey());
        }
        if (!StringUtils.isEmpty((String)meta.getWorksheetId())) {
            this.wWorksheetId.setText(meta.getWorksheetId());
        }
        if (!StringUtils.isEmpty((String)meta.getJsonCredentialPath())) {
            this.wPrivateKeyStore.setText(meta.getJsonCredentialPath());
        }
        if (!StringUtils.isEmpty((String)meta.getTimeout())) {
            this.wTimeout.setText(meta.getTimeout());
        }
        if (!StringUtils.isEmpty((String)meta.getImpersonation())) {
            this.wImpersonation.setText(meta.getImpersonation());
        }
        if (!StringUtils.isEmpty((String)meta.getAppName())) {
            this.wAppname.setText(meta.getAppName());
        }
        this.wSampleFields.setText(Integer.toString(meta.getSampleFields()));
        this.wFields.clearAll();
        List<GoogleSheetsInputField> fields = meta.getInputFields();
        for (GoogleSheetsInputField field : fields) {
            TableItem item = new TableItem(this.wFields.table, 0);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String position = "" + field.getPosition();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            if (type != null) {
                item.setText(2, type);
            }
            if (format != null) {
                item.setText(3, format);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(5, prec);
            }
            if (curr != null) {
                item.setText(5, curr);
            }
            if (decim != null) {
                item.setText(7, decim);
            }
            if (group != null) {
                item.setText(8, group);
            }
            if (trim == null) continue;
            item.setText(9, trim);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        meta.setChanged();
    }

    private void setData(GoogleSheetsInputMeta meta) {
        meta.setJsonCredentialPath(this.wPrivateKeyStore.getText());
        meta.setSpreadsheetKey(this.wSpreadSheetKey.getText());
        meta.setWorksheetId(this.wWorksheetId.getText());
        meta.setTimeout(this.wTimeout.getText());
        meta.setAppName(this.wAppname.getText());
        meta.setImpersonation(this.wImpersonation.getText());
        if (this.wSampleFields != null && !this.wSampleFields.getText().isEmpty()) {
            meta.setSampleFields(Integer.parseInt(this.wSampleFields.getText()));
        } else {
            meta.setSampleFields(100);
        }
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        ArrayList<GoogleSheetsInputField> googleSheetsInputFields = new ArrayList<GoogleSheetsInputField>();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            GoogleSheetsInputField field = new GoogleSheetsInputField();
            int colnr = 1;
            field.setName(item.getText(colnr++));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(colnr++)));
            field.setFormat(item.getText(colnr++));
            field.setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setCurrencySymbol(item.getText(colnr++));
            field.setDecimalSymbol(item.getText(colnr++));
            field.setGroupSymbol(item.getText(colnr++));
            field.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(colnr++)));
            googleSheetsInputFields.add(field);
        }
        meta.setInputFields(googleSheetsInputFields);
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        meta.setChanged();
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.setData(this.meta);
        this.dispose();
    }

    private static String getColumnName(int n) {
        StringBuilder res = new StringBuilder();
        if (n == 0) {
            res.append('A');
        } else {
            while (n > 0) {
                int index = (n - 1) % 26;
                res.append((char)(index + 65));
                n = (n - 1) / 26;
            }
        }
        return res.reverse().toString();
    }

    private void getSpreadsheetFields() {
        try {
            GoogleSheetsInputMeta meta = new GoogleSheetsInputMeta();
            this.setData(meta);
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
            this.wFields.table.removeAll();
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(meta.getJsonCredentialPath()), this.variables.resolve(meta.getImpersonation()));
            Sheets service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            String range = this.variables.resolve(meta.getWorksheetId()) + "!1:1";
            ValueRange result = (ValueRange)service.spreadsheets().values().get(this.variables.resolve(meta.getSpreadsheetKey()), range).execute();
            List values = result.getValues();
            if (values != null || !values.isEmpty()) {
                for (List row : values) {
                    for (int j = 0; j < row.size(); ++j) {
                        TableItem item = new TableItem(this.wFields.table, 0);
                        item.setText(1, Const.trim((String)row.get(j).toString()));
                        GoogleSheetsInputField sampleInputFields = new GoogleSheetsInputField();
                        String columnsLetter = GoogleSheetsInputDialog.getColumnName(j + 1);
                        this.logDebug("column:" + Integer.toString(j) + ")" + columnsLetter);
                        Integer nbSampleFields = Integer.parseInt(this.variables.resolve(this.wSampleFields.getText()));
                        String sampleRange = this.variables.resolve(meta.getWorksheetId()) + "!" + columnsLetter + "2:" + columnsLetter + this.variables.resolve(this.wSampleFields.getText());
                        this.logDebug("Guess Fieds : Range : " + sampleRange);
                        ValueRange sampleResult = (ValueRange)service.spreadsheets().values().get(this.variables.resolve(meta.getSpreadsheetKey()), sampleRange).execute();
                        List sampleValues = sampleResult.getValues();
                        if (sampleValues != null) {
                            int m = 0;
                            String[] tmpSampleColumnValues = new String[sampleValues.size()];
                            for (List sampleRow : sampleValues) {
                                if (sampleRow != null && sampleRow.size() > 0 && sampleRow.get(0) != null && !sampleRow.get(0).toString().isEmpty()) {
                                    String tmp = sampleRow.get(0).toString();
                                    this.logDebug(Integer.toString(m) + ")" + tmp.toString());
                                    tmpSampleColumnValues[m] = tmp;
                                    ++m;
                                    continue;
                                }
                                this.logBasic("no sample values");
                            }
                            String[] sampleColumnValues = new String[m];
                            System.arraycopy(tmpSampleColumnValues, 0, sampleColumnValues, 0, m);
                            sampleInputFields.setSamples(sampleColumnValues);
                            sampleInputFields.guess();
                            if (!StringUtils.isEmpty((String)sampleInputFields.getTypeDesc())) {
                                item.setText(2, sampleInputFields.getTypeDesc());
                            }
                            if (!StringUtils.isEmpty((String)sampleInputFields.getFormat())) {
                                item.setText(3, sampleInputFields.getFormat());
                            }
                            if (!StringUtils.isEmpty((String)Integer.toString(sampleInputFields.getPrecision()))) {
                                item.setText(5, Integer.toString(sampleInputFields.getPrecision()));
                            }
                            if (!StringUtils.isEmpty((String)sampleInputFields.getCurrencySymbol())) {
                                item.setText(6, sampleInputFields.getCurrencySymbol());
                            }
                            if (!StringUtils.isEmpty((String)sampleInputFields.getDecimalSymbol())) {
                                item.setText(7, sampleInputFields.getDecimalSymbol());
                            }
                            if (!StringUtils.isEmpty((String)sampleInputFields.getGroupSymbol())) {
                                item.setText(8, sampleInputFields.getGroupSymbol());
                            }
                            if (StringUtils.isEmpty((String)sampleInputFields.getTrimTypeDesc())) continue;
                            item.setText(9, sampleInputFields.getTrimTypeDesc());
                            continue;
                        }
                        item.setText(2, "String");
                    }
                }
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), "Error getting Fields", e);
        }
    }
}

