/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RandomValueDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = RandomValueMeta.class;
    private TextVar wSeed;
    private TableView wFields;
    private final RandomValueMeta input;

    public RandomValueDialog(Shell parent, IVariables variables, RandomValueMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RandomValueDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlSeed = new Label((Composite)this.shell, 131072);
        wlSeed.setText(BaseMessages.getString(PKG, (String)"RandomValueDialog.Seed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSeed);
        FormData fdlSeed = new FormData();
        fdlSeed.left = new FormAttachment(0, 0);
        fdlSeed.right = new FormAttachment(middle, -margin);
        fdlSeed.top = new FormAttachment((Control)lastControl, margin);
        wlSeed.setLayoutData((Object)fdlSeed);
        this.wSeed = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSeed.setText(this.transformName);
        PropsUi.setLook((Widget)this.wSeed);
        FormData fdSeed = new FormData();
        fdSeed.left = new FormAttachment(middle, 0);
        fdSeed.top = new FormAttachment((Control)wlSeed, 0, 0x1000000);
        fdSeed.right = new FormAttachment(100, 0);
        this.wSeed.setLayoutData((Object)fdSeed);
        lastControl = this.wSeed;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"RandomValueDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.input.getFields().size();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RandomValueDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RandomValueDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        columns[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RandomValueDialog.this.enterTypeSelection(e);
            }
        });
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, columns, nrRows, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void enterTypeSelection(SelectionEvent e) {
        EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, RandomValueMeta.RandomType.getDescriptions(), BaseMessages.getString(PKG, (String)"RandomValueDialog.SelectInfoType.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RandomValueDialog.SelectInfoType.DialogMessage", (String[])new String[0]));
        String string = esd.open();
        if (string != null) {
            TableView tv = (TableView)e.widget;
            tv.setText(string, e.x, e.y);
            this.input.setChanged();
        }
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wSeed.setText(Const.NVL((String)this.input.getSeed(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            RandomValueMeta.RVField field = this.input.getFields().get(i);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            if (field.getType() == null) continue;
            item.setText(2, field.getType().getDescription());
        }
        this.wFields.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setSeed(this.wSeed.getText());
        this.input.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            RandomValueMeta.RVField field = new RandomValueMeta.RVField();
            this.input.getFields().add(field);
            field.setName(item.getText(1));
            field.setType(RandomValueMeta.RandomType.lookupDescription(item.getText(2)));
        }
        this.input.setChanged();
        this.dispose();
    }
}

