/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableoutput;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutput;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputData;
import org.apache.hop.pipeline.transforms.tableoutput.TableOutputField;

@Transform(id="TableOutput", image="tableoutput.svg", name="i18n::TableOutput.Name", description="i18n::TableOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::TableOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/tableoutput.html", actionTransformTypes={ActionTransformType.OUTPUT, ActionTransformType.RDBMS})
public class TableOutputMeta
extends BaseTransformMeta<TableOutput, TableOutputData> {
    private static final Class<?> PKG = TableOutputMeta.class;
    private static final String PARTITION_PER_DAY = "DAY";
    private static final String PARTITION_PER_MONTH = "MONTH";
    @HopMetadataProperty(key="connection", injectionKeyDescription="TableOutputMeta.Injection.Connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="schema", injectionKey="TARGET_SCHEMA", injectionKeyDescription="TableOutputMeta.Injection.SchemaName.Field", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TARGET_TABLE", injectionKeyDescription="TableOutputMeta.Injection.TableName.Field", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String tableName;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="TableOutputMeta.Injection.CommitSize.Field")
    private String commitSize = "1000";
    @HopMetadataProperty(key="truncate", injectionKey="TRUNCATE_TABLE", injectionKeyDescription="TableOutputMeta.Injection.TruncateTable.Field", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TRUNCATE)
    private boolean truncateTable;
    @HopMetadataProperty(key="only_when_have_rows", injectionKey="ONLY_WHEN_HAVE_ROWS", injectionKeyDescription="TableOutputMeta.Inject.OnlyWhenHaveRows.Field")
    private boolean onlyWhenHaveRows;
    @HopMetadataProperty(key="ignore_errors", injectionKey="IGNORE_INSERT_ERRORS", injectionKeyDescription="TableOutputMeta.Injection.IgnoreErrors.Field")
    private boolean ignoreErrors;
    @HopMetadataProperty(key="use_batch", injectionKey="USE_BATCH_UPDATE", defaultBoolean=true, injectionKeyDescription="TableOutputMeta.Injection.UseBatch.Field")
    private boolean useBatchUpdate = true;
    @HopMetadataProperty(key="partitioning_enabled", injectionKey="PARTITION_OVER_TABLES", injectionKeyDescription="TableOutputMeta.Injection.PartitioningEnabled.Field")
    private boolean partitioningEnabled;
    @HopMetadataProperty(key="partitioning_field", injectionKey="PARTITIONING_FIELD", injectionKeyDescription="TableOutputMeta.Injection.PartitioningField.Field")
    private String partitioningField;
    @HopMetadataProperty(key="partitioning_daily", isExcludedFromInjection=true)
    private boolean partitioningDaily;
    @HopMetadataProperty(key="partitioning_monthly", isExcludedFromInjection=true)
    private boolean partitioningMonthly;
    @HopMetadataProperty(injectionKey="PARTITION_DATA_PER", injectionKeyDescription="TableOutputMeta.Injection.PartitionDataPer.Field")
    private transient String partitionDataPer;
    @HopMetadataProperty(key="tablename_in_field", injectionKey="TABLE_NAME_DEFINED_IN_FIELD", injectionKeyDescription="TableOutputMeta.Injection.TableNameInField.Field")
    private boolean tableNameInField;
    @HopMetadataProperty(key="tablename_field", injectionKey="TABLE_NAME_FIELD", injectionKeyDescription="TableOutputMeta.Injection.TableNameField.Field")
    private String tableNameField;
    @HopMetadataProperty(key="tablename_in_table", injectionKey="STORE_TABLE_NAME", injectionKeyDescription="TableOutputMeta.Injection.TableNameInTable.Field")
    private boolean tableNameInTable;
    @HopMetadataProperty(key="return_keys", injectionKeyDescription="TableOutputMeta.Injection.ReturningGeneratedKeys.Field")
    private boolean returningGeneratedKeys;
    @HopMetadataProperty(key="return_field", injectionKey="RETURN_AUTO_GENERATED_KEY", injectionKeyDescription="TableOutputMeta.Injection.GeneratedKeys.Field")
    private String generatedKeyField;
    @HopMetadataProperty(key="specify_fields", injectionKey="AUTO_GENERATED_KEY_FIELD", injectionKeyDescription="TableOutputMeta.Injection.SpecifyFields.Field")
    private boolean specifyFields;
    @HopMetadataProperty(key="auto_update_table_structure", injectionKey="AUTO_UPDATE_TABLE_STRUCTURE", injectionKeyDescription="TableOutputMeta.Injection.AutoUpdateTableStructure.Field")
    private boolean autoUpdateTableStructure;
    @HopMetadataProperty(key="always_drop_and_recreate", injectionKey="ALWAYS_DROP_AND_RECREATE", injectionKeyDescription="TableOutputMeta.Injection.AlwaysDropAndRecreate.Field")
    private boolean alwaysDropAndRecreate;
    @HopMetadataProperty(key="add_columns", injectionKey="ADD_COLUMNS", injectionKeyDescription="TableOutputMeta.Injection.AddColumns.Field")
    private boolean addColumns;
    @HopMetadataProperty(key="drop_columns", injectionKey="DROP_COLUMNS", injectionKeyDescription="TableOutputMeta.Injection.DropColumns.Field")
    private boolean dropColumns;
    @HopMetadataProperty(key="change_column_types", injectionKey="CHANGE_COLUMN_TYPES", injectionKeyDescription="TableOutputMeta.Injection.ChangeColumnTypes.Field")
    private boolean changeColumnTypes;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="DATABASE_FIELD", injectionGroupKey="DATABASE_FIELDS", injectionGroupDescription="TableOutputMeta.Injection.Fields", injectionKeyDescription="TableOutputMeta.Injection.Field", hopMetadataPropertyType=HopMetadataPropertyType.FIELD_LIST)
    private List<TableOutputField> fields = new ArrayList<TableOutputField>();

    public void setPartitionDataPer(String partitionDataPer) {
        this.partitionDataPer = partitionDataPer;
        this.partitioningDaily = partitionDataPer.equals(PARTITION_PER_DAY);
        this.partitioningMonthly = partitionDataPer.equals(PARTITION_PER_MONTH);
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.tableName = "";
        this.commitSize = "1000";
        this.partitioningEnabled = false;
        this.partitioningDaily = false;
        this.partitioningMonthly = true;
        this.partitioningField = "";
        this.tableNameInTable = true;
        this.tableNameField = "";
        this.specifyFields = false;
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.returningGeneratedKeys && !Utils.isEmpty((CharSequence)this.generatedKeyField)) {
            ValueMetaInteger key = new ValueMetaInteger(variables.resolve(this.generatedKeyField));
            key.setOrigin(origin);
            row.addValueMeta((IValueMeta)key);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        block35: {
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                if (databaseMeta != null) {
                    CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    try (Database db = new Database(loggingObject, variables, databaseMeta);){
                        db.connect();
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (!Utils.isEmpty((CharSequence)this.tableName)) {
                            String realSchemaName = db.resolve(this.schemaName);
                            String realTableName = db.resolve(this.tableName);
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
                            if (db.checkTableExists(realSchemaName, realTableName)) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                IRowMeta r = db.getTableFieldsMeta(realSchemaName, realTableName);
                                if (r != null) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                    StringBuilder errorMessage = new StringBuilder();
                                    boolean errorFound = false;
                                    if (prev != null && !prev.isEmpty()) {
                                        int idx;
                                        int i;
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                        if (!this.isSpecifyFields()) {
                                            for (i = 0; i < prev.size(); ++i) {
                                                IValueMeta pv = prev.getValueMeta(i);
                                                idx = r.indexOfValue(pv.getName());
                                                if (idx >= 0) continue;
                                                errorMessage.append("\t\t").append(pv.getName()).append(" (").append(pv.getTypeDesc()).append(")").append(Const.CR);
                                                errorFound = true;
                                            }
                                            if (errorFound) {
                                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFoundInOutput", (Object[])new Object[]{errorMessage}), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (TableOutputField tf : this.fields) {
                                                idx = r.indexOfValue(tf.getFieldDatabase());
                                                if (idx >= 0) continue;
                                                errorMessage.append("\t\t").append(tf.getFieldDatabase()).append(Const.CR);
                                                errorFound = true;
                                            }
                                            if (errorFound) {
                                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotInTable", (Object[])new Object[]{errorMessage}), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                        errorMessage.setLength(0);
                                        if (!this.isSpecifyFields()) {
                                            for (i = 0; i < this.fields.size(); ++i) {
                                                IValueMeta rv = r.getValueMeta(i);
                                                idx = prev.indexOfValue(rv.getName());
                                                if (idx >= 0) continue;
                                                errorMessage.append("\t\t").append(rv.getName()).append(" (").append(rv.getTypeDesc()).append(")").append(Const.CR);
                                                errorFound = true;
                                            }
                                            if (errorFound) {
                                                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFound", (Object[])new Object[]{errorMessage}), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        } else {
                                            for (TableOutputField tf : this.fields) {
                                                idx = prev.indexOfValue(tf.getFieldStream());
                                                if (idx >= 0) continue;
                                                errorMessage.append("\t\t").append(tf.getFieldStream()).append(Const.CR);
                                                errorFound = true;
                                            }
                                            if (errorFound) {
                                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotFound", (Object[])new Object[]{errorMessage}), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            } else {
                                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                                remarks.add((ICheckResult)cr);
                                            }
                                        }
                                    } else {
                                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        break block35;
                    }
                }
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopDatabaseException e) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.ErrorConnecting", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (this.truncateTable) {
                DatabaseImpact ii = new DatabaseImpact(4, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, "", "", "", "", "Truncate of table");
                impact.add(ii);
            }
            if (prev != null) {
                for (int i = 0; i < prev.size(); ++i) {
                    IValueMeta v = prev.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        return this.getSqlStatements(variables, pipelineMeta, transformMeta, prev, null, false, null);
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String tk, boolean useAutoIncrement, String pk) {
        DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
        SqlStatement retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
        if (databaseMeta != null) {
            if (prev != null && !prev.isEmpty()) {
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    try (Database db = new Database(loggingObject, variables, databaseMeta);){
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                        String crTable = db.getDDL(schemaTable, prev, tk, useAutoIncrement, pk);
                        if (Utils.isEmpty((CharSequence)crTable)) {
                            crTable = null;
                        }
                        retval.setSql(crTable);
                    }
                    catch (HopDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        return this.getTableFields(databaseMeta, realTableName, realSchemaName, variables);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRowMeta getTableFields(DatabaseMeta databaseMeta, String tableName, String schemaName, IVariables variables) throws HopException {
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        try (Database db = new Database(loggingObject, variables, databaseMeta);){
            db.connect();
            if (Utils.isEmpty((CharSequence)tableName)) throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (!db.checkTableExists(schemaName, tableName)) throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotFound", (String[])new String[0]));
            IRowMeta iRowMeta = db.getTableFieldsMeta(schemaName, tableName);
            return iRowMeta;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public DatabaseMeta getDatabaseMeta() {
        return null;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getCommitSize() {
        return this.commitSize;
    }

    @Generated
    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    @Generated
    public boolean isOnlyWhenHaveRows() {
        return this.onlyWhenHaveRows;
    }

    @Generated
    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @Generated
    public boolean isUseBatchUpdate() {
        return this.useBatchUpdate;
    }

    @Generated
    public boolean isPartitioningEnabled() {
        return this.partitioningEnabled;
    }

    @Generated
    public String getPartitioningField() {
        return this.partitioningField;
    }

    @Generated
    public boolean isPartitioningDaily() {
        return this.partitioningDaily;
    }

    @Generated
    public boolean isPartitioningMonthly() {
        return this.partitioningMonthly;
    }

    @Generated
    public String getPartitionDataPer() {
        return this.partitionDataPer;
    }

    @Generated
    public boolean isTableNameInField() {
        return this.tableNameInField;
    }

    @Generated
    public String getTableNameField() {
        return this.tableNameField;
    }

    @Generated
    public boolean isTableNameInTable() {
        return this.tableNameInTable;
    }

    @Generated
    public boolean isReturningGeneratedKeys() {
        return this.returningGeneratedKeys;
    }

    @Generated
    public String getGeneratedKeyField() {
        return this.generatedKeyField;
    }

    @Generated
    public boolean isSpecifyFields() {
        return this.specifyFields;
    }

    @Generated
    public boolean isAutoUpdateTableStructure() {
        return this.autoUpdateTableStructure;
    }

    @Generated
    public boolean isAlwaysDropAndRecreate() {
        return this.alwaysDropAndRecreate;
    }

    @Generated
    public boolean isAddColumns() {
        return this.addColumns;
    }

    @Generated
    public boolean isDropColumns() {
        return this.dropColumns;
    }

    @Generated
    public boolean isChangeColumnTypes() {
        return this.changeColumnTypes;
    }

    @Generated
    public List<TableOutputField> getFields() {
        return this.fields;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    @Generated
    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    @Generated
    public void setOnlyWhenHaveRows(boolean onlyWhenHaveRows) {
        this.onlyWhenHaveRows = onlyWhenHaveRows;
    }

    @Generated
    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @Generated
    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    @Generated
    public void setPartitioningEnabled(boolean partitioningEnabled) {
        this.partitioningEnabled = partitioningEnabled;
    }

    @Generated
    public void setPartitioningField(String partitioningField) {
        this.partitioningField = partitioningField;
    }

    @Generated
    public void setPartitioningDaily(boolean partitioningDaily) {
        this.partitioningDaily = partitioningDaily;
    }

    @Generated
    public void setPartitioningMonthly(boolean partitioningMonthly) {
        this.partitioningMonthly = partitioningMonthly;
    }

    @Generated
    public void setTableNameInField(boolean tableNameInField) {
        this.tableNameInField = tableNameInField;
    }

    @Generated
    public void setTableNameField(String tableNameField) {
        this.tableNameField = tableNameField;
    }

    @Generated
    public void setTableNameInTable(boolean tableNameInTable) {
        this.tableNameInTable = tableNameInTable;
    }

    @Generated
    public void setReturningGeneratedKeys(boolean returningGeneratedKeys) {
        this.returningGeneratedKeys = returningGeneratedKeys;
    }

    @Generated
    public void setGeneratedKeyField(String generatedKeyField) {
        this.generatedKeyField = generatedKeyField;
    }

    @Generated
    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    @Generated
    public void setAutoUpdateTableStructure(boolean autoUpdateTableStructure) {
        this.autoUpdateTableStructure = autoUpdateTableStructure;
    }

    @Generated
    public void setAlwaysDropAndRecreate(boolean alwaysDropAndRecreate) {
        this.alwaysDropAndRecreate = alwaysDropAndRecreate;
    }

    @Generated
    public void setAddColumns(boolean addColumns) {
        this.addColumns = addColumns;
    }

    @Generated
    public void setDropColumns(boolean dropColumns) {
        this.dropColumns = dropColumns;
    }

    @Generated
    public void setChangeColumnTypes(boolean changeColumnTypes) {
        this.changeColumnTypes = changeColumnTypes;
    }

    @Generated
    public void setFields(List<TableOutputField> fields) {
        this.fields = fields;
    }
}

