/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergejoin;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.mergejoin.MergeJoinMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MergeJoinDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MergeJoinMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "MergeJoinSortWarning";
    private Combo wTransform1;
    private Combo wTransform2;
    private Combo wType;
    private TableView wKeys1;
    private TableView wKeys2;
    private final MergeJoinMeta input;

    public MergeJoinDialog(Shell parent, IVariables variables, MergeJoinMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        String[] previousTransforms = this.pipelineMeta.getPrevTransformNames(this.transformName);
        Label wlTransform1 = new Label((Composite)this.shell, 131072);
        wlTransform1.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Transform1.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransform1);
        FormData fdlTransform1 = new FormData();
        fdlTransform1.left = new FormAttachment(0, 0);
        fdlTransform1.right = new FormAttachment(middle, -margin);
        fdlTransform1.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTransform1.setLayoutData((Object)fdlTransform1);
        this.wTransform1 = new Combo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTransform1);
        if (previousTransforms != null) {
            this.wTransform1.setItems(previousTransforms);
        }
        this.wTransform1.addModifyListener(lsMod);
        FormData fdTransform1 = new FormData();
        fdTransform1.left = new FormAttachment(middle, 0);
        fdTransform1.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTransform1.right = new FormAttachment(100, 0);
        this.wTransform1.setLayoutData((Object)fdTransform1);
        Label wlTransform2 = new Label((Composite)this.shell, 131072);
        wlTransform2.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Transform2.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransform2);
        FormData fdlTransform2 = new FormData();
        fdlTransform2.left = new FormAttachment(0, 0);
        fdlTransform2.right = new FormAttachment(middle, -margin);
        fdlTransform2.top = new FormAttachment((Control)this.wTransform1, margin);
        wlTransform2.setLayoutData((Object)fdlTransform2);
        this.wTransform2 = new Combo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTransform2);
        if (previousTransforms != null) {
            this.wTransform2.setItems(previousTransforms);
        }
        this.wTransform2.addModifyListener(lsMod);
        FormData fdTransform2 = new FormData();
        fdTransform2.top = new FormAttachment((Control)this.wTransform1, margin);
        fdTransform2.left = new FormAttachment(middle, 0);
        fdTransform2.right = new FormAttachment(100, 0);
        this.wTransform2.setLayoutData((Object)fdTransform2);
        Label wlType = new Label((Composite)this.shell, 131072);
        wlType.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Type.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlType);
        FormData fdlType = new FormData();
        fdlType.left = new FormAttachment(0, 0);
        fdlType.right = new FormAttachment(middle, -margin);
        fdlType.top = new FormAttachment((Control)this.wTransform2, margin);
        wlType.setLayoutData((Object)fdlType);
        this.wType = new Combo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wType);
        this.wType.setItems(MergeJoinMeta.joinTypes);
        this.wType.addModifyListener(lsMod);
        FormData fdType = new FormData();
        fdType.top = new FormAttachment((Control)this.wTransform2, margin);
        fdType.left = new FormAttachment(middle, 0);
        fdType.right = new FormAttachment(100, 0);
        this.wType.setLayoutData((Object)fdType);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Button wbKeys1 = new Button((Composite)this.shell, 8);
        wbKeys1.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.KeyFields1.Button", (String[])new String[0]));
        FormData fdbKeys1 = new FormData();
        fdbKeys1.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdbKeys1.left = new FormAttachment(0, 0);
        fdbKeys1.right = new FormAttachment(50, -margin);
        wbKeys1.setLayoutData((Object)fdbKeys1);
        wbKeys1.addListener(13, e -> this.getKeys1());
        Button wbKeys2 = new Button((Composite)this.shell, 8);
        wbKeys2.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.KeyFields2.Button", (String[])new String[0]));
        FormData fdbKeys2 = new FormData();
        fdbKeys2.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdbKeys2.left = new FormAttachment(50, 0);
        fdbKeys2.right = new FormAttachment(100, 0);
        wbKeys2.setLayoutData((Object)fdbKeys2);
        wbKeys2.addListener(13, e -> this.getKeys2());
        Label wlKeys1 = new Label((Composite)this.shell, 0);
        wlKeys1.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Keys1.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeys1);
        FormData fdlKeys1 = new FormData();
        fdlKeys1.left = new FormAttachment(0, 0);
        fdlKeys1.top = new FormAttachment((Control)this.wType, margin);
        wlKeys1.setLayoutData((Object)fdlKeys1);
        int nrKeyRows1 = this.input.getKeyFields1().size();
        ColumnInfo[] ciKeys1 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MergeJoinDialog.ColumnInfo.KeyField1", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wKeys1 = new TableView(this.variables, (Composite)this.shell, 68354, ciKeys1, nrKeyRows1, lsMod, this.props);
        FormData fdKeys1 = new FormData();
        fdKeys1.top = new FormAttachment((Control)wlKeys1, margin);
        fdKeys1.left = new FormAttachment(0, 0);
        fdKeys1.bottom = new FormAttachment((Control)wbKeys1, -2 * margin);
        fdKeys1.right = new FormAttachment(50, -margin);
        this.wKeys1.setLayoutData((Object)fdKeys1);
        Label wlKeys2 = new Label((Composite)this.shell, 0);
        wlKeys2.setText(BaseMessages.getString(PKG, (String)"MergeJoinDialog.Keys2.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeys2);
        FormData fdlKeys2 = new FormData();
        fdlKeys2.left = new FormAttachment(50, 0);
        fdlKeys2.top = new FormAttachment((Control)this.wType, margin);
        wlKeys2.setLayoutData((Object)fdlKeys2);
        int nrKeyRows2 = this.input.getKeyFields2().size();
        ColumnInfo[] ciKeys2 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MergeJoinDialog.ColumnInfo.KeyField2", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wKeys2 = new TableView(this.variables, (Composite)this.shell, 68354, ciKeys2, nrKeyRows2, lsMod, this.props);
        FormData fdKeys2 = new FormData();
        fdKeys2.top = new FormAttachment((Control)wlKeys2, margin);
        fdKeys2.left = new FormAttachment(50, 0);
        fdKeys2.bottom = new FormAttachment((Control)wbKeys2, -2 * margin);
        fdKeys2.right = new FormAttachment(100, 0);
        this.wKeys2.setLayoutData((Object)fdKeys2);
        this.wTransform1.addListener(24, e -> this.updateFieldNames(ciKeys1[0], ciKeys2[0]));
        this.wTransform2.addListener(24, e -> this.updateFieldNames(ciKeys1[0], ciKeys2[0]));
        this.getData();
        this.updateFieldNames(ciKeys1[0], ciKeys2[0]);
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        TableItem item;
        int i;
        List infoStreams = this.input.getTransformIOMeta().getInfoStreams();
        this.wTransform1.setText(Const.NVL((String)((IStream)infoStreams.get(0)).getTransformName(), (String)""));
        this.wTransform2.setText(Const.NVL((String)((IStream)infoStreams.get(1)).getTransformName(), (String)""));
        String joinType = this.input.getJoinType();
        if (!Utils.isEmpty((CharSequence)joinType)) {
            this.wType.setText(joinType);
        } else {
            this.wType.setText(MergeJoinMeta.joinTypes[0]);
        }
        for (i = 0; i < this.input.getKeyFields1().size(); ++i) {
            item = this.wKeys1.table.getItem(i);
            item.setText(1, Const.NVL((String)this.input.getKeyFields1().get(i), (String)""));
        }
        for (i = 0; i < this.input.getKeyFields2().size(); ++i) {
            item = this.wKeys2.table.getItem(i);
            item.setText(1, Const.NVL((String)this.input.getKeyFields2().get(i), (String)""));
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getMeta(MergeJoinMeta meta) {
        meta.setLeftTransformName(this.wTransform1.getText());
        meta.setRightTransformName(this.wTransform2.getText());
        meta.setJoinType(this.wType.getText());
        meta.getKeyFields1().clear();
        for (TableItem item : this.wKeys1.getNonEmptyItems()) {
            meta.getKeyFields1().add(item.getText(1));
        }
        meta.getKeyFields2().clear();
        for (TableItem item : this.wKeys2.getNonEmptyItems()) {
            meta.getKeyFields2().add(item.getText(1));
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getMeta(this.input);
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"MergeJoinDialog.InputNeedSort.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeJoinDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"MergeJoinDialog.InputNeedSort.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"MergeJoinDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void getKeys1() {
        MergeJoinMeta joinMeta = new MergeJoinMeta();
        this.getMeta(joinMeta);
        try {
            IRowMeta prev;
            TransformMeta transformMeta = this.pipelineMeta.findTransform(joinMeta.getLeftTransformName());
            if (transformMeta != null && (prev = this.pipelineMeta.getTransformFields(this.variables, transformMeta)) != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)prev, (TableView)this.wKeys1, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MergeJoinDialog.ErrorGettingFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeJoinDialog.ErrorGettingFields.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getKeys2() {
        MergeJoinMeta joinMeta = new MergeJoinMeta();
        this.getMeta(joinMeta);
        try {
            IRowMeta prev;
            TransformMeta transformMeta = this.pipelineMeta.findTransform(joinMeta.getRightTransformName());
            if (transformMeta != null && (prev = this.pipelineMeta.getTransformFields(this.variables, transformMeta)) != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)prev, (TableView)this.wKeys2, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MergeJoinDialog.ErrorGettingFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeJoinDialog.ErrorGettingFields.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void updateFieldNames(ColumnInfo leftColumn, ColumnInfo rightColumn) {
        Runnable runnable = () -> {
            String[] fieldNames;
            IRowMeta row;
            leftColumn.setComboValues(new String[]{""});
            rightColumn.setComboValues(new String[]{""});
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.wTransform1.getText());
            if (transformMeta != null) {
                try {
                    row = this.pipelineMeta.getTransformFields(this.variables, transformMeta);
                    fieldNames = ConstUi.sortFieldNames((String[])row.getFieldNames());
                    leftColumn.setComboValues(fieldNames);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
            if ((transformMeta = this.pipelineMeta.findTransform(this.wTransform2.getText())) != null) {
                try {
                    row = this.pipelineMeta.getTransformFields(this.variables, transformMeta);
                    fieldNames = ConstUi.sortFieldNames((String[])row.getFieldNames());
                    rightColumn.setComboValues(ConstUi.sortFieldNames((String[])fieldNames));
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        this.shell.getDisplay().asyncExec(runnable);
    }
}

