/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefolders;

import java.util.ArrayList;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.deletefolders.ActionDeleteFolders;
import org.apache.hop.workflow.actions.deletefolders.FileItem;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionDeleteFoldersDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionDeleteFolders.class;
    private Text wName;
    private ActionDeleteFolders action;
    private boolean changed;
    private Button wPrevious;
    private Label wlFields;
    private TableView wFields;
    private CCombo wSuccessCondition;
    private Label wlNrErrorsLessThan;
    private TextVar wLimitFolders;

    public ActionDeleteFoldersDialog(Shell parent, ActionDeleteFolders action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Settings.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)groupLayout);
        Label wlPrevious = new Label((Composite)wSettings, 131072);
        wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Previous.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment((Control)this.wName, margin);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wPrevious);
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Previous.Tooltip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addListener(13, e -> {
            this.setPrevious();
            this.action.setChanged();
        });
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        Group wSuccessOn = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSuccessOn);
        wSuccessOn.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.SuccessOn.Group.Label", (String[])new String[0]));
        FormLayout successongroupLayout = new FormLayout();
        successongroupLayout.marginWidth = 10;
        successongroupLayout.marginHeight = 10;
        wSuccessOn.setLayout((Layout)successongroupLayout);
        Label wlSuccessCondition = new Label((Composite)wSuccessOn, 131072);
        wlSuccessCondition.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.SuccessCondition.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSuccessCondition);
        FormData fdlSuccessCondition = new FormData();
        fdlSuccessCondition.left = new FormAttachment(0, 0);
        fdlSuccessCondition.right = new FormAttachment(middle, -margin);
        fdlSuccessCondition.top = new FormAttachment((Control)wSettings, margin);
        wlSuccessCondition.setLayoutData((Object)fdlSuccessCondition);
        this.wSuccessCondition = new CCombo((Composite)wSuccessOn, 2060);
        this.wSuccessCondition.setItems(ActionDeleteFolders.SuccessCondition.getDescriptions());
        this.wSuccessCondition.select(0);
        PropsUi.setLook((Widget)this.wSuccessCondition);
        FormData fdSuccessCondition = new FormData();
        fdSuccessCondition.left = new FormAttachment(middle, 0);
        fdSuccessCondition.top = new FormAttachment((Control)wSettings, margin);
        fdSuccessCondition.right = new FormAttachment(100, 0);
        this.wSuccessCondition.setLayoutData((Object)fdSuccessCondition);
        this.wSuccessCondition.addListener(13, e -> this.activeSuccessCondition());
        this.wlNrErrorsLessThan = new Label((Composite)wSuccessOn, 131072);
        this.wlNrErrorsLessThan.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.LimitFolders.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrErrorsLessThan);
        FormData fdlNrErrorsLessThan = new FormData();
        fdlNrErrorsLessThan.left = new FormAttachment(0, 0);
        fdlNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdlNrErrorsLessThan.right = new FormAttachment(middle, -margin);
        this.wlNrErrorsLessThan.setLayoutData((Object)fdlNrErrorsLessThan);
        this.wLimitFolders = new TextVar(this.variables, (Composite)wSuccessOn, 18436, BaseMessages.getString(PKG, (String)"ActionDeleteFolders.LimitFolders.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLimitFolders);
        this.wLimitFolders.addModifyListener(lsMod);
        FormData fdNrErrorsLessThan = new FormData();
        fdNrErrorsLessThan.left = new FormAttachment(middle, 0);
        fdNrErrorsLessThan.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdNrErrorsLessThan.right = new FormAttachment(100, -margin);
        this.wLimitFolders.setLayoutData((Object)fdNrErrorsLessThan);
        FormData fdSuccessOn = new FormData();
        fdSuccessOn.left = new FormAttachment(0, margin);
        fdSuccessOn.top = new FormAttachment((Control)wSettings, margin);
        fdSuccessOn.right = new FormAttachment(100, -margin);
        wSuccessOn.setLayoutData((Object)fdSuccessOn);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)wSuccessOn, margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.action.getFileItems().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Fields.Argument.Label", (String[])new String[0]), 6, false)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionDeleteFolders.Fields.Column", (String[])new String[0]));
        colinf[0].setTextVarButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String fileName = ActionDeleteFoldersDialog.this.wFields.getActiveTableItem().getText(ActionDeleteFoldersDialog.this.wFields.getActiveTableColumn());
                fileName = BaseDialog.presentDirectoryDialog((Shell)ActionDeleteFoldersDialog.this.shell, (String)fileName, (String)"Message", (IVariables)ActionDeleteFoldersDialog.this.variables);
                if (fileName != null) {
                    ActionDeleteFoldersDialog.this.wFields.getActiveTableItem().setText(ActionDeleteFoldersDialog.this.wFields.getActiveTableColumn(), fileName);
                }
            }
        });
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, nrRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{8, 92}));
        this.wlFields.setEnabled(!this.action.isArgFromPrevious());
        this.wFields.setEnabled(!this.action.isArgFromPrevious());
        this.getData();
        this.setPrevious();
        this.activeSuccessCondition();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void activeSuccessCondition() {
        this.wlNrErrorsLessThan.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
        this.wLimitFolders.setEnabled(this.wSuccessCondition.getSelectionIndex() != 0);
    }

    private void setPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getFileItems() != null) {
            int i = 0;
            for (FileItem item : this.action.getFileItems()) {
                TableItem ti = this.wFields.table.getItem(i++);
                if (item.getFileName() == null) continue;
                ti.setText(1, item.getFileName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        if (this.action.getLimitFolders() != null) {
            this.wLimitFolders.setText(this.action.getLimitFolders());
        } else {
            this.wLimitFolders.setText("10");
        }
        if (this.action.getSuccessCondition() != null) {
            this.wSuccessCondition.select(this.action.getSuccessCondition().getIndex());
        } else {
            this.wSuccessCondition.select(0);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setArgFromPrevious(this.wPrevious.getSelection());
        this.action.setLimitFolders(this.wLimitFolders.getText());
        if (this.wSuccessCondition.getSelectionIndex() != -1) {
            this.action.setSuccessCondition(ActionDeleteFolders.SuccessCondition.values()[this.wSuccessCondition.getSelectionIndex()]);
        }
        int nrItems = this.wFields.nrNonEmpty();
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        for (int i = 0; i < nrItems; ++i) {
            String path = this.wFields.getNonEmpty(i).getText(1);
            if (Utils.isEmpty((CharSequence)path)) continue;
            items.add(new FileItem(path));
        }
        this.action.setFileItems(items);
        this.dispose();
    }
}

