/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.protocol;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.org.apache.hc.core5.http.EntityDetails;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpException;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpResponse;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpResponseInterceptor;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ProtocolException;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConformance
implements HttpResponseInterceptor {
    public static final ResponseConformance INSTANCE = new ResponseConformance();

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getCode();
        switch (status) {
            case 204: 
            case 304: {
                if (entity == null) break;
                throw new ProtocolException("Response " + status + " must not enclose an entity");
            }
        }
    }
}

