/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.internal.ClickHouseLZ4InputStream;
import com.clickhouse.client.api.internal.ClickHouseLZ4OutputStream;
import com.clickhouse.client.internal.net.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import com.clickhouse.client.internal.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import com.clickhouse.client.internal.org.apache.hc.core5.function.Supplier;
import com.clickhouse.client.internal.org.apache.hc.core5.http.Header;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

class LZ4Entity
implements HttpEntity {
    private HttpEntity httpEntity;
    private final boolean useHttpCompression;
    private final int bufferSize;
    private final boolean isResponse;
    private boolean serverCompression;
    private boolean clientCompression;
    private LZ4Factory lz4Factory = null;

    LZ4Entity(HttpEntity httpEntity, boolean useHttpCompression, boolean serverCompression, boolean clientCompression, int bufferSize, boolean isResponse, LZ4Factory lz4Factory) {
        this.httpEntity = httpEntity;
        this.useHttpCompression = useHttpCompression;
        this.bufferSize = bufferSize;
        this.serverCompression = serverCompression;
        this.clientCompression = clientCompression;
        this.isResponse = isResponse;
        this.lz4Factory = lz4Factory;
    }

    @Override
    public boolean isRepeatable() {
        return this.httpEntity.isRepeatable();
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        if (!this.isResponse && this.serverCompression) {
            throw new UnsupportedOperationException("Unsupported: getting compressed content of request");
        }
        if (this.serverCompression) {
            if (this.useHttpCompression) {
                InputStream content = this.httpEntity.getContent();
                try {
                    return new FramedLZ4CompressorInputStream(content);
                }
                catch (IOException e) {
                    return content;
                }
            }
            return new ClickHouseLZ4InputStream(this.httpEntity.getContent(), this.lz4Factory.fastDecompressor(), this.bufferSize);
        }
        return this.httpEntity.getContent();
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        if (this.isResponse && this.serverCompression) {
            throw new UnsupportedOperationException("Unsupported: writing compressed response to elsewhere");
        }
        if (this.clientCompression) {
            if (this.useHttpCompression) {
                this.httpEntity.writeTo(new FramedLZ4CompressorOutputStream(outStream));
            } else {
                this.httpEntity.writeTo(new ClickHouseLZ4OutputStream(outStream, this.lz4Factory.fastCompressor(), this.bufferSize));
            }
        } else {
            this.httpEntity.writeTo(outStream);
        }
    }

    @Override
    public boolean isStreaming() {
        return this.httpEntity.isStreaming();
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return this.httpEntity.getTrailers();
    }

    @Override
    public void close() throws IOException {
        this.httpEntity.close();
    }

    @Override
    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.httpEntity.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.httpEntity.getContentEncoding();
    }

    @Override
    public boolean isChunked() {
        return this.httpEntity.isChunked();
    }

    @Override
    public Set<String> getTrailerNames() {
        return this.httpEntity.getTrailerNames();
    }
}

