/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio.metadata;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.minio.metadata.MinioMeta;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="This is the editor for Minio connection metadata")
public class MinioMetaEditor
extends MetadataEditor<MinioMeta> {
    private static final Class<?> PKG = MinioMetaEditor.class;
    public static final String GUI_WIDGETS_PARENT_ID = "MinioMetaEditor-GuiWidgetsParent";
    private Text wName;
    private Composite wWidgetsComposite;
    private GuiCompositeWidgets guiCompositeWidgets;

    public MinioMetaEditor(HopGui hopGui, MetadataManager<MinioMeta> manager, MinioMeta metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin() + 2;
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"MinioMeta.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment((Control)wIcon, -margin);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        this.wWidgetsComposite = new Composite(parent, 0);
        PropsUi.setLook((Widget)this.wWidgetsComposite);
        this.wWidgetsComposite.setLayout((Layout)new FormLayout());
        FormData fdWidgetsComposite = new FormData();
        fdWidgetsComposite.top = new FormAttachment((Control)lastControl, margin);
        fdWidgetsComposite.left = new FormAttachment(0, 0);
        fdWidgetsComposite.right = new FormAttachment(100, 0);
        fdWidgetsComposite.bottom = new FormAttachment(100, 0);
        this.wWidgetsComposite.setLayoutData((Object)fdWidgetsComposite);
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets((Object)this.metadata, null, this.wWidgetsComposite, GUI_WIDGETS_PARENT_ID, (Control)lastControl);
        this.guiCompositeWidgets.setWidgetsListener((IGuiPluginCompositeWidgetsListener)new GuiCompositeWidgetsAdapter(){

            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                MinioMetaEditor.this.setChanged();
            }
        });
        this.guiCompositeWidgets.setWidgetsListener((IGuiPluginCompositeWidgetsListener)new GuiCompositeWidgetsAdapter(){

            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                MinioMetaEditor.this.setChanged();
            }
        });
        this.setWidgetsContent();
        this.resetChanged();
        this.wName.addModifyListener(e -> this.setChanged());
    }

    public void setWidgetsContent() {
        MinioMeta meta = (MinioMeta)this.getMetadata();
        this.wName.setText(Const.NVL((String)meta.getName(), (String)""));
        this.guiCompositeWidgets.setWidgetsContents((Object)this.metadata, this.wWidgetsComposite, GUI_WIDGETS_PARENT_ID);
    }

    public void getWidgetsContent(MinioMeta meta) {
        meta.setName(this.wName.getText());
        this.guiCompositeWidgets.getWidgetsContents((Object)this.metadata, GUI_WIDGETS_PARENT_ID);
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public void save() throws HopException {
        super.save();
        HopVfs.reset();
    }
}

