/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.models.Query;

@InternalApi
public class ReadRowsFirstCallable<RowT>
extends UnaryCallable<Query, RowT> {
    private final ServerStreamingCallable<Query, RowT> inner;

    public ReadRowsFirstCallable(ServerStreamingCallable<Query, RowT> inner) {
        this.inner = inner;
    }

    public ApiFuture<RowT> futureCall(Query query, ApiCallContext context) {
        ReadRowsFirstResponseObserver observer = new ReadRowsFirstResponseObserver();
        this.inner.call((Object)query.limit(1L), observer, context);
        return observer.getFuture();
    }

    private class ReadRowsFirstResponseObserver<RowT>
    extends StateCheckingResponseObserver<RowT> {
        private StreamController innerController;
        private RowT firstRow;
        private SettableApiFuture<RowT> settableFuture = SettableApiFuture.create();

        private ReadRowsFirstResponseObserver() {
        }

        protected void onStartImpl(StreamController streamController) {
            this.innerController = streamController;
        }

        protected void onResponseImpl(RowT response) {
            if (this.firstRow == null) {
                this.firstRow = response;
            }
        }

        protected void onErrorImpl(Throwable throwable) {
            this.settableFuture.setException(throwable);
        }

        protected void onCompleteImpl() {
            this.settableFuture.set(this.firstRow);
        }

        protected ApiFuture<RowT> getFuture() {
            return this.settableFuture;
        }
    }
}

