/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelwriter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterFileField;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterOutputField;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTemplateField;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransform;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransformData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="TypeExitExcelWriterTransform", image="excelwriter.svg", name="i18n::TypeExitExcelWriterTransform.Name", description="i18n::TypeExitExcelWriterTransform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::ExcelWriterTransformMeta.keyword"}, documentationUrl="/pipeline/transforms/excelwriter.html")
public class ExcelWriterTransformMeta
extends BaseTransformMeta<ExcelWriterTransform, ExcelWriterTransformData> {
    private static final Class<?> PKG = ExcelWriterTransformMeta.class;
    public static final String IF_FILE_EXISTS_REUSE = "reuse";
    public static final String IF_FILE_EXISTS_CREATE_NEW = "new";
    public static final String IF_SHEET_EXISTS_REUSE = "reuse";
    public static final String IF_SHEET_EXISTS_CREATE_NEW = "new";
    public static final String ROW_WRITE_OVERWRITE = "overwrite";
    public static final String ROW_WRITE_PUSH_DOWN = "push";
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.MakeSheetActive.Field")
    private boolean makeSheetActive;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.ForceFormulaRecalculation.Field")
    private boolean forceFormulaRecalculation = false;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.LeaveExistingStylesUnchanged.Field")
    private boolean leaveExistingStylesUnchanged = false;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.AppendOffset.Field")
    private int appendOffset = 0;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.AppendEmpty.Field")
    private int appendEmpty = 0;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.SchemaDefinition.Field", hopMetadataPropertyType=HopMetadataPropertyType.STATIC_SCHEMA_DEFINITION)
    private String schemaDefinition;
    @HopMetadataProperty(key="ignore_fields", injectionKeyDescription="Ignore manual fields")
    private boolean ignoreFields;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.AppendOmitHeader.Field")
    private boolean appendOmitHeader = false;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.RowWritingMethod.Field")
    private String rowWritingMethod;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.StartingCell.Field")
    private String startingCell;
    @HopMetadataProperty(key="header", injectionKeyDescription="ExcelWriterMeta.Injection.HeaderEnabled.Field")
    private boolean headerEnabled;
    @HopMetadataProperty(key="footer", injectionKeyDescription="ExcelWriterMeta.Injection.FooterEnabled.Field")
    private boolean footerEnabled;
    @HopMetadataProperty(key="add_to_result_filenames", injectionKeyDescription="ExcelWriterMeta.Injection.AddToResultFilenames.Field")
    private boolean addToResultFilenames;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="FIELD", injectionGroupKey="FIELDS", injectionGroupDescription="ExcelWriterMeta.Injection.Fields", injectionKeyDescription="ExcelWriterMeta.Injection.Field")
    private List<ExcelWriterOutputField> outputFields;
    @HopMetadataProperty(injectionKeyDescription="ExcelWriterMeta.Injection.AppendLines.Field")
    private boolean appendLines;
    @HopMetadataProperty
    private ExcelWriterFileField file = new ExcelWriterFileField();
    @HopMetadataProperty
    private ExcelWriterTemplateField template = new ExcelWriterTemplateField();

    public ExcelWriterTransformMeta() {
        this.outputFields = new ArrayList<ExcelWriterOutputField>();
    }

    public void setAppendEmpty(int appendEmpty) {
        this.appendEmpty = Math.max(appendEmpty, 0);
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.addToResultFilenames = true;
        this.appendLines = false;
        this.startingCell = "A1";
        this.rowWritingMethod = ROW_WRITE_OVERWRITE;
        this.appendEmpty = 0;
        this.appendOffset = 0;
        this.appendOmitHeader = false;
        this.makeSheetActive = true;
        this.forceFormulaRecalculation = false;
        this.file.setDefault();
        this.template.setDefault();
    }

    public String[] getFiles(IVariables variables) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.file.isTransformNrInFilename()) {
            copies = 3;
        }
        if (this.file.getSplitEvery() != 0) {
            splits = 4;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(variables, copy, split, false, "", 1);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(IVariables variables, int transformNr, int splitNr, boolean beamContext, String transformId, int bundleNr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = variables.resolve(this.file.getFileName());
        String realextension = variables.resolve(this.file.getExtension());
        Date now = new Date();
        if (this.file.isSpecifyFormat() && !Utils.isEmpty((CharSequence)this.file.getDateTimeFormat())) {
            daf.applyPattern(this.file.getDateTimeFormat());
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (this.file.isDateInFilename()) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (this.file.isTimeInFilename()) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        if (this.file.isTransformNrInFilename()) {
            retval = (String)retval + "_" + transformNr;
        }
        if (this.file.getSplitEvery() > 0) {
            retval = (String)retval + "_" + splitNr;
        }
        if (beamContext) {
            retval = (String)retval + "_" + transformId + "_" + bundleNr;
        }
        if (!Utils.isEmpty((CharSequence)realextension)) {
            retval = (String)retval + "." + realextension;
        }
        return retval;
    }

    public String buildFilename(IRowMeta rowMeta, Object[] row, IVariables variables) {
        int filenameFieldIdx = rowMeta.indexOfValue(variables.resolve(this.getFile().getFileNameField()));
        Object retval = variables.resolve((String)row[filenameFieldIdx]);
        String realextension = variables.resolve(this.file.getExtension());
        if (!Utils.isEmpty((CharSequence)realextension)) {
            retval = (String)retval + "." + realextension;
        }
        return retval;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            int idx;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            if (this.getFile().isFileNameInField() && (idx = prev.indexOfValue(this.getFile().getFileNameField())) < 0) {
                errorMessage = BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.FilenameFieldNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            for (int i = 0; i < this.outputFields.size(); ++i) {
                ExcelWriterOutputField field = this.outputFields.get(i);
                int idx2 = prev.indexOfValue(field.getName());
                if (idx2 >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"ExcelWriterTransformMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject;
            if (!Utils.isEmpty((CharSequence)this.file.getFileName())) {
                fileObject = HopVfs.getFileObject((String)variables.resolve(this.file.getFileName()), (IVariables)variables);
                this.file.setFileName(iResourceNaming.nameResource(fileObject, variables, true));
            }
            if (!Utils.isEmpty((CharSequence)this.template.getTemplateFileName())) {
                fileObject = HopVfs.getFileObject((String)variables.resolve(this.template.getTemplateFileName()), (IVariables)variables);
                this.template.setTemplateFileName(iResourceNaming.nameResource(fileObject, variables, true));
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    @Generated
    public boolean isMakeSheetActive() {
        return this.makeSheetActive;
    }

    @Generated
    public boolean isForceFormulaRecalculation() {
        return this.forceFormulaRecalculation;
    }

    @Generated
    public boolean isLeaveExistingStylesUnchanged() {
        return this.leaveExistingStylesUnchanged;
    }

    @Generated
    public int getAppendOffset() {
        return this.appendOffset;
    }

    @Generated
    public int getAppendEmpty() {
        return this.appendEmpty;
    }

    @Generated
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @Generated
    public boolean isIgnoreFields() {
        return this.ignoreFields;
    }

    @Generated
    public boolean isAppendOmitHeader() {
        return this.appendOmitHeader;
    }

    @Generated
    public String getRowWritingMethod() {
        return this.rowWritingMethod;
    }

    @Generated
    public String getStartingCell() {
        return this.startingCell;
    }

    @Generated
    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    @Generated
    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    @Generated
    public boolean isAddToResultFilenames() {
        return this.addToResultFilenames;
    }

    @Generated
    public List<ExcelWriterOutputField> getOutputFields() {
        return this.outputFields;
    }

    @Generated
    public boolean isAppendLines() {
        return this.appendLines;
    }

    @Generated
    public ExcelWriterFileField getFile() {
        return this.file;
    }

    @Generated
    public ExcelWriterTemplateField getTemplate() {
        return this.template;
    }

    @Generated
    public void setMakeSheetActive(boolean makeSheetActive) {
        this.makeSheetActive = makeSheetActive;
    }

    @Generated
    public void setForceFormulaRecalculation(boolean forceFormulaRecalculation) {
        this.forceFormulaRecalculation = forceFormulaRecalculation;
    }

    @Generated
    public void setLeaveExistingStylesUnchanged(boolean leaveExistingStylesUnchanged) {
        this.leaveExistingStylesUnchanged = leaveExistingStylesUnchanged;
    }

    @Generated
    public void setAppendOffset(int appendOffset) {
        this.appendOffset = appendOffset;
    }

    @Generated
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    @Generated
    public void setIgnoreFields(boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    @Generated
    public void setAppendOmitHeader(boolean appendOmitHeader) {
        this.appendOmitHeader = appendOmitHeader;
    }

    @Generated
    public void setRowWritingMethod(String rowWritingMethod) {
        this.rowWritingMethod = rowWritingMethod;
    }

    @Generated
    public void setStartingCell(String startingCell) {
        this.startingCell = startingCell;
    }

    @Generated
    public void setHeaderEnabled(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
    }

    @Generated
    public void setFooterEnabled(boolean footerEnabled) {
        this.footerEnabled = footerEnabled;
    }

    @Generated
    public void setAddToResultFilenames(boolean addToResultFilenames) {
        this.addToResultFilenames = addToResultFilenames;
    }

    @Generated
    public void setOutputFields(List<ExcelWriterOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    @Generated
    public void setAppendLines(boolean appendLines) {
        this.appendLines = appendLines;
    }

    @Generated
    public void setFile(ExcelWriterFileField file) {
        this.file = file;
    }

    @Generated
    public void setTemplate(ExcelWriterTemplateField template) {
        this.template = template;
    }
}

