/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeinput;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInput;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="CubeInput", image="cubeinput.svg", name="i18n::CubeInput.Name", description="i18n::CubeInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::CubeInputMeta.keyword"}, documentationUrl="/pipeline/transforms/serialize-de-from-file.html")
public class CubeInputMeta
extends BaseTransformMeta<CubeInput, CubeInputData> {
    private static final Class<?> PKG = CubeInputMeta.class;
    @HopMetadataProperty(key="file")
    private CubeFile file = new CubeFile();
    @HopMetadataProperty(key="limit")
    private String rowLimit;
    @HopMetadataProperty(key="addfilenameresult")
    private boolean addFilenameResult;

    public CubeInputMeta() {
    }

    public CubeInputMeta(CubeInputMeta m) {
        this();
        this.file = new CubeFile(m.file);
        this.rowLimit = m.rowLimit;
        this.addFilenameResult = m.addFilenameResult;
    }

    public CubeInputMeta clone() {
        return new CubeInputMeta(this);
    }

    public void setDefault() {
        this.file = new CubeFile();
        this.rowLimit = "0";
        this.addFilenameResult = false;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        GZIPInputStream fis = null;
        FilterInputStream dis = null;
        try {
            InputStream is = HopVfs.getInputStream((String)variables.resolve(this.file.getName().replace("${Internal.Transform.CopyNr}", "0")));
            fis = new GZIPInputStream(is);
            dis = new DataInputStream(fis);
            RowMeta add = new RowMeta((DataInputStream)dis);
            for (int i = 0; i < add.size(); ++i) {
                add.getValueMeta(i).setOrigin(name);
            }
            r.mergeRowMeta((IRowMeta)add);
        }
        catch (HopFileException kfe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToReadMetaData", (String[])new String[0]), (Throwable)kfe);
        }
        catch (IOException e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.ErrorOpeningOrReadingCubeFile", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException ioe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToCloseCubeFile", (String[])new String[0]), (Throwable)ioe);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"CubeInputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.file.getName()));
            if (fileObject.exists()) {
                this.file.name = iResourceNaming.nameResource(fileObject, variables, true);
                return this.file.name;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public CubeFile getFile() {
        return this.file;
    }

    public void setFile(CubeFile file) {
        this.file = file;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isAddFilenameResult() {
        return this.addFilenameResult;
    }

    public void setAddFilenameResult(boolean addFilenameResult) {
        this.addFilenameResult = addFilenameResult;
    }

    public static class CubeFile {
        @HopMetadataProperty
        private String name;

        public CubeFile() {
        }

        public CubeFile(String name) {
            this.name = name;
        }

        public CubeFile(CubeFile f) {
            this.name = f.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

