/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryExecutionException;
import edu.umd.cs.findbugs.annotations.NonNull;

public class UnavailableException
extends QueryExecutionException {
    private final ConsistencyLevel consistencyLevel;
    private final int required;
    private final int alive;

    public UnavailableException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int required, int alive) {
        this(coordinator, String.format("Not enough replicas available for query at consistency %s (%d required but only %d alive)", consistencyLevel, required, alive), consistencyLevel, required, alive, null, false);
    }

    private UnavailableException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int required, int alive, ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, executionInfo, writableStackTrace);
        this.consistencyLevel = consistencyLevel;
        this.required = required;
        this.alive = alive;
    }

    @NonNull
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public int getRequired() {
        return this.required;
    }

    public int getAlive() {
        return this.alive;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new UnavailableException(this.getCoordinator(), this.getMessage(), this.consistencyLevel, this.required, this.alive, this.getExecutionInfo(), true);
    }
}

