/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Shell;

public class GetQueryFieldsProgressDialog {
    private static final Class<?> PKG = GetQueryFieldsProgressDialog.class;
    private final IVariables variables;
    private Shell shell;
    private DatabaseMeta databaseMeta;
    private String sql;
    private IRowMeta result;
    private Database db;

    public GetQueryFieldsProgressDialog(Shell shell, IVariables variables, DatabaseMeta databaseMeta, String sql) {
        this.shell = shell;
        this.variables = variables;
        this.databaseMeta = databaseMeta;
        this.sql = sql;
    }

    public IRowMeta open() {
        IRunnableWithProgress op = monitor -> {
            this.db = new Database(HopGui.getInstance().getLoggingObject(), this.variables, this.databaseMeta);
            try {
                this.db.connect();
                this.result = this.db.getQueryFields(this.sql, false);
                if (monitor.isCanceled()) {
                    throw new InvocationTargetException(new Exception("This operation was cancelled!"));
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, "Problem encountered determining query fields: " + e.toString());
            }
            finally {
                this.db.disconnect();
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = () -> {
                IProgressMonitor monitor = pmd.getProgressMonitor();
                while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        this.db.cancelQuery();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.result;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetQueryFieldsProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetQueryFieldsProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

