/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator.calculations.conversion;

import java.util.Base64;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.ICalculation;

public class Base64EncodePadded
implements ICalculation {
    private static final String description = BaseMessages.getString((Class)PKG, (String)"CalculatorMetaFunction.CalcFunctions.Base64EncodePadded", (String[])new String[0]);

    @Override
    public String getCode() {
        return "BASE64_ENCODE_PADDED";
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getDefaultResultType() {
        return 2;
    }

    @Override
    public CalculationOutput calculate(CalculationInput in) throws HopValueException {
        String value = null;
        if (in.dataA != null) {
            byte[] bytes = in.metaA.getType() == 8 ? in.metaA.getBinary(in.dataA) : in.metaA.getString(in.dataA).getBytes();
            value = Base64.getEncoder().encodeToString(bytes);
        }
        return new CalculationOutput(this.getDefaultResultType(), value);
    }
}

