/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fuzzymatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatch;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchData;

@Transform(id="FuzzyMatch", image="fuzzymatch.svg", name="i18n::FuzzyMatch.Name", description="i18n::FuzzyMatch.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::FuzzyMatchMeta.keyword"}, documentationUrl="/pipeline/transforms/fuzzymatch.html")
public class FuzzyMatchMeta
extends BaseTransformMeta<FuzzyMatch, FuzzyMatchData> {
    private static final Class<?> PKG = FuzzyMatchMeta.class;
    public static final String DEFAULT_SEPARATOR = ",";
    @HopMetadataProperty(key="algorithm", storeWithCode=true)
    private Algorithm algorithm = Algorithm.NONE;
    @HopMetadataProperty(key="from")
    private String lookupTransformName;
    @HopMetadataProperty(key="lookupfield")
    private String lookupField;
    @HopMetadataProperty(key="mainstreamfield")
    private String mainStreamField;
    @HopMetadataProperty(key="outputmatchfield")
    private String outputMatchField;
    @HopMetadataProperty(key="outputvaluefield")
    private String outputValueField;
    @HopMetadataProperty(key="caseSensitive")
    private boolean caseSensitive;
    @HopMetadataProperty(key="minimalValue")
    private String minimalValue;
    @HopMetadataProperty(key="maximalValue")
    private String maximalValue;
    @HopMetadataProperty(key="separator")
    private String separator;
    @HopMetadataProperty(key="closervalue")
    private boolean closerValue;
    @HopMetadataProperty(groupKey="lookup", key="value")
    private List<FMLookupValue> lookupValues = new ArrayList<FMLookupValue>();

    public FuzzyMatchMeta() {
    }

    public FuzzyMatchMeta(FuzzyMatchMeta m) {
        this();
        this.algorithm = m.algorithm;
        this.lookupField = m.lookupField;
        this.mainStreamField = m.mainStreamField;
        this.outputMatchField = m.outputMatchField;
        this.outputValueField = m.outputValueField;
        this.caseSensitive = m.caseSensitive;
        this.minimalValue = m.minimalValue;
        this.maximalValue = m.maximalValue;
        this.separator = m.separator;
        this.closerValue = m.closerValue;
        m.lookupValues.forEach(v -> this.lookupValues.add(new FMLookupValue((FMLookupValue)v)));
    }

    public FuzzyMatchMeta clone() {
        return new FuzzyMatchMeta(this);
    }

    public void setDefault() {
        this.algorithm = Algorithm.NONE;
        this.separator = DEFAULT_SEPARATOR;
        this.closerValue = true;
        this.minimalValue = "0";
        this.maximalValue = "1";
        this.caseSensitive = false;
        this.lookupField = null;
        this.mainStreamField = null;
        this.outputMatchField = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputMatchFieldname", (String[])new String[0]);
        this.outputValueField = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputValueFieldname", (String[])new String[0]);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        block11: {
            boolean activateAdditionalFields;
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getOutputMatchField()));
            v.setOrigin(name);
            v.setStorageType(0);
            inputRowMeta.addValueMeta((IValueMeta)v);
            String mainField = variables.resolve(this.getOutputValueField());
            if (StringUtils.isNotEmpty((String)mainField) && this.isCloserValue()) {
                switch (this.getAlgorithm()) {
                    case NONE: {
                        throw new HopTransformException("Please specify the matching algorithm to use");
                    }
                    case LEVENSHTEIN: {
                        v = new ValueMetaInteger(mainField);
                        v.setLength(10);
                        break;
                    }
                    case JARO: 
                    case JARO_WINKLER: 
                    case PAIR_SIMILARITY: {
                        v = new ValueMetaNumber(mainField);
                        break;
                    }
                    default: {
                        v = new ValueMetaString(mainField);
                    }
                }
                v.setStorageType(0);
                v.setOrigin(name);
                inputRowMeta.addValueMeta((IValueMeta)v);
            }
            boolean bl = activateAdditionalFields = this.isCloserValue() || this.getAlgorithm() == Algorithm.DOUBLE_METAPHONE || this.getAlgorithm() == Algorithm.SOUNDEX || this.getAlgorithm() == Algorithm.REFINED_SOUNDEX || this.getAlgorithm() == Algorithm.METAPHONE;
            if (!activateAdditionalFields) break block11;
            if (info != null && info.length == 1 && info[0] != null) {
                for (FMLookupValue lookupValue : this.lookupValues) {
                    v = info[0].searchValueMeta(lookupValue.getName());
                    if (v != null) {
                        v.setName(lookupValue.getName());
                        v.setOrigin(name);
                        v.setStorageType(0);
                        inputRowMeta.addValueMeta((IValueMeta)v);
                        continue;
                    }
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{lookupValue.getName()}));
                }
            } else {
                for (FMLookupValue lookupValue : this.lookupValues) {
                    v = new ValueMetaString(lookupValue.getName());
                    v.setOrigin(name);
                    inputRowMeta.addValueMeta((IValueMeta)v);
                }
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int idx;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String mainField = variables.resolve(this.getMainStreamField());
            idx = prev.indexOfValue(mainField);
            cr = idx < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldNotFound", (String[])new String[]{mainField}), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldFound", (String[])new String[]{mainField}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.CouldNotFindFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (info != null && !info.isEmpty()) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingLookupData", (String[])new String[]{"" + info.size()}), (ICheckResultSource)transformMeta));
            String realLookupField = variables.resolve(this.getLookupField());
            idx = info.indexOfValue(realLookupField);
            if (idx < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldNotFoundInLookupStream", (String[])new String[]{realLookupField}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldFoundInTheLookupStream", (String[])new String[]{realLookupField}), (ICheckResultSource)transformMeta));
            }
            StringBuilder errorMessage = new StringBuilder();
            boolean errorFound = false;
            for (FMLookupValue lookupValue : this.lookupValues) {
                idx = info.indexOfValue(lookupValue.getName());
                if (idx >= 0) continue;
                errorMessage.append("\t\t").append(lookupValue.getName()).append(Const.CR);
                errorFound = true;
            }
            if (errorFound) {
                errorMessage.insert(0, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR);
                remarks.add((ICheckResult)new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        if (infoStream.getTransformMeta() == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformNotSelected", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformIsSelected", (String[])new String[0]), (ICheckResultSource)transformMeta));
            if (info != null) {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformDoesNotExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta));
            }
        }
        if (input.length >= 2) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingInfoFromInputTransforms", (String[])new String[]{"" + input.length}), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (ICheckResultSource)transformMeta));
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, this.lookupTransformName);
            ioMeta.addStream((IStream)stream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String getLookupTransformName() {
        return this.lookupTransformName;
    }

    public void setLookupTransformName(String lookupTransformName) {
        this.lookupTransformName = lookupTransformName;
    }

    public String getLookupField() {
        return this.lookupField;
    }

    public void setLookupField(String lookupField) {
        this.lookupField = lookupField;
    }

    public String getMainStreamField() {
        return this.mainStreamField;
    }

    public void setMainStreamField(String mainStreamField) {
        this.mainStreamField = mainStreamField;
    }

    public String getOutputMatchField() {
        return this.outputMatchField;
    }

    public void setOutputMatchField(String outputMatchField) {
        this.outputMatchField = outputMatchField;
    }

    public String getOutputValueField() {
        return this.outputValueField;
    }

    public void setOutputValueField(String outputValueField) {
        this.outputValueField = outputValueField;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getMinimalValue() {
        return this.minimalValue;
    }

    public void setMinimalValue(String minimalValue) {
        this.minimalValue = minimalValue;
    }

    public String getMaximalValue() {
        return this.maximalValue;
    }

    public void setMaximalValue(String maximalValue) {
        this.maximalValue = maximalValue;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isCloserValue() {
        return this.closerValue;
    }

    public void setCloserValue(boolean closerValue) {
        this.closerValue = closerValue;
    }

    public List<FMLookupValue> getLookupValues() {
        return this.lookupValues;
    }

    public void setLookupValues(List<FMLookupValue> lookupValues) {
        this.lookupValues = lookupValues;
    }

    public static enum Algorithm implements IEnumHasCodeAndDescription
    {
        NONE("", ""),
        LEVENSHTEIN("levenshtein", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Levenshtein", (String[])new String[0])),
        DAMERAU_LEVENSHTEIN("dameraulevenshtein", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DamerauLevenshtein", (String[])new String[0])),
        NEEDLEMAN_WUNSH("needlemanwunsch", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.NeedlemanWunsch", (String[])new String[0])),
        JARO("jaro", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Jaro", (String[])new String[0])),
        JARO_WINKLER("jarowinkler", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.JaroWinkler", (String[])new String[0])),
        PAIR_SIMILARITY("pairsimilarity", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.PairSimilarity", (String[])new String[0])),
        METAPHONE("metaphone", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Metaphone", (String[])new String[0])),
        DOUBLE_METAPHONE("doublemataphone", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DoubleMetaphone", (String[])new String[0])),
        SOUNDEX("soundex", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.SoundEx", (String[])new String[0])),
        REFINED_SOUNDEX("refinedsoundex", BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.RefinedSoundEx", (String[])new String[0]));

        private final String code;
        private final String description;

        private Algorithm(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(Algorithm.class);
        }

        public static Algorithm lookupDescription(String description) {
            return (Algorithm)IEnumHasCodeAndDescription.lookupDescription(Algorithm.class, (String)description, (IEnumHasCodeAndDescription)NONE);
        }

        public static Algorithm lookupCode(String code) {
            return (Algorithm)IEnumHasCode.lookupCode(Algorithm.class, (String)code, (IEnumHasCode)NONE);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class FMLookupValue {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="rename")
        private String rename;

        public FMLookupValue() {
        }

        public FMLookupValue(FMLookupValue v) {
            this.name = v.name;
            this.rename = v.rename;
        }

        public FMLookupValue(String name, String rename) {
            this.name = name;
            this.rename = rename;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRename() {
            return this.rename;
        }

        public void setRename(String rename) {
            this.rename = rename;
        }
    }
}

