/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class Result
implements Cloneable {
    public static final String XML_TAG = "result";
    public static final String XML_FILES_TAG = "result-file";
    public static final String XML_FILE_TAG = "result-file";
    public static final String XML_ROWS_TAG = "result-rows";
    private long nrErrors = 0L;
    private long nrLinesInput = 0L;
    private long nrLinesOutput = 0L;
    private long nrLinesUpdated = 0L;
    private long nrLinesRead = 0L;
    private long nrLinesWritten = 0L;
    private long nrLinesDeleted;
    private long nrFilesRetrieved;
    private boolean result = false;
    private long entryNr = 0L;
    private int exitStatus = 0;
    private List<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
    private Map<String, ResultFile> resultFiles = new ConcurrentHashMap<String, ResultFile>();
    private boolean stopped = false;
    private long nrLinesRejected;
    private String logChannelId;
    private String logText;
    private long elapsedTimeMillis;
    private String executionId;
    private String containerId;

    public Result() {
    }

    public Result(int nr) {
        this();
        this.entryNr = nr;
    }

    public Result lightClone() {
        try {
            Result result = (Result)super.clone();
            result.setRows(null);
            if (this.resultFiles != null) {
                ConcurrentHashMap<String, ResultFile> clonedFiles = new ConcurrentHashMap<String, ResultFile>();
                Collection<ResultFile> files = this.resultFiles.values();
                for (ResultFile file : files) {
                    clonedFiles.put(file.getFile().toString(), file.clone());
                }
                result.setResultFiles(clonedFiles);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Result clone() {
        try {
            Result result = (Result)super.clone();
            if (this.rows != null) {
                ArrayList<RowMetaAndData> clonedRows = new ArrayList<RowMetaAndData>();
                for (RowMetaAndData row : this.rows) {
                    clonedRows.add(row.clone());
                }
                result.setRows(clonedRows);
            }
            if (this.resultFiles != null) {
                ConcurrentHashMap<String, ResultFile> clonedFiles = new ConcurrentHashMap<String, ResultFile>();
                Collection<ResultFile> files = this.resultFiles.values();
                for (ResultFile file : files) {
                    clonedFiles.put(file.getFile().toString(), file.clone());
                }
                result.setResultFiles(clonedFiles);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "nr=" + this.entryNr + ", errors=" + this.nrErrors + ", exit_status=" + this.exitStatus + (String)(this.stopped ? " (Stopped)" : ", result=" + this.result);
    }

    public List<RowMetaAndData> getRows() {
        return new ArrayList<RowMetaAndData>(this.rows);
    }

    public void setRows(List<RowMetaAndData> rows) {
        this.rows = rows == null ? new ArrayList<RowMetaAndData>() : new ArrayList<RowMetaAndData>(rows);
    }

    public void addRow(RowMetaAndData row) {
        if (row != null) {
            this.rows.add(row);
        }
    }

    public void clear() {
        this.nrLinesInput = 0L;
        this.nrLinesOutput = 0L;
        this.nrLinesRead = 0L;
        this.nrLinesWritten = 0L;
        this.nrLinesUpdated = 0L;
        this.nrLinesRejected = 0L;
        this.nrLinesDeleted = 0L;
        this.nrErrors = 0L;
        this.nrFilesRetrieved = 0L;
        this.logText = null;
    }

    public void add(Result res) {
        this.nrLinesInput += res.getNrLinesInput();
        this.nrLinesOutput += res.getNrLinesOutput();
        this.nrLinesRead += res.getNrLinesRead();
        this.nrLinesWritten += res.getNrLinesWritten();
        this.nrLinesUpdated += res.getNrLinesUpdated();
        this.nrLinesRejected += res.getNrLinesRejected();
        this.nrLinesDeleted += res.getNrLinesDeleted();
        this.nrErrors += res.getNrErrors();
        this.nrFilesRetrieved += res.getNrFilesRetrieved();
        this.resultFiles.putAll(res.getResultFiles());
        this.logChannelId = res.getLogChannelId();
        this.logText = res.getLogText();
        if (res.rows != null && !res.rows.isEmpty()) {
            this.rows.addAll(res.rows);
        }
    }

    @JsonIgnore
    public String getXml() {
        try {
            StringBuilder xml = new StringBuilder();
            xml.append(XmlHandler.openTag(XML_TAG));
            this.setBasicXmlAttrs(xml);
            xml.append(XmlHandler.openTag("result-file"));
            for (ResultFile resultFile : this.resultFiles.values()) {
                xml.append(resultFile.getXml());
            }
            xml.append(XmlHandler.closeTag("result-file"));
            xml.append(XmlHandler.openTag(XML_ROWS_TAG));
            boolean firstRow = true;
            IRowMeta rowMeta = null;
            for (RowMetaAndData row : this.rows) {
                if (firstRow) {
                    firstRow = false;
                    rowMeta = row.getRowMeta();
                    if (rowMeta != null) {
                        xml.append(rowMeta.getMetaXml());
                    }
                }
                if (rowMeta == null) continue;
                xml.append(rowMeta.getDataXml(row.getData()));
            }
            xml.append(XmlHandler.closeTag(XML_ROWS_TAG));
            xml.append(XmlHandler.closeTag(XML_TAG));
            return xml.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error encoding workflow result as XML", e);
        }
    }

    private StringBuilder setBasicXmlAttrs(StringBuilder xml) {
        xml.append(XmlHandler.addTagValue("lines_input", this.nrLinesInput));
        xml.append(XmlHandler.addTagValue("lines_output", this.nrLinesOutput));
        xml.append(XmlHandler.addTagValue("lines_read", this.nrLinesRead));
        xml.append(XmlHandler.addTagValue("lines_written", this.nrLinesWritten));
        xml.append(XmlHandler.addTagValue("lines_updated", this.nrLinesUpdated));
        xml.append(XmlHandler.addTagValue("lines_rejected", this.nrLinesRejected));
        xml.append(XmlHandler.addTagValue("lines_deleted", this.nrLinesDeleted));
        xml.append(XmlHandler.addTagValue("nr_errors", this.nrErrors));
        xml.append(XmlHandler.addTagValue("nr_files_retrieved", this.nrFilesRetrieved));
        xml.append(XmlHandler.addTagValue("entry_nr", this.entryNr));
        xml.append(XmlHandler.addTagValue(XML_TAG, this.result));
        xml.append(XmlHandler.addTagValue("exit_status", this.exitStatus));
        xml.append(XmlHandler.addTagValue("is_stopped", this.stopped));
        xml.append(XmlHandler.addTagValue("log_channel_id", this.logChannelId));
        xml.append(XmlHandler.addTagValue("log_text", this.logText));
        xml.append(XmlHandler.addTagValue("elapsedTimeMillis", this.elapsedTimeMillis));
        xml.append(XmlHandler.addTagValue("executionId", this.executionId));
        xml.append(XmlHandler.addTagValue("containerId", this.containerId));
        return xml;
    }

    @JsonIgnore
    public String getBasicXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag(XML_TAG));
        this.setBasicXmlAttrs(xml);
        xml.append(XmlHandler.closeTag(XML_TAG));
        return xml.toString();
    }

    public Result(Node node) throws HopException {
        this();
        this.nrLinesInput = Const.toLong(XmlHandler.getTagValue(node, "lines_input"), 0L);
        this.nrLinesOutput = Const.toLong(XmlHandler.getTagValue(node, "lines_output"), 0L);
        this.nrLinesRead = Const.toLong(XmlHandler.getTagValue(node, "lines_read"), 0L);
        this.nrLinesWritten = Const.toLong(XmlHandler.getTagValue(node, "lines_written"), 0L);
        this.nrLinesUpdated = Const.toLong(XmlHandler.getTagValue(node, "lines_updated"), 0L);
        this.nrLinesRejected = Const.toLong(XmlHandler.getTagValue(node, "lines_rejected"), 0L);
        this.nrLinesDeleted = Const.toLong(XmlHandler.getTagValue(node, "lines_deleted"), 0L);
        this.nrErrors = Const.toLong(XmlHandler.getTagValue(node, "nr_errors"), 0L);
        this.nrFilesRetrieved = Const.toLong(XmlHandler.getTagValue(node, "nr_files_retrieved"), 0L);
        this.entryNr = Const.toLong(XmlHandler.getTagValue(node, "entry_nr"), 0L);
        this.result = "Y".equalsIgnoreCase(XmlHandler.getTagValue(node, XML_TAG));
        this.exitStatus = Integer.parseInt(XmlHandler.getTagValue(node, "exit_status"));
        this.stopped = "Y".equalsIgnoreCase(XmlHandler.getTagValue(node, "is_stopped"));
        this.logChannelId = XmlHandler.getTagValue(node, "log_channel_id");
        this.logText = XmlHandler.getTagValue(node, "log_text");
        this.elapsedTimeMillis = Const.toLong(XmlHandler.getTagValue(node, "elapsedTimeMillis"), 0L);
        this.executionId = XmlHandler.getTagValue(node, "executionId");
        this.containerId = XmlHandler.getTagValue(node, "containerId");
        Node resultFilesNode = XmlHandler.getSubNode(node, "result-file");
        int nrResultFiles = XmlHandler.countNodes(resultFilesNode, "result-file");
        for (int i = 0; i < nrResultFiles; ++i) {
            try {
                ResultFile resultFile = new ResultFile(XmlHandler.getSubNodeByNr(resultFilesNode, "result-file", i));
                this.resultFiles.put(resultFile.getFile().toString(), resultFile);
                continue;
            }
            catch (HopFileException e) {
                throw new HopException("Unexpected error reading back a ResultFile object from XML", e);
            }
        }
        Node resultRowsNode = XmlHandler.getSubNode(node, XML_ROWS_TAG);
        List<Node> resultNodes = XmlHandler.getNodes(resultRowsNode, "row-data");
        if (!resultNodes.isEmpty()) {
            RowMeta rowMeta = new RowMeta(XmlHandler.getSubNode(resultRowsNode, "row-meta"));
            for (Node resultNode : resultNodes) {
                Object[] rowData = rowMeta.getRow(resultNode);
                this.addRow(new RowMetaAndData(rowMeta, rowData));
            }
        }
    }

    @JsonIgnore
    public List<ResultFile> getResultFilesList() {
        return new ArrayList<ResultFile>(this.resultFiles.values());
    }

    public void increaseLinesRead(long incr) {
        this.nrLinesRead += incr;
    }

    public void increaseLinesWritten(long incr) {
        this.nrLinesWritten += incr;
    }

    public void increaseLinesInput(long incr) {
        this.nrLinesInput += incr;
    }

    public void increaseLinesOutput(long incr) {
        this.nrLinesOutput += incr;
    }

    public void increaseLinesUpdated(long incr) {
        this.nrLinesUpdated += incr;
    }

    public void increaseLinesDeleted(long incr) {
        this.nrLinesDeleted += incr;
    }

    public void increaseLinesRejected(long incr) {
        this.nrLinesRejected += incr;
    }

    public void increaseErrors(long incr) {
        this.nrErrors += incr;
    }

    @Deprecated(since="2.16")
    public boolean getResult() {
        return this.result;
    }

    public boolean isResult() {
        return this.result;
    }

    @Generated
    public long getNrErrors() {
        return this.nrErrors;
    }

    @Generated
    public long getNrLinesInput() {
        return this.nrLinesInput;
    }

    @Generated
    public long getNrLinesOutput() {
        return this.nrLinesOutput;
    }

    @Generated
    public long getNrLinesUpdated() {
        return this.nrLinesUpdated;
    }

    @Generated
    public long getNrLinesRead() {
        return this.nrLinesRead;
    }

    @Generated
    public long getNrLinesWritten() {
        return this.nrLinesWritten;
    }

    @Generated
    public long getNrLinesDeleted() {
        return this.nrLinesDeleted;
    }

    @Generated
    public long getNrFilesRetrieved() {
        return this.nrFilesRetrieved;
    }

    @Generated
    public long getEntryNr() {
        return this.entryNr;
    }

    @Generated
    public int getExitStatus() {
        return this.exitStatus;
    }

    @Generated
    public Map<String, ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    @Generated
    public boolean isStopped() {
        return this.stopped;
    }

    @Generated
    public long getNrLinesRejected() {
        return this.nrLinesRejected;
    }

    @Generated
    public String getLogChannelId() {
        return this.logChannelId;
    }

    @Generated
    public String getLogText() {
        return this.logText;
    }

    @Generated
    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getContainerId() {
        return this.containerId;
    }

    @Generated
    public void setNrErrors(long nrErrors) {
        this.nrErrors = nrErrors;
    }

    @Generated
    public void setNrLinesInput(long nrLinesInput) {
        this.nrLinesInput = nrLinesInput;
    }

    @Generated
    public void setNrLinesOutput(long nrLinesOutput) {
        this.nrLinesOutput = nrLinesOutput;
    }

    @Generated
    public void setNrLinesUpdated(long nrLinesUpdated) {
        this.nrLinesUpdated = nrLinesUpdated;
    }

    @Generated
    public void setNrLinesRead(long nrLinesRead) {
        this.nrLinesRead = nrLinesRead;
    }

    @Generated
    public void setNrLinesWritten(long nrLinesWritten) {
        this.nrLinesWritten = nrLinesWritten;
    }

    @Generated
    public void setNrLinesDeleted(long nrLinesDeleted) {
        this.nrLinesDeleted = nrLinesDeleted;
    }

    @Generated
    public void setNrFilesRetrieved(long nrFilesRetrieved) {
        this.nrFilesRetrieved = nrFilesRetrieved;
    }

    @Generated
    public void setResult(boolean result) {
        this.result = result;
    }

    @Generated
    public void setEntryNr(long entryNr) {
        this.entryNr = entryNr;
    }

    @Generated
    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    @Generated
    public void setResultFiles(Map<String, ResultFile> resultFiles) {
        this.resultFiles = resultFiles;
    }

    @Generated
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Generated
    public void setNrLinesRejected(long nrLinesRejected) {
        this.nrLinesRejected = nrLinesRejected;
    }

    @Generated
    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Generated
    public void setLogText(String logText) {
        this.logText = logText;
    }

    @Generated
    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    @Generated
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }
}

