/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

@Internal
public class SelectByMinFunction<T extends Tuple>
implements ReduceFunction<T> {
    private static final long serialVersionUID = 1L;
    private int[] fields;

    public SelectByMinFunction(TupleTypeInfo<T> type, int ... fields) {
        this.fields = fields;
        for (int field : fields) {
            if (field < 0 || field >= type.getArity()) {
                throw new IndexOutOfBoundsException("MinReduceFunction field position " + field + " is out of range.");
            }
            if (type.getTypeAt(field).isKeyType()) continue;
            throw new IllegalArgumentException("MinReduceFunction supports only key(Comparable) types.");
        }
    }

    public T reduce(T value1, T value2) throws Exception {
        for (int position : this.fields) {
            Comparable comparable2;
            Comparable comparable1 = (Comparable)value1.getFieldNotNull(position);
            int comp = comparable1.compareTo(comparable2 = (Comparable)value2.getFieldNotNull(position));
            if (comp < 0) {
                return value1;
            }
            if (comp <= 0) continue;
            return value2;
        }
        return value1;
    }
}

