/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapConnection;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputData;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputField;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputMeta;

public class LdapInput
extends BaseTransform<LdapInputMeta, LdapInputData> {
    private static final Class<?> PKG = LdapInputMeta.class;

    public LdapInput(TransformMeta transformMeta, LdapInputMeta meta, LdapInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (!((LdapInputData)this.data).dynamic && this.first) {
            this.first = false;
            ((LdapInputData)this.data).outputRowMeta = new RowMeta();
            ((LdapInputMeta)this.meta).getFields(((LdapInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((LdapInputData)this.data).convertRowMeta = ((LdapInputData)this.data).outputRowMeta.cloneToType(2);
            this.search(((LdapInputData)this.data).staticSearchBase, ((LdapInputData)this.data).staticFilter);
        }
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(((LdapInputData)this.data).outputRowMeta, outputRowData);
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"LdapInput.log.ReadRow", (String[])new String[0]), new Object[]{((LdapInputData)this.data).outputRowMeta.getString(outputRowData)});
            }
            if (this.checkFeedback(this.getLinesInput()) && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LdapInput.log.LineRow", (String[])new String[0]) + this.getLinesInput());
            }
            return true;
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"LdapInput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.logError(Const.getStackTracker((Throwable)e));
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "LDAPINPUT001");
            }
            return true;
        }
    }

    private boolean dynamicSearch() throws HopException {
        ((LdapInputData)this.data).readRow = this.getRow();
        if (((LdapInputData)this.data).readRow == null) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LdapInput.Log.FinishedProcessing", (String[])new String[0]));
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((LdapInputMeta)this.meta).isDynamicSearch() && Utils.isEmpty((CharSequence)((LdapInputMeta)this.meta).getDynamicSearchFieldName())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"LdapInput.Error.DynamicSearchFieldMissing", (String[])new String[0]));
            }
            if (((LdapInputMeta)this.meta).isDynamicFilter() && Utils.isEmpty((CharSequence)((LdapInputMeta)this.meta).getDynamicFilterFieldName())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"LdapInput.Error.DynamicFilterFieldMissing", (String[])new String[0]));
            }
            ((LdapInputData)this.data).nrIncomingFields = this.getInputRowMeta().size();
            ((LdapInputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((LdapInputMeta)this.meta).getFields(((LdapInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((LdapInputData)this.data).convertRowMeta = ((LdapInputData)this.data).outputRowMeta.cloneToType(2);
            if (((LdapInputMeta)this.meta).isDynamicSearch()) {
                ((LdapInputData)this.data).indexOfSearchBaseField = this.getInputRowMeta().indexOfValue(((LdapInputMeta)this.meta).getDynamicSearchFieldName());
                if (((LdapInputData)this.data).indexOfSearchBaseField < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"LdapInput.Exception.CouldnotFindField", (String[])new String[]{((LdapInputMeta)this.meta).getDynamicSearchFieldName()}));
                }
            }
            if (((LdapInputMeta)this.meta).isDynamicFilter()) {
                ((LdapInputData)this.data).indexOfFilterField = this.getInputRowMeta().indexOfValue(((LdapInputMeta)this.meta).getDynamicFilterFieldName());
                if (((LdapInputData)this.data).indexOfFilterField < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"LdapInput.Exception.CouldnotFindField", (String[])new String[]{((LdapInputMeta)this.meta).getDynamicFilterFieldName()}));
                }
            }
        }
        String searchBase = ((LdapInputData)this.data).staticSearchBase;
        if (((LdapInputData)this.data).indexOfSearchBaseField > 0) {
            searchBase = this.getInputRowMeta().getString(((LdapInputData)this.data).readRow, ((LdapInputData)this.data).indexOfSearchBaseField);
        }
        String filter = ((LdapInputData)this.data).staticFilter;
        if (((LdapInputData)this.data).indexOfFilterField >= 0) {
            filter = this.getInputRowMeta().getString(((LdapInputData)this.data).readRow, ((LdapInputData)this.data).indexOfFilterField);
        }
        this.search(searchBase, filter);
        return true;
    }

    private Object[] getOneRow() throws HopException {
        if (((LdapInputData)this.data).dynamic) {
            while (((LdapInputData)this.data).readRow == null || (((LdapInputData)this.data).attributes = ((LdapInputData)this.data).connection.getAttributes()) == null) {
                if (this.dynamicSearch()) continue;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LdapInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return null;
            }
        } else {
            ((LdapInputData)this.data).attributes = ((LdapInputData)this.data).connection.getAttributes();
        }
        if (((LdapInputData)this.data).attributes == null) {
            return null;
        }
        return this.buildRow();
    }

    private Object[] buildRow() throws HopException {
        Object[] outputRowData = this.buildEmptyRow();
        if (((LdapInputData)this.data).dynamic) {
            System.arraycopy(((LdapInputData)this.data).readRow, 0, outputRowData, 0, ((LdapInputData)this.data).readRow.length);
        }
        try {
            for (int i = 0; i < ((LdapInputMeta)this.meta).getInputFields().length; ++i) {
                LdapInputField field = ((LdapInputMeta)this.meta).getInputFields()[i];
                int index = ((LdapInputData)this.data).nrIncomingFields + i;
                Attribute attr = ((LdapInputData)this.data).attributes.get(field.getRealAttribute());
                if (attr != null) {
                    outputRowData[index] = this.getAttributeValue(field, attr, index, outputRowData[index]);
                }
                if (!field.isRepeated() || ((LdapInputData)this.data).previousRow == null || outputRowData[index] != null) continue;
                outputRowData[index] = ((LdapInputData)this.data).previousRow[index];
            }
            int fIndex = ((LdapInputData)this.data).nrIncomingFields + ((LdapInputData)this.data).nrFields;
            if (((LdapInputMeta)this.meta).isIncludeRowNumber() && !Utils.isEmpty((CharSequence)((LdapInputMeta)this.meta).getRowNumberField())) {
                outputRowData[fIndex] = ((LdapInputData)this.data).rownr;
            }
            IRowMeta irow = this.getInputRowMeta();
            ((LdapInputData)this.data).previousRow = irow == null ? outputRowData : irow.cloneRow(outputRowData);
            ++((LdapInputData)this.data).rownr;
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"LdapInput.Exception.CanNotReadLDAP", (String[])new String[0]), (Throwable)e);
        }
        return outputRowData;
    }

    private Object getAttributeValue(LdapInputField field, Attribute attr, int i, Object outputRowData) throws Exception {
        if (field.getType() == 8) {
            try {
                return attr.get();
            }
            catch (ClassCastException e) {
                return attr.get().toString().getBytes();
            }
        }
        String retval = null;
        if (field.getReturnType() == 1 && field.getType() == 2) {
            return LdapConnection.extractBytesAndConvertToString(attr, field.isObjectSid());
        }
        retval = this.extractString(attr);
        switch (field.getTrimType()) {
            case 1: {
                retval = Const.ltrim((String)retval);
                break;
            }
            case 2: {
                retval = Const.rtrim((String)retval);
                break;
            }
            case 3: {
                retval = Const.trim((String)retval);
                break;
            }
        }
        IValueMeta targetValueMeta = ((LdapInputData)this.data).outputRowMeta.getValueMeta(i);
        IValueMeta sourceValueMeta = ((LdapInputData)this.data).convertRowMeta.getValueMeta(i);
        return targetValueMeta.convertData(sourceValueMeta, (Object)retval);
    }

    private String extractString(Attribute attr) throws Exception {
        StringBuilder attrStr = new StringBuilder();
        NamingEnumeration<?> eattr = attr.getAll();
        while (eattr.hasMore()) {
            if (!attrStr.isEmpty()) {
                attrStr.append(((LdapInputData)this.data).multiValuedFieldSeparator);
            }
            attrStr.append(eattr.next().toString());
        }
        return attrStr.toString();
    }

    private void connectServerLdap() throws HopException {
        LdapInputField field;
        int i;
        ((LdapInputData)this.data).attrReturned = new String[((LdapInputMeta)this.meta).getInputFields().length];
        ((LdapInputData)this.data).attributesBinary = new HashSet();
        for (i = 0; i < ((LdapInputMeta)this.meta).getInputFields().length; ++i) {
            field = ((LdapInputMeta)this.meta).getInputFields()[i];
            String name = this.resolve(field.getAttribute());
            field.setRealAttribute(name);
            if (field.getReturnType() == 1) {
                ((LdapInputData)this.data).attributesBinary.add(name);
            }
            ((LdapInputData)this.data).attrReturned[i] = name;
        }
        ((LdapInputData)this.data).connection = new LdapConnection(this.getLogChannel(), (IVariables)this, (ILdapMeta)this.meta, ((LdapInputData)this.data).attributesBinary);
        for (i = 0; i < ((LdapInputData)this.data).attrReturned.length; ++i) {
            field = ((LdapInputMeta)this.meta).getInputFields()[i];
            if (!field.isSortedKey()) continue;
            ((LdapInputData)this.data).connection.addSortingAttributes(((LdapInputData)this.data).attrReturned[i]);
        }
        if (((LdapInputMeta)this.meta).isUseAuthentication()) {
            String username = this.resolve(((LdapInputMeta)this.meta).getUserName());
            String password = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((LdapInputMeta)this.meta).getPassword()));
            ((LdapInputData)this.data).connection.connect(username, password);
        } else {
            ((LdapInputData)this.data).connection.connect();
        }
        if (((LdapInputMeta)this.meta).getTimeLimit() > 0) {
            ((LdapInputData)this.data).connection.setTimeLimit(((LdapInputMeta)this.meta).getTimeLimit() * 1000);
        }
        if (((LdapInputMeta)this.meta).isPaging()) {
            ((LdapInputData)this.data).connection.setPagingSize(Const.toInt((String)this.resolve(((LdapInputMeta)this.meta).getPageSize()), (int)-1));
        }
    }

    private void search(String searchBase, String filter) throws HopException {
        ((LdapInputData)this.data).connection.search(searchBase, filter, ((LdapInputMeta)this.meta).getRowLimit(), ((LdapInputData)this.data).attrReturned, ((LdapInputMeta)this.meta).getSearchScope());
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((LdapInputData)this.data).outputRowMeta.size());
    }

    public boolean init() {
        if (super.init()) {
            ((LdapInputData)this.data).rownr = 1L;
            ((LdapInputData)this.data).multiValuedFieldSeparator = this.resolve(((LdapInputMeta)this.meta).getMultiValuedSeparator());
            ((LdapInputData)this.data).nrFields = ((LdapInputMeta)this.meta).getInputFields().length;
            ((LdapInputData)this.data).staticFilter = this.resolve(((LdapInputMeta)this.meta).getFilterString());
            ((LdapInputData)this.data).staticSearchBase = this.resolve(((LdapInputMeta)this.meta).getSearchBase());
            ((LdapInputData)this.data).dynamic = ((LdapInputMeta)this.meta).isDynamicSearch() || ((LdapInputMeta)this.meta).isDynamicFilter();
            try {
                this.connectServerLdap();
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"LdapInput.ErrorInit", (String[])new String[]{e.toString()}));
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    public void dispose() {
        if (((LdapInputData)this.data).connection != null) {
            try {
                ((LdapInputData)this.data).connection.close();
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"LdapInput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
            }
        }
        ((LdapInputData)this.data).attributesBinary = null;
        super.dispose();
    }
}

