/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;

public class AS400AuthenticationException
extends AS400SecurityException {
    static final long serialVersionUID = 4L;
    private AS400Message[] msgList_ = null;

    AS400AuthenticationException() {
        this(27);
    }

    AS400AuthenticationException(AS400Message[] list) {
        this(AS400AuthenticationException.getReturnCode(list));
        this.msgList_ = list;
    }

    AS400AuthenticationException(int rc) {
        super(rc);
    }

    public AS400Message getAS400Message() {
        if (this.msgList_ != null && this.msgList_.length > 0) {
            return this.msgList_[0];
        }
        return null;
    }

    public AS400Message[] getAS400MessageList() {
        return this.msgList_;
    }

    static int getReturnCode(AS400Message[] list) {
        for (int i = 0; i < list.length; ++i) {
            String id = list[i].getID().toUpperCase();
            if (id.equals("CPF22E2")) {
                return 8;
            }
            if (id.equals("CPF22E3")) {
                return 31;
            }
            if (id.equals("CPF22E4")) {
                return 7;
            }
            if (id.equals("CPF22E5")) {
                return 6;
            }
            if (id.equals("CPF22E9")) {
                return 4;
            }
            if (id.equals("CPF2204")) {
                return 32;
            }
            if (!id.equals("CPF2217")) continue;
            return 4;
        }
        return 27;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        if (this.getReturnCode() == 27 && this.getAS400Message() != null) {
            sb.append(" >> " + this.getAS400Message().toString());
        }
        return sb.toString();
    }
}

