/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

class ConnectionPoolProperties
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int CCSID_DEFAULT = -1;
    private static boolean defaultPretestConnections_ = false;
    private long cleanupInterval_ = 300000L;
    private int maxConnections_ = -1;
    private long maxInactivity_ = 3600000L;
    private long maxLifetime_ = 86400000L;
    private int maxUseCount_ = -1;
    private long maxUseTime_ = -1L;
    private boolean pretestConnections_ = defaultPretestConnections_;
    private boolean useThreads_ = true;
    private int ccsid_ = -1;
    private transient PropertyChangeSupport changes_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ConnectionPoolProperties connectionPoolProperties = this;
        synchronized (connectionPoolProperties) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(listener);
        }
    }

    public boolean isPretestConnections() {
        return this.pretestConnections_;
    }

    public boolean isThreadUsed() {
        return this.useThreads_;
    }

    public int getCCSID() {
        return this.ccsid_;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval_;
    }

    public int getMaxConnections() {
        return this.maxConnections_;
    }

    public long getMaxInactivity() {
        return this.maxInactivity_;
    }

    public long getMaxLifetime() {
        return this.maxLifetime_;
    }

    public int getMaxUseCount() {
        return this.maxUseCount_;
    }

    public long getMaxUseTime() {
        return this.maxUseTime_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void setCCSID(int ccsid) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setCCSID(" + ccsid + ")");
        }
        String property = "ccsid";
        if (ccsid < -1 || ccsid > 65535) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        int oldValue = this.ccsid_;
        this.ccsid_ = ccsid;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, (Object)oldValue, (Object)ccsid);
        }
    }

    public void setCleanupInterval(long cleanupInterval) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setCleanupInterval(" + cleanupInterval + ")");
        }
        String property = "cleanupInterval";
        if (cleanupInterval < 0L) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        long oldValue = this.cleanupInterval_;
        this.cleanupInterval_ = cleanupInterval;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, oldValue, cleanupInterval);
        }
    }

    public void setMaxConnections(int maxConnections) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setMaxConnections(" + maxConnections + ")");
        }
        String property = "maxConnections";
        if (maxConnections < -1) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        int oldValue = this.maxConnections_;
        this.maxConnections_ = maxConnections;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, (Object)oldValue, (Object)maxConnections);
        }
    }

    public void setMaxInactivity(long maxInactivity) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setMaxInactivity(" + maxInactivity + ")");
        }
        String property = "maxInactivity";
        if (maxInactivity < -1L) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        long oldValue = this.maxInactivity_;
        this.maxInactivity_ = maxInactivity;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, oldValue, maxInactivity);
        }
    }

    public void setMaxLifetime(long maxLifetime) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setMaxLifetime(" + maxLifetime + ")");
        }
        String property = "maxLifetime";
        if (maxLifetime < -1L) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        long oldValue = this.maxLifetime_;
        this.maxLifetime_ = maxLifetime;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, oldValue, maxLifetime);
        }
    }

    public void setPretestConnections(boolean pretest) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setPretestConnections(" + pretest + ")");
        }
        String property = "pretestConnections";
        boolean oldValue = this.pretestConnections_;
        this.pretestConnections_ = pretest;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, (Object)oldValue, (Object)pretest);
        }
    }

    public void setThreadUsed(boolean useThreads, boolean isInUse) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setThreadUsed(" + useThreads + "," + isInUse + ")");
        }
        String property = "threadUsed";
        if (this.useThreads_ == useThreads) {
            return;
        }
        if (isInUse) {
            throw new ExtendedIllegalStateException(property, 5);
        }
        boolean oldValue = this.useThreads_;
        this.useThreads_ = useThreads;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, (Object)oldValue, (Object)useThreads);
        }
    }

    public void setMaxUseCount(int maxUseCount) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setMaxUseCount(" + maxUseCount + ")");
        }
        String property = "maxUseCount";
        if (maxUseCount < -1) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        int oldValue = this.maxUseCount_;
        this.maxUseCount_ = maxUseCount;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, (Object)oldValue, (Object)maxUseCount);
        }
    }

    public void setMaxUseTime(long maxUseTime) {
        if (Trace.traceOn_) {
            Trace.log(1, "ConnectionPoolProperties.setMaxUseTime(" + maxUseTime + ")");
        }
        String property = "maxUseTime";
        if (maxUseTime < -1L) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        long oldValue = this.maxUseTime_;
        this.maxUseTime_ = maxUseTime;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, oldValue, maxUseTime);
        }
    }

    static {
        String propVal = SystemProperties.getProperty("com.ibm.as400.access.ConnectionPool.pretest");
        if (propVal != null) {
            try {
                defaultPretestConnections_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving default pretestConnections property value:", (Throwable)e);
            }
        }
    }
}

