/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.tableexists;

import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="TABLE_EXISTS", name="i18n::ActionTableExists.Name", description="i18n::ActionTableExists.Description", image="TableExists.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionTableExists.keyword"}, documentationUrl="/workflow/actions/tableexists.html")
public class ActionTableExists
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionTableExists.class;
    @HopMetadataProperty(key="tablename", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String tableName = null;
    @HopMetadataProperty(key="schemaname", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String schemaName = null;
    @HopMetadataProperty(key="connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection = null;

    public ActionTableExists(String n) {
        super(n, "");
    }

    public ActionTableExists() {
        this("");
    }

    public Object clone() {
        ActionTableExists je = (ActionTableExists)super.clone();
        return je;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (!Utils.isEmpty((CharSequence)this.connection)) {
            DatabaseMeta dbMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
            if (dbMeta != null) {
                try (Database db = new Database((ILoggingObject)this, (IVariables)this, dbMeta);){
                    db.connect();
                    String realTableName = this.resolve(this.tableName);
                    String realSchemaName = this.resolve(this.schemaName);
                    if (db.checkTableExists(realSchemaName, realTableName)) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableExists", (String[])new String[]{realTableName}));
                        }
                        result.setResult(true);
                    } else if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableNotExists", (String[])new String[]{realTableName}));
                    }
                }
                catch (HopDatabaseException dbe) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.RunningAction", (String[])new String[]{dbe.getMessage()}));
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.NoConnectionDefined", (String[])new String[0]));
        }
        return result;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        DatabaseMeta dbMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
        if (dbMeta != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(dbMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(dbMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

