/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.search.BaseSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@SearchableAnalyserPlugin(id="PipelineMetaSearchAnalyser", name="Search in pipeline metadata")
public class PipelineMetaSearchAnalyser
extends BaseSearchableAnalyser<PipelineMeta>
implements ISearchableAnalyser<PipelineMeta> {
    public Class<PipelineMeta> getSearchableClass() {
        return PipelineMeta.class;
    }

    public List<ISearchResult> search(ISearchable<PipelineMeta> searchable, ISearchQuery searchQuery) {
        PipelineMeta pipelineMeta = (PipelineMeta)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "pipeline name", pipelineMeta.getName(), null);
        this.matchProperty(searchable, results, searchQuery, "pipeline description", pipelineMeta.getDescription(), null);
        for (String parameterName : pipelineMeta.listParameters()) {
            String componentName = "pipeline parameter " + parameterName;
            this.matchProperty(searchable, results, searchQuery, "parameter name", parameterName, componentName);
            try {
                String defaultValue = pipelineMeta.getParameterDefault(parameterName);
                String description = pipelineMeta.getParameterDescription(parameterName);
                this.matchProperty(searchable, results, searchQuery, "parameter default", defaultValue, componentName);
                this.matchProperty(searchable, results, searchQuery, "parameter description", description, componentName);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error searching parameter " + parameterName, (Throwable)e);
            }
        }
        for (TransformMeta transformMeta : pipelineMeta.getTransforms()) {
            String transformName = transformMeta.getName();
            this.matchProperty(searchable, results, searchQuery, "pipeline transform name", transformName, transformName);
            this.matchProperty(searchable, results, searchQuery, "pipeline transform description", transformMeta.getDescription(), transformName);
            String transformPluginId = transformMeta.getTransformPluginId();
            if (transformPluginId != null) {
                this.matchProperty(searchable, results, searchQuery, "pipeline transform plugin ID", transformPluginId, transformName);
                IPlugin transformPlugin = PluginRegistry.getInstance().findPluginWithId(TransformPluginType.class, transformPluginId);
                if (transformPlugin != null) {
                    this.matchProperty(searchable, results, searchQuery, "pipeline transform plugin name", transformPlugin.getName(), transformName);
                }
            }
            ITransformMeta transform = transformMeta.getTransform();
            this.matchObjectFields(searchable, results, searchQuery, transform, "pipeline transform property", transformName);
        }
        for (NotePadMeta note : pipelineMeta.getNotes()) {
            this.matchProperty(searchable, results, searchQuery, "pipeline note", note.getNote(), null);
        }
        return results;
    }
}

