/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.config;

import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.HopTwoWayPasswordEncoder;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import picocli.CommandLine;

public abstract class HopConfigBase
implements Runnable,
IHasHopMetadataProvider {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays this help message and quits."})
    protected boolean helpRequested;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    protected boolean versionRequested;
    @CommandLine.Option(names={"-l", "--level"}, description={"The debug level, one of NOTHING, ERROR, MINIMAL, BASIC, DETAILED, DEBUG, ROWLEVEL"})
    protected String level;
    protected CommandLine cmd;
    protected IVariables variables;
    protected MultiMetadataProvider metadataProvider;
    protected LogChannel log;

    @Override
    public void run() {
        try {
            boolean actionTaken = this.handleConfigMixinsOptions(this.log);
            if (!actionTaken) {
                this.cmd.usage(System.out);
            }
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.cmd, "There was an error handling options", (Throwable)e);
        }
    }

    private boolean handleConfigMixinsOptions(LogChannel log) throws HopException {
        boolean actionTaken = false;
        Map mixins = this.cmd.getMixins();
        for (String key : mixins.keySet()) {
            Object mixin = mixins.get(key);
            if (!(mixin instanceof IConfigOptions)) continue;
            IConfigOptions configOptions = (IConfigOptions)mixin;
            actionTaken = configOptions.handleOption((ILogChannel)log, (IHasHopMetadataProvider)this, this.variables) || actionTaken;
        }
        return actionTaken;
    }

    protected LogLevel determineLogLevel() {
        return LogLevel.lookupCode((String)this.variables.resolve(this.level));
    }

    protected void buildMetadataProvider() {
        ArrayList<JsonMetadataProvider> providers = new ArrayList<JsonMetadataProvider>();
        String folder = this.variables.getVariable("HOP_METADATA_FOLDER");
        if (StringUtils.isEmpty((String)folder)) {
            providers.add(new JsonMetadataProvider());
        } else {
            ITwoWayPasswordEncoder passwordEncoder = Encr.getEncoder();
            if (passwordEncoder == null) {
                passwordEncoder = new HopTwoWayPasswordEncoder();
            }
            providers.add(new JsonMetadataProvider(passwordEncoder, folder, this.variables));
        }
        this.metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), providers, this.variables);
    }

    protected void buildLogChannel() {
        this.log = new LogChannel((Object)"hop-config");
        this.log.setSimplified(true);
        this.log.setLogLevel(this.determineLogLevel());
        this.log.logDetailed("Start of Hop Config");
    }

    @Generated
    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    @Generated
    public boolean isVersionRequested() {
        return this.versionRequested;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public LogChannel getLog() {
        return this.log;
    }

    @Generated
    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    @Generated
    public void setVersionRequested(boolean versionRequested) {
        this.versionRequested = versionRequested;
    }

    @Generated
    public void setLevel(String level) {
        this.level = level;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setLog(LogChannel log) {
        this.log = log;
    }
}

