/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.DeletedSecretHelper;
import com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DeletedSecret
extends KeyVaultSecret {
    private String recoveryId;
    private OffsetDateTime scheduledPurgeDate;
    private OffsetDateTime deletedOn;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("value", this.getValue()).writeStringField("recoveryId", this.recoveryId).writeEndObject();
    }

    public static DeletedSecret fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedSecret)jsonReader.readObject(reader -> {
            DeletedSecret deletedSecret = new DeletedSecret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deletedSecret.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deletedSecret.properties.id = reader.getString();
                    SecretsModelsUtils.unpackId(deletedSecret.properties.id, name -> {
                        deletedSecret.properties.name = name;
                    }, version -> {
                        deletedSecret.properties.version = version;
                    });
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    SecretProperties.deserializeAttributes(reader, deletedSecret.properties);
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deletedSecret.properties.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deletedSecret.properties.keyId = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deletedSecret.properties.contentType = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    deletedSecret.properties.tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deletedSecret.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deletedSecret.scheduledPurgeDate = (OffsetDateTime)reader.getNullable(SecretsModelsUtils::epochToOffsetDateTime);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deletedSecret.deletedOn = (OffsetDateTime)reader.getNullable(SecretsModelsUtils::epochToOffsetDateTime);
                    continue;
                }
                reader.skipChildren();
            }
            return deletedSecret;
        });
    }

    static {
        DeletedSecretHelper.setAccessor(new DeletedSecretHelper.DeletedSecretAccessor(){

            @Override
            public void setRecoveryId(DeletedSecret deletedSecret, String recoveryId) {
                deletedSecret.recoveryId = recoveryId;
            }

            @Override
            public void setScheduledPurgeDate(DeletedSecret deletedSecret, OffsetDateTime scheduledPurgeDate) {
                deletedSecret.scheduledPurgeDate = scheduledPurgeDate;
            }

            @Override
            public void setDeletedOn(DeletedSecret deletedSecret, OffsetDateTime deletedOn) {
                deletedSecret.deletedOn = deletedOn;
            }
        });
    }
}

