/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.plugins.ParentFirst;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutput;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.SSTableOutputData;

@Transform(id="SSTableOutput", image="cassandra.svg", name="SSTable output", documentationUrl="/pipeline/transforms/sstable-output.html", description="Writes to a filesystem directory as a Cassandra SSTable", keywords={"i18n::SSTableOutputMeta.keyword"}, categoryDescription="Cassandra")
@ParentFirst(patterns={".*"})
public class SSTableOutputMeta
extends BaseTransformMeta<SSTableOutput, SSTableOutputData> {
    protected static final Class<?> PKG = SSTableOutputMeta.class;
    @HopMetadataProperty(key="yaml_path", injectionKey="YAML_FILE_PATH", injectionKeyDescription="SSTableOutput.Injection.YAML_FILE_PATH")
    protected String yamlPath;
    @HopMetadataProperty(key="output_directory", injectionKey="DIRECTORY", injectionKeyDescription="SSTableOutput.Injection.DIRECTORY")
    protected String directory;
    @HopMetadataProperty(key="cassandra_keyspace", injectionKey="CASSANDRA_KEYSPACE", injectionKeyDescription="SSTableOutput.Injection.CASSANDRA_KEYSPACE")
    protected String cassandraKeyspace;
    @HopMetadataProperty(key="table", injectionKey="TABLE", injectionKeyDescription="SSTableOutput.Injection.TABLE")
    protected String table = "";
    @HopMetadataProperty(key="key_field", injectionKey="KEY_FIELD", injectionKeyDescription="SSTableOutput.Injection.KEY_FIELD")
    protected String keyField = "";
    @HopMetadataProperty(key="buffer_size_mb", injectionKey="BUFFER_SIZE", injectionKeyDescription="SSTableOutput.Injection.BUFFER_SIZE")
    protected String bufferSize = "16";

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, "Not receiving any fields from previous transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void setDefault() {
        this.directory = System.getProperty("java.io.tmpdir");
        this.bufferSize = "16";
        this.table = "";
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getYamlPath() {
        return this.yamlPath;
    }

    public void setYamlPath(String path) {
        this.yamlPath = path;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.cassandraKeyspace;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }
}

