/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.terafast;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.AbstractTransformMeta;
import org.apache.hop.core.util.BooleanPluginProperty;
import org.apache.hop.core.util.IntegerPluginProperty;
import org.apache.hop.core.util.PluginMessages;
import org.apache.hop.core.util.StringListPluginProperty;
import org.apache.hop.core.util.StringPluginProperty;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="TeraFast", image="terafast.svg", description="i18n::TeraFast.Description", name="i18n::TeraFast.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", keywords={"i18n::TeraFastMeta.keyword"}, documentationUrl="/pipeline/transforms/terafast.html", actionTransformTypes={ActionTransformType.RDBMS, ActionTransformType.OUTPUT})
public class TeraFastMeta
extends AbstractTransformMeta<ITransform, ITransformData> {
    public static final PluginMessages MESSAGES = PluginMessages.getMessages(TeraFastMeta.class);
    public static final String DEFAULT_FASTLOAD_PATH = "/usr/bin/fastload";
    public static final String DEFAULT_DATA_FILE = "${Internal.Transform.CopyNr}.dat";
    public static final String DEFAULT_TARGET_TABLE = "${TARGET_TABLE}_${RUN_ID}";
    public static final int DEFAULT_SESSIONS = 2;
    public static final boolean DEFAULT_TRUNCATETABLE = true;
    public static final boolean DEFAULT_VARIABLE_SUBSTITUTION = true;
    public static final int DEFAULT_ERROR_LIMIT = 25;
    private static final String FASTLOADPATH = "fastload_path";
    private static final String CONTROLFILE = "controlfile_path";
    private static final String DATAFILE = "datafile_path";
    private static final String LOGFILE = "logfile_path";
    private static final String SESSIONS = "sessions";
    private static final String ERRORLIMIT = "error_limit";
    private static final String USECONTROLFILE = "use_control_file";
    private static final String TARGETTABLE = "target_table";
    private static final String TRUNCATETABLE = "truncate_table";
    private static final String TABLE_FIELD_LIST = "table_field_list";
    private static final String STREAM_FIELD_LIST = "stream_field_list";
    private static final String VARIABLE_SUBSTITUTION = "variable_substitution";
    private StringPluginProperty fastloadPath = this.getPropertyFactory().createString("fastload_path");
    private StringPluginProperty controlFile = this.getPropertyFactory().createString("controlfile_path");
    private StringPluginProperty dataFile = this.getPropertyFactory().createString("datafile_path");
    private StringPluginProperty logFile = this.getPropertyFactory().createString("logfile_path");
    private IntegerPluginProperty sessions = this.getPropertyFactory().createInteger("sessions");
    private IntegerPluginProperty errorLimit = this.getPropertyFactory().createInteger("error_limit");
    private BooleanPluginProperty useControlFile;
    private BooleanPluginProperty variableSubstitution;
    private BooleanPluginProperty truncateTable;
    private StringPluginProperty targetTable = this.getPropertyFactory().createString("target_table");
    private StringListPluginProperty tableFieldList;
    private StringListPluginProperty streamFieldList;

    public TeraFastMeta() {
        this.useControlFile = this.getPropertyFactory().createBoolean(USECONTROLFILE);
        this.truncateTable = this.getPropertyFactory().createBoolean(TRUNCATETABLE);
        this.tableFieldList = this.getPropertyFactory().createStringList(TABLE_FIELD_LIST);
        this.streamFieldList = this.getPropertyFactory().createStringList(STREAM_FIELD_LIST);
        this.variableSubstitution = this.getPropertyFactory().createBoolean(VARIABLE_SUBSTITUTION);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        try {
            IRowMeta tableFields = this.getRequiredFields(variables);
            CheckResult checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.ConnectionEstablished"), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)checkResult);
            checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.TableExists"), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)checkResult);
            boolean error = false;
            for (String field : (List)this.tableFieldList.getValue()) {
                if (tableFields.searchValueMeta(field) != null) continue;
                error = true;
                checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.TableFieldNotFound"), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)checkResult);
            }
            if (!error) {
                checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.AllTableFieldsFound"), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)checkResult);
            }
            if (prev != null && !prev.isEmpty()) {
                checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.TransformInputDataFound"), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)checkResult);
                error = false;
                for (String field : (List)this.streamFieldList.getValue()) {
                    if (prev.searchValueMeta(field) != null) continue;
                    error = true;
                    checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.StreamFieldNotFound"), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)checkResult);
                }
                if (!error) {
                    checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.AllStreamFieldsFound"), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)checkResult);
                }
            }
        }
        catch (HopDatabaseException e) {
            CheckResult checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.ConnectionFailed"), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)checkResult);
        }
        catch (HopException e) {
            CheckResult checkResult = new CheckResult(4, e.getMessage(), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)checkResult);
        }
    }

    public Database connectToDatabase(IVariables variables) throws HopException {
        if (this.getDbMeta() != null) {
            Database db = new Database(loggingObject, variables, this.getDbMeta());
            db.connect();
            return db;
        }
        throw new HopException(MESSAGES.getString("TeraFastMeta.Exception.ConnectionNotDefined"));
    }

    public void setDefault() {
        this.fastloadPath.setValue((Object)DEFAULT_FASTLOAD_PATH);
        this.dataFile.setValue((Object)DEFAULT_DATA_FILE);
        this.sessions.setValue((Object)2);
        this.errorLimit.setValue((Object)25);
        this.truncateTable.setValue((Object)true);
        this.variableSubstitution.setValue((Object)true);
        this.targetTable.setValue((Object)DEFAULT_TARGET_TABLE);
        this.useControlFile.setValue((Object)true);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        if (!((Boolean)this.useControlFile.getValue()).booleanValue()) {
            Database database = this.connectToDatabase(variables);
            IRowMeta fields = database.getTableFieldsMeta("", variables.resolve((String)this.targetTable.getValue()));
            database.disconnect();
            if (fields == null) {
                throw new HopException(MESSAGES.getString("TeraFastMeta.Exception.TableNotFound"));
            }
            return fields;
        }
        return null;
    }

    public Object clone() {
        return super.clone();
    }

    public StringPluginProperty getFastloadPath() {
        return this.fastloadPath;
    }

    public void setFastloadPath(StringPluginProperty fastloadPath) {
        this.fastloadPath = fastloadPath;
    }

    public StringPluginProperty getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(StringPluginProperty controlFile) {
        this.controlFile = controlFile;
    }

    public StringPluginProperty getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(StringPluginProperty dataFile) {
        this.dataFile = dataFile;
    }

    public StringPluginProperty getLogFile() {
        return this.logFile;
    }

    public void setLogFile(StringPluginProperty logFile) {
        this.logFile = logFile;
    }

    public IntegerPluginProperty getSessions() {
        return this.sessions;
    }

    public void setSessions(IntegerPluginProperty sessions) {
        this.sessions = sessions;
    }

    public IntegerPluginProperty getErrorLimit() {
        return this.errorLimit;
    }

    public void setErrorLimit(IntegerPluginProperty errorLimit) {
        this.errorLimit = errorLimit;
    }

    public BooleanPluginProperty getUseControlFile() {
        return this.useControlFile;
    }

    public void setUseControlFile(BooleanPluginProperty useControlFile) {
        this.useControlFile = useControlFile;
    }

    public StringPluginProperty getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(StringPluginProperty targetTable) {
        this.targetTable = targetTable;
    }

    public BooleanPluginProperty getTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(BooleanPluginProperty truncateTable) {
        this.truncateTable = truncateTable;
    }

    public StringListPluginProperty getTableFieldList() {
        return this.tableFieldList;
    }

    public void setTableFieldList(StringListPluginProperty tableFieldList) {
        this.tableFieldList = tableFieldList;
    }

    public StringListPluginProperty getStreamFieldList() {
        return this.streamFieldList;
    }

    public void setStreamFieldList(StringListPluginProperty streamFieldList) {
        this.streamFieldList = streamFieldList;
    }

    public BooleanPluginProperty getVariableSubstitution() {
        return this.variableSubstitution;
    }

    public void setVariableSubstitution(BooleanPluginProperty variableSubstitution) {
        this.variableSubstitution = variableSubstitution;
    }
}

