/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerows;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueField;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRowsData;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRowsMeta;

public class UniqueRows
extends BaseTransform<UniqueRowsMeta, UniqueRowsData> {
    private static final Class<?> PKG = UniqueRowsMeta.class;

    public UniqueRows(TransformMeta transformMeta, UniqueRowsMeta meta, UniqueRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (((UniqueRowsData)this.data).previous != null) {
                Object[] outputRow = this.addCounter(((UniqueRowsData)this.data).outputRowMeta, ((UniqueRowsData)this.data).previous, ((UniqueRowsData)this.data).counter);
                this.putRow(((UniqueRowsData)this.data).outputRowMeta, outputRow);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            ((UniqueRowsData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((UniqueRowsData)this.data).compareRowMeta = this.getInputRowMeta().clone();
            ((UniqueRowsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((UniqueRowsMeta)this.meta).getFields(((UniqueRowsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((UniqueRowsData)this.data).previous = ((UniqueRowsData)this.data).inputRowMeta.cloneRow(r);
            List<UniqueField> fields = ((UniqueRowsMeta)this.meta).getCompareFields();
            ((UniqueRowsData)this.data).fieldnrs = new int[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                UniqueField field = fields.get(i);
                ((UniqueRowsData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(field.getName());
                if (((UniqueRowsData)this.data).fieldnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"UniqueRows.Log.CouldNotFindFieldInRow", (String[])new String[]{field.getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                ((UniqueRowsData)this.data).compareRowMeta.getValueMeta(((UniqueRowsData)this.data).fieldnrs[i]).setCaseInsensitive(field.isCaseInsensitive());
                if (!((UniqueRowsData)this.data).sendDuplicateRows) continue;
                ((UniqueRowsData)this.data).compareFields = ((UniqueRowsData)this.data).compareFields == null ? field.getName() : ((UniqueRowsData)this.data).compareFields + "," + field.getName();
            }
            if (((UniqueRowsData)this.data).sendDuplicateRows && !Utils.isEmpty((CharSequence)((UniqueRowsMeta)this.meta).getErrorDescription())) {
                ((UniqueRowsData)this.data).realErrorDescription = this.resolve(((UniqueRowsMeta)this.meta).getErrorDescription());
            }
        }
        if (((UniqueRowsData)this.data).previous == null) {
            ((UniqueRowsData)this.data).previous = ((UniqueRowsData)this.data).inputRowMeta.cloneRow(r);
        }
        boolean isEqual = false;
        if (Utils.isEmpty(((UniqueRowsMeta)this.meta).getCompareFields())) {
            isEqual = ((UniqueRowsData)this.data).outputRowMeta.compare(r, ((UniqueRowsData)this.data).previous) == 0;
        } else {
            boolean bl = isEqual = ((UniqueRowsData)this.data).outputRowMeta.compare(r, ((UniqueRowsData)this.data).previous, ((UniqueRowsData)this.data).fieldnrs) == 0;
        }
        if (!isEqual) {
            Object[] outputRow = this.addCounter(((UniqueRowsData)this.data).outputRowMeta, ((UniqueRowsData)this.data).previous, ((UniqueRowsData)this.data).counter);
            this.putRow(((UniqueRowsData)this.data).outputRowMeta, outputRow);
            ((UniqueRowsData)this.data).previous = ((UniqueRowsData)this.data).inputRowMeta.cloneRow(r);
            ((UniqueRowsData)this.data).counter = 1L;
        } else {
            if (((UniqueRowsData)this.data).sendDuplicateRows && !this.first) {
                this.putError(((UniqueRowsData)this.data).outputRowMeta, RowDataUtil.addValueData((Object[])r, (int)(((UniqueRowsData)this.data).outputRowMeta.size() - 1), (Object)((UniqueRowsData)this.data).counter), 1L, ((UniqueRowsData)this.data).realErrorDescription, Utils.isEmpty((CharSequence)((UniqueRowsData)this.data).compareFields) ? null : ((UniqueRowsData)this.data).compareFields, "UNR001");
            }
            ++((UniqueRowsData)this.data).counter;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"UniqueRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        this.first = false;
        return true;
    }

    private Object[] addCounter(IRowMeta outputRowMeta, Object[] r, long count) {
        if (((UniqueRowsMeta)this.meta).isCountRows()) {
            return RowDataUtil.addValueData((Object[])r, (int)(outputRowMeta.size() - 1), (Object)count);
        }
        return r;
    }

    public boolean init() {
        if (super.init()) {
            ((UniqueRowsData)this.data).sendDuplicateRows = this.getTransformMeta().getTransformErrorMeta() != null && ((UniqueRowsMeta)this.meta).supportsErrorHandling();
            return true;
        }
        return false;
    }

    public void batchComplete() throws HopException {
        if (((UniqueRowsData)this.data).previous != null) {
            Object[] outputRow = this.addCounter(((UniqueRowsData)this.data).outputRowMeta, ((UniqueRowsData)this.data).previous, ((UniqueRowsData)this.data).counter);
            this.putRow(((UniqueRowsData)this.data).outputRowMeta, outputRow);
            ((UniqueRowsData)this.data).previous = null;
        }
    }
}

