/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filestoresult;

import org.apache.hop.core.ResultFile;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.filestoresult.FilesToResultMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FilesToResultDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = FilesToResultMeta.class;
    private CCombo wFilenameField;
    private List wTypes;
    private final FilesToResultMeta input;

    public FilesToResultDialog(Shell parent, IVariables variables, FilesToResultMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFilenameField = new Label((Composite)this.shell, 131072);
        wlFilenameField.setText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, 0);
        fdlFilenameField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlFilenameField.right = new FormAttachment(middle, -margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)this.shell, 18436);
        this.wFilenameField.setToolTipText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.FilenameField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, 0);
        fdFilenameField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdFilenameField.right = new FormAttachment(100, 0);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        Runnable runnable = () -> {
            try {
                IRowMeta inputfields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (inputfields != null) {
                    for (int i = 0; i < inputfields.size(); ++i) {
                        this.wFilenameField.add(inputfields.getValueMeta(i).getName());
                    }
                }
            }
            catch (Exception ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FilesToResultDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FilesToResultDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), ke);
            }
        };
        display.asyncExec(runnable);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlTypes = new Label((Composite)this.shell, 131072);
        wlTypes.setText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.TypeOfFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypes);
        FormData fdlTypes = new FormData();
        fdlTypes.left = new FormAttachment(0, 0);
        fdlTypes.top = new FormAttachment((Control)this.wFilenameField, margin);
        fdlTypes.right = new FormAttachment(middle, -margin);
        wlTypes.setLayoutData((Object)fdlTypes);
        this.wTypes = new List((Composite)this.shell, 2820);
        this.wTypes.setToolTipText(BaseMessages.getString(PKG, (String)"FilesToResultDialog.TypeOfFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTypes);
        FormData fdTypes = new FormData();
        fdTypes.left = new FormAttachment(middle, 0);
        fdTypes.top = new FormAttachment((Control)this.wFilenameField, margin);
        fdTypes.bottom = new FormAttachment((Control)this.wOk, -margin * 3);
        fdTypes.right = new FormAttachment(100, 0);
        this.wTypes.setLayoutData((Object)fdTypes);
        for (int i = 0; i < ResultFile.getAllTypeDesc().length; ++i) {
            this.wTypes.add(ResultFile.getAllTypeDesc()[i]);
        }
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        ResultFile.FileType fileType = this.input.getFileType();
        this.wTypes.select(fileType == null ? ResultFile.FileType.GENERAL.getType() : fileType.getType());
        if (this.input.getFilenameField() != null) {
            this.wFilenameField.setText(this.input.getFilenameField());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setFilenameField(this.wFilenameField.getText());
        if (this.wTypes.getSelectionIndex() >= 0) {
            this.input.setFileType(ResultFile.FileType.lookupDescription((String)this.wTypes.getSelection()[0]));
        } else {
            this.input.setFileType(ResultFile.FileType.GENERAL);
        }
        this.dispose();
    }
}

