/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.DelegatingCounter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.StringSet;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Metrics.class);
    public static final @UnknownKeyFor @NonNull @Initialized String THROTTLE_TIME_NAMESPACE = "beam-throttling-metrics";
    public static final @UnknownKeyFor @NonNull @Initialized String THROTTLE_TIME_COUNTER_NAME = "throttling-msecs";

    private Metrics() {
    }

    @Internal
    public static void setDefaultPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        MetricsFlag flag = (MetricsFlag)MetricsFlag.INSTANCE.get();
        if (flag == null) {
            boolean stringSetDisabled;
            ExperimentalOptions exp = options.as(ExperimentalOptions.class);
            boolean counterDisabled = ExperimentalOptions.hasExperiment(exp, "disableCounterMetrics");
            if (counterDisabled) {
                LOG.info("Counter metrics are disabled.");
            }
            if (stringSetDisabled = ExperimentalOptions.hasExperiment(exp, "disableStringSetMetrics")) {
                LOG.info("StringSet metrics are disabled");
            }
            MetricsFlag.INSTANCE.compareAndSet(null, new MetricsFlag(counterDisabled, stringSetDisabled));
        }
    }

    @Internal
    static void resetDefaultPipelineOptions() {
        MetricsFlag.INSTANCE.set(null);
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter counter(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter counter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Distribution distribution(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Distribution distribution(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge gauge(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge gauge(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized StringSet stringSet(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingStringSet(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized StringSet stringSet(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingStringSet(MetricName.named(namespace, name));
    }

    private static class DelegatingStringSet
    implements Metric,
    StringSet,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private DelegatingStringSet(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        @Override
        public void add(@UnknownKeyFor @NonNull @Initialized String value) {
            if (MetricsFlag.stringSetDisabled()) {
                return;
            }
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getStringSet(this.name).add(value);
            }
        }

        @Override
        public void add(String ... value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getStringSet(this.name).add(value);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }

    private static class DelegatingGauge
    implements Metric,
    Gauge,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private DelegatingGauge(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        @Override
        public void set(@UnknownKeyFor @NonNull @Initialized long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getGauge(this.name).set(value);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }

    private static class DelegatingDistribution
    implements Metric,
    Distribution,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private DelegatingDistribution(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(value);
            }
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(sum, count, min, max);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }

    static class MetricsFlag {
        private static final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized MetricsFlag> INSTANCE = new AtomicReference();
        final @UnknownKeyFor @NonNull @Initialized boolean counterDisabled;
        final @UnknownKeyFor @NonNull @Initialized boolean stringSetDisabled;

        private MetricsFlag(@UnknownKeyFor @NonNull @Initialized boolean counterDisabled, @UnknownKeyFor @NonNull @Initialized boolean stringSetDisabled) {
            this.counterDisabled = counterDisabled;
            this.stringSetDisabled = stringSetDisabled;
        }

        static @UnknownKeyFor @NonNull @Initialized boolean counterDisabled() {
            MetricsFlag flag = INSTANCE.get();
            return flag != null && flag.counterDisabled;
        }

        static @UnknownKeyFor @NonNull @Initialized boolean stringSetDisabled() {
            MetricsFlag flag = INSTANCE.get();
            return flag != null && flag.stringSetDisabled;
        }
    }
}

