/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.filesexist;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.filesexist.FileItem;

@Action(id="FILES_EXIST", name="i18n::ActionFilesExist.Name", description="i18n::ActionFilesExist.Description", image="FilesExist.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionFilesExist.Keyword"}, documentationUrl="/workflow/actions/filesexist.html")
public class ActionFilesExist
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFilesExist.class;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<FileItem> fileItems;

    public ActionFilesExist(String name) {
        super(name, "");
        this.fileItems = List.of();
    }

    public ActionFilesExist() {
        this("");
    }

    public ActionFilesExist(ActionFilesExist other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.fileItems = new ArrayList<FileItem>(other.fileItems);
    }

    public Object clone() {
        return new ActionFilesExist(this);
    }

    public Result execute(Result result, int nr) {
        result.setResult(false);
        result.setNrErrors(0L);
        int missingFiles = 0;
        int nrErrors = 0;
        if (this.fileItems != null) {
            for (FileItem item : this.fileItems) {
                if (this.parentWorkflow.isStopped()) break;
                String path = this.resolve(item.getFileName());
                try (FileObject file = HopVfs.getFileObject((String)path, (IVariables)this.getVariables());){
                    if (file.exists() && file.isReadable()) {
                        if (!this.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFilesExist.File_Exists", (String[])new String[]{path}));
                        continue;
                    }
                    ++missingFiles;
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFilesExist.File_Does_Not_Exist", (String[])new String[]{path}));
                }
                catch (Exception e) {
                    ++nrErrors;
                    ++missingFiles;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFilesExist.ERROR_0004_IO_Exception", (String[])new String[]{e.toString()}), e);
                }
            }
        }
        result.setNrErrors((long)nrErrors);
        if (missingFiles == 0) {
            result.setResult(true);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (Utils.isEmpty(this.fileItems)) {
            String message = BaseMessages.getString(PKG, (String)"ActionFilesExist.CheckResult.NothingToCheck", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(3, message, (ICheckResultSource)this));
        }
    }

    @Generated
    public void setFileItems(List<FileItem> fileItems) {
        this.fileItems = fileItems;
    }

    @Generated
    public List<FileItem> getFileItems() {
        return this.fileItems;
    }
}

