/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocolPB.InMemoryAliasMapProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryLevelDBAliasMapClient
extends BlockAliasMap<FileRegion>
implements Configurable {
    private Configuration conf;
    private InMemoryAliasMapProtocolClientSideTranslatorPB aliasMap;
    private String blockPoolID;

    @Override
    public void close() {
        this.aliasMap.stop();
    }

    InMemoryLevelDBAliasMapClient() {
        if (UserGroupInformation.isSecurityEnabled()) {
            throw new UnsupportedOperationException("Unable to start InMemoryLevelDBAliasMapClient as security is enabled");
        }
    }

    @Override
    public BlockAliasMap.Reader<FileRegion> getReader(BlockAliasMap.Reader.Options opts, String blockPoolID) throws IOException {
        if (this.blockPoolID == null) {
            this.blockPoolID = this.aliasMap.getBlockPoolId();
        }
        if (blockPoolID != null && this.blockPoolID != null && !this.blockPoolID.equals(blockPoolID)) {
            return null;
        }
        return new LevelDbReader();
    }

    @Override
    public BlockAliasMap.Writer<FileRegion> getWriter(BlockAliasMap.Writer.Options opts, String blockPoolID) throws IOException {
        if (this.blockPoolID == null) {
            this.blockPoolID = this.aliasMap.getBlockPoolId();
        }
        if (blockPoolID != null && !this.blockPoolID.equals(blockPoolID)) {
            return null;
        }
        return new LevelDbWriter();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.aliasMap = new InMemoryAliasMapProtocolClientSideTranslatorPB(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() throws IOException {
    }

    class LevelDbWriter
    extends BlockAliasMap.Writer<FileRegion> {
        LevelDbWriter() {
        }

        @Override
        public void store(FileRegion fileRegion) throws IOException {
            InMemoryLevelDBAliasMapClient.this.aliasMap.write(fileRegion.getBlock(), fileRegion.getProvidedStorageLocation());
        }

        @Override
        public void close() throws IOException {
        }
    }

    class LevelDbReader
    extends BlockAliasMap.Reader<FileRegion> {
        LevelDbReader() {
        }

        @Override
        public Optional<FileRegion> resolve(Block block) throws IOException {
            Optional<ProvidedStorageLocation> read = InMemoryLevelDBAliasMapClient.this.aliasMap.read(block);
            return read.map(psl -> new FileRegion(block, (ProvidedStorageLocation)psl));
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Iterator<FileRegion> iterator() {
            return new LevelDbIterator();
        }

        private class LevelDbIterator
        extends BlockAliasMap.ImmutableIterator {
            private Iterator<FileRegion> iterator;
            private Optional<Block> nextMarker;

            LevelDbIterator() {
                this.batch(Optional.empty());
            }

            private void batch(Optional<Block> newNextMarker) {
                try {
                    InMemoryAliasMapProtocol.IterationResult iterationResult = InMemoryLevelDBAliasMapClient.this.aliasMap.list(newNextMarker);
                    List<FileRegion> fileRegions = iterationResult.getFileRegions();
                    this.iterator = fileRegions.iterator();
                    this.nextMarker = iterationResult.getNextBlock();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || this.nextMarker.isPresent();
            }

            @Override
            public FileRegion next() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                if (this.nextMarker.isPresent()) {
                    this.batch(this.nextMarker);
                    return this.next();
                }
                throw new NoSuchElementException();
            }
        }
    }
}

